/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue;

import com.gridnine.xtrip.common.gds.model.AirlineMessage;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.TravelItineraryHistoryRS;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class AirlineMessagesTravelItineraryHistoryRSProcessor
extends BaseProcessor {
    private static final Set<String> AIRLINE_PCCS = new HashSet<String>(Arrays.asList("PLT", "HDQ"));
    private static final Set<String> SSR_ACTIONS = new HashSet<String>(Arrays.asList("A3S", "A4S"));
    private static final Pattern P_SSR = Pattern.compile("SSR (?<type>[A-Z]{4})( (?<source>[A-Z0-9]{2}))?[ \\.](?<message>.+)");
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");

    public void process(MessageContext ctx) throws Exception {
        TravelItineraryHistoryRS response = (TravelItineraryHistoryRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        ArrayList<AirlineMessage> airlineMessages = new ArrayList<AirlineMessage>();
        if (response.getHistoricalInfoList() != null) {
            for (TravelItineraryHistoryRS.HistoricalInfo historicalInfo : response.getHistoricalInfoList()) {
                if (historicalInfo.getItineraryRef() == null || historicalInfo.getItineraryRef().getSource() == null || !AIRLINE_PCCS.contains(historicalInfo.getItineraryRef().getSource().getPseudoCityCode()) || historicalInfo.getGeneralInfoList() == null) continue;
                String designator = null;
                AirlineMessage airlineMessage = null;
                for (TravelItineraryHistoryRS.HistoricalInfo.GeneralInfo generalInfo : historicalInfo.getGeneralInfoList()) {
                    if (!SSR_ACTIONS.contains(generalInfo.getAction())) continue;
                    Matcher m = P_SSR.matcher(generalInfo.getText());
                    if (!m.matches()) {
                        throw Xeption.forDeveloper((String)"P_SSR mismatch: {0}", (Object[])new Object[]{generalInfo.getText()});
                    }
                    String type = m.group("type");
                    String source = m.group("source");
                    String message = m.group("message");
                    String newDesignator = generalInfo.getAction() + type + source;
                    if (!MiscUtil.equals(designator, (Object)newDesignator)) {
                        if (airlineMessage != null) {
                            airlineMessage.setMessage(airlineMessage.getMessage().trim());
                            airlineMessages.add(airlineMessage);
                        }
                        airlineMessage = new AirlineMessage();
                        airlineMessage.setType(type);
                        airlineMessage.setMessage(message);
                        if (!StringUtils.isBlank((String)historicalInfo.getItineraryRef().getSource().getCreateDateTime())) {
                            airlineMessage.setDate(LocalDateTime.parse(historicalInfo.getItineraryRef().getSource().getCreateDateTime(), DTF));
                        }
                        designator = newDesignator;
                        continue;
                    }
                    if (airlineMessage.getMessage().equals(message)) continue;
                    airlineMessage.setMessage(airlineMessage.getMessage() + "\n" + message);
                }
                airlineMessages.add(airlineMessage);
            }
        }
        ctx.putObject((Enum)IBusGdsQueueContextKeys.AIRLINE_MESSAGES, airlineMessages);
    }
}

