/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue;

import com.gridnine.xtrip.common.gds.model.QueueWatchEventType;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.TravelItineraryHistoryRS;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class CheckDupeProcessor
extends BaseProcessor {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");

    public void process(MessageContext ctx) throws Exception {
        TravelItineraryHistoryRS response = (TravelItineraryHistoryRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Map handledEvents = (Map)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_HANDLED_EVENTS);
        HashMap<String, LocalDateTime> possibleDupeInfo = new HashMap<String, LocalDateTime>();
        if (response.getHistoricalInfoList() != null) {
            for (TravelItineraryHistoryRS.HistoricalInfo historicalInfo : response.getHistoricalInfoList()) {
                if (historicalInfo.getRemarkInfo() == null || historicalInfo.getRemarkInfo().getRemarkList().isEmpty()) continue;
                this.checkForPossibleDupeRemark(historicalInfo, possibleDupeInfo);
            }
        }
        LocalDateTime dupeDateTime = null;
        for (Map.Entry entry : possibleDupeInfo.entrySet()) {
            if (dupeDateTime != null && !((LocalDateTime)entry.getValue()).isAfter(dupeDateTime)) continue;
            dupeDateTime = (LocalDateTime)entry.getValue();
        }
        LocalDateTime handledDateTime = (LocalDateTime)handledEvents.get(QueueWatchEventType.DUPE_WARNING);
        if (dupeDateTime != null && (handledDateTime == null || handledDateTime.isBefore(dupeDateTime))) {
            ctx.putObject((Enum)IBusGdsQueueContextKeys.DUPE_FALSE_POSITIVE, (Object)Boolean.FALSE);
            return;
        }
        ctx.putObject((Enum)IBusGdsQueueContextKeys.DUPE_FALSE_POSITIVE, (Object)Boolean.TRUE);
    }

    private void checkForPossibleDupeRemark(TravelItineraryHistoryRS.HistoricalInfo historicalInfo, Map<String, LocalDateTime> possibleDupeInfo) {
        for (TravelItineraryHistoryRS.HistoricalInfo.RemarkInfo.Remark remark : historicalInfo.getRemarkInfo().getRemarkList()) {
            if (remark.getText() == null || !remark.getText().startsWith("H-POSSIBLE DUPE BOOKING. SEE PNR")) continue;
            this.updatePossibleDupeInfo(possibleDupeInfo, remark.getText(), LocalDateTime.parse(historicalInfo.getItineraryRef().getSource().getCreateDateTime(), DTF));
        }
    }

    private void updatePossibleDupeInfo(Map<String, LocalDateTime> possibleDupeInfo, String newMessage, LocalDateTime newDateTime) {
        LocalDateTime oldDateTime = possibleDupeInfo.get(newMessage);
        if (oldDateTime == null) {
            possibleDupeInfo.put(newMessage, newDateTime);
            return;
        }
        if (newDateTime.isBefore(oldDateTime)) {
            possibleDupeInfo.put(newMessage, newDateTime);
        }
    }
}

