/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue;

import com.gridnine.xtrip.common.gds.model.QueueWatchEventType;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.TravelItineraryHistoryRS;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class HandledEventsTravelItineraryHistoryRSProcessor
extends BaseProcessor {
    private static final String PREFIX = "H-G9Q / ";
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");

    public void process(MessageContext ctx) throws Exception {
        TravelItineraryHistoryRS response = (TravelItineraryHistoryRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        HashMap<QueueWatchEventType, LocalDateTime> handledEvents = new HashMap<QueueWatchEventType, LocalDateTime>();
        if (response.getHistoricalInfoList() != null) {
            for (TravelItineraryHistoryRS.HistoricalInfo historicalInfo : response.getHistoricalInfoList()) {
                if (historicalInfo.getItineraryRef() == null || historicalInfo.getItineraryRef().getSource() == null || StringUtils.isBlank((String)historicalInfo.getItineraryRef().getSource().getCreateDateTime()) || historicalInfo.getRemarkInfo() == null || historicalInfo.getRemarkInfo().getRemarkList() == null) continue;
                for (TravelItineraryHistoryRS.HistoricalInfo.RemarkInfo.Remark remark : historicalInfo.getRemarkInfo().getRemarkList()) {
                    if (!"A5H".equals(remark.getAction()) || remark.getText() == null || !remark.getText().startsWith(PREFIX)) continue;
                    String eventTypeStr = remark.getText().substring(PREFIX.length());
                    eventTypeStr = eventTypeStr.replaceAll(Pattern.quote("."), "_");
                    QueueWatchEventType eventType = QueueWatchEventType.valueOf((String)eventTypeStr);
                    LocalDateTime localDateTime = LocalDateTime.parse(historicalInfo.getItineraryRef().getSource().getCreateDateTime(), DTF);
                    handledEvents.putIfAbsent(eventType, localDateTime);
                }
            }
        }
        ctx.putObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_HANDLED_EVENTS, handledEvents);
    }
}

