/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.Queue;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class QMOVRequestParametersBuilder
extends BaseProcessor {
    private PccType fromPccType;
    private PccType toPccType;
    private PccParameterName fromQueueName;
    private PccParameterName toQueueName;

    private static Queue getQueue(Pcc pcc, PccParameterName queueName) throws Exception {
        Queue queue = new Queue();
        queue.setPcc(pcc.getCode());
        queue.setNumber(PccHelper.getPccParameter((Pcc)pcc, (PccParameterName)queueName));
        return queue;
    }

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.fromPccType = PccType.getPccType(parameters.get("fromPcc"));
        this.toPccType = PccType.getPccType(parameters.get("toPcc"));
        this.fromQueueName = PccParameterName.valueOf((String)parameters.get("fromQueue"));
        this.toQueueName = PccParameterName.valueOf((String)parameters.get("toQueue"));
    }

    public void process(MessageContext ctx) throws Exception {
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Pcc fromPcc = this.fromPccType.getPcc(gdsParameters, (SabreGdsAccount)accountCtr.getEntity());
        Pcc toPcc = this.toPccType == this.fromPccType ? fromPcc : this.toPccType.getPcc(gdsParameters, (SabreGdsAccount)accountCtr.getEntity());
        Queue queueFrom = QMOVRequestParametersBuilder.getQueue(fromPcc, this.fromQueueName);
        Queue queueTo = QMOVRequestParametersBuilder.getQueue(toPcc, this.toQueueName);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.QMOV_QUEUE_FROM, (Object)queueFrom);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.QMOV_QUEUE_TO, (Object)queueTo);
    }

    private static enum PccType {
        PRIMARY,
        BOOKING,
        TICKETING;


        static PccType getPccType(String name) {
            if (name == null || name.equalsIgnoreCase("primary")) {
                return PRIMARY;
            }
            if (name.equalsIgnoreCase("booking")) {
                return BOOKING;
            }
            if (name.equalsIgnoreCase("ticketing")) {
                return TICKETING;
            }
            throw Xeption.forAdmin((String)"Invalid PCC type in QMovRequestParametersBuilder config", (Object[])new Object[]{name});
        }

        Pcc getPcc(GDSParameters parameters, SabreGdsAccount account) {
            Pcc result;
            switch (this) {
                case PRIMARY: {
                    result = SabreHelper.getPcc((SabreGdsAccount)account, null);
                    break;
                }
                case BOOKING: {
                    result = PccHelper.getBookingPcc((GDSParameters)parameters, null, (GdsName)account.getGds());
                    break;
                }
                case TICKETING: {
                    result = PccHelper.getTicketingPcc((GDSParameters)parameters, null, (GdsName)account.getGds());
                    break;
                }
                default: {
                    throw Xeption.forDeveloper((String)"No such PCC type", (Object[])new Object[]{this.name()});
                }
            }
            if (result == null) {
                throw Xeption.forAdmin((String)"No PCC could be found, check sales point settings", (Object[])new Object[]{this.name()});
            }
            return result;
        }
    }
}

