/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue;

import com.gridnine.xtrip.common.gds.sabre.model.Queue;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.QueuePlaceRQ;
import java.util.Collection;

public class QueuePlaceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection queues = (Collection)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.QUEUE_PLACE_QUEUES);
        QueuePlaceRQ request = this.buildRequest(queues);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"QueuePlaceLLSRQ");
    }

    private QueuePlaceRQ buildRequest(Collection<Queue> queues) {
        QueuePlaceRQ request = new QueuePlaceRQ();
        request.setVersion("2.0.4");
        request.setReturnHostCommand(Boolean.TRUE);
        QueuePlaceRQ.MultiQueuePlace mqp = new QueuePlaceRQ.MultiQueuePlace();
        for (Queue queue : queues) {
            QueuePlaceRQ.MultiQueuePlace.QueueIdentifier qi = new QueuePlaceRQ.MultiQueuePlace.QueueIdentifier();
            qi.setNumber(queue.getNumber());
            qi.setPrefatoryInstructionCode(queue.getPrefatoryInstructionCode() != null ? queue.getPrefatoryInstructionCode() : "11");
            qi.setPseudoCityCode(queue.getPcc());
            mqp.getQueueIdentifierList().add(qi);
        }
        request.setMultiQueuePlace(mqp);
        return request;
    }
}

