/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue;

import com.gridnine.xtrip.common.gds.model.BaseQueueWatchEvent;
import com.gridnine.xtrip.common.gds.model.GdsSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AccountingLinesPNRB;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.ReservationPNRB;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SabreBaseQueueWatchEventParser
extends BaseProcessor {
    private static final Set<String> UNCONFIRMED_SEGMENT_STATUS = Stream.of("UN", "UC").collect(Collectors.toSet());
    private static final Set<String> CHANGED_SEGMENT_STATUS = Stream.of("TK").collect(Collectors.toSet());
    private static final Set<String> CANCELLED_SEGMENT_STATUS = Stream.of("HX").collect(Collectors.toSet());

    public void process(MessageContext ctx) throws Exception {
        BaseQueueWatchEvent event = (BaseQueueWatchEvent)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENT);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        if (response.getReservation() != null && response.getReservation().getReservationChoiceGroup() != null && response.getReservation().getReservationChoiceGroup().getPassengerReservation() != null) {
            for (AirType air : GetReservationHelper.getAirs(response)) {
                if ("OPEN".equals(air.getFlightNumber())) {
                    throw Xeption.forEndUser((String)"\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u0432\u043d\u0435\u0441\u043b\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435. \u0414\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b-\u0446\u0435\u043d\u0442\u0440\u043e\u043c.", (Object[])new Object[0]);
                }
                GdsSegment seg = new GdsSegment();
                seg.setRecordNumber(air.getSequence().intValue());
                seg.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)air.getMarketingAirlineCode()));
                seg.setFlightNumber(GetReservationHelper.getFlightNumber(air));
                seg.setBookingClass(air.getResBookDesigCode());
                seg.setDepartureDateTime(GetReservationHelper.getActualDepartureTime(air));
                seg.setArrivalDateTime(GetReservationHelper.getActualArrivalTime(air));
                seg.setDepartureLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getDepartureAirport()));
                seg.setArrivalLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getArrivalAirport()));
                seg.setSegmentStatus(air.getActionCode());
                seg.setSeatCount(air.getNumberInParty().intValue());
                seg.setUnconfirmed(UNCONFIRMED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
                seg.setChanged(CHANGED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
                seg.setCancelled(CANCELLED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
                event.getGdsSegments().add(seg);
            }
        }
        event.setHasTickets(Optional.ofNullable(response.getReservation()).map(ReservationPNRB::getAccountingLines).map(AccountingLinesPNRB::getAccountingLineList).map(List::isEmpty).orElse(true) == false);
    }
}

