/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue.agentTouch;

import com.gridnine.xtrip.common.gds.model.AgentTouchEvent;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouchType;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.TravelItineraryHistoryRS;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SabreQueueAgentTouchEventParser
extends BaseProcessor {
    private static final Set<String> AIRLINE_PCCS = new HashSet<String>(Arrays.asList("PLT", "HDQ"));
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");

    public void process(MessageContext ctx) throws Exception {
        AgentTouchEvent event = (AgentTouchEvent)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENT);
        String webAgentSignature = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.WEB_AGENT_SIGNATURE);
        TravelItineraryHistoryRS response = (TravelItineraryHistoryRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        for (TravelItineraryHistoryRS.HistoricalInfo historicalInfo : response.getHistoricalInfoList()) {
            if (historicalInfo.getItineraryRef() == null || historicalInfo.getItineraryRef().getSource() == null || AIRLINE_PCCS.contains(historicalInfo.getItineraryRef().getSource().getPseudoCityCode())) continue;
            if (webAgentSignature.equals(historicalInfo.getItineraryRef().getSource().getCreationAgent())) {
                if (historicalInfo.getRemarkInfo() == null || historicalInfo.getRemarkInfo().getRemarkList() == null || historicalInfo.getRemarkInfo().getRemarkList().isEmpty() || !"A5H".equals(((TravelItineraryHistoryRS.HistoricalInfo.RemarkInfo.Remark)historicalInfo.getRemarkInfo().getRemarkList().get(0)).getAction()) || !"H-G9Q / AGENT.TOUCH".equals(((TravelItineraryHistoryRS.HistoricalInfo.RemarkInfo.Remark)historicalInfo.getRemarkInfo().getRemarkList().get(0)).getText())) continue;
                break;
            }
            AgentTouch product = new AgentTouch();
            product.setType(AgentTouchType.OTHER);
            product.setAgentSignature(historicalInfo.getItineraryRef().getSource().getCreationAgent());
            if (!StringUtils.isBlank((String)historicalInfo.getItineraryRef().getSource().getCreateDateTime())) {
                product.setIssueDate(Date.from(LocalDateTime.parse(historicalInfo.getItineraryRef().getSource().getCreateDateTime(), DTF).atZone(ZoneId.of("USA/Tulsa")).toInstant()));
            }
            event.getProducts().add(product);
        }
    }
}

