/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.queue.task;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.AirlineMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class SabreQueueTaskHelper {
    private static final String DF = "yyyy-MM-dd HH:mm:ss";

    public static Date getStartDate() throws Exception {
        try (FileInputStream fis = new FileInputStream(new File(Environment.getDataFolder(), "SabreQueueTask.date"));){
            Date date = new SimpleDateFormat(DF).parse(IOUtils.toString((InputStream)fis));
            return date;
        }
    }

    public static void setStartDate(Date date) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(new File(Environment.getDataFolder(), "SabreQueueTask.date"));){
            IOUtils.write((String)new SimpleDateFormat(DF).format(date), (OutputStream)fos);
        }
    }

    public static void log(AirlineMessage msg) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(new File(Environment.getDataFolder(), "SabreQueueTask.dat"), true);){
            IOUtils.write((String)String.format("%s %s\n", msg.getType(), msg.getMessage().replaceAll(Pattern.quote("\n"), "\u044a")), (OutputStream)fos);
        }
    }
}

