/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.redapp;

import com.gridnine.xtrip.common.model.redapp.Tax;
import com.gridnine.xtrip.common.model.redapp.sws.AccountingLine;
import com.gridnine.xtrip.common.model.redapp.sws.Address;
import com.gridnine.xtrip.common.model.redapp.sws.AddressType;
import com.gridnine.xtrip.common.model.redapp.sws.AirAccountingLine;
import com.gridnine.xtrip.common.model.redapp.sws.AirDocument;
import com.gridnine.xtrip.common.model.redapp.sws.AirSegment;
import com.gridnine.xtrip.common.model.redapp.sws.AppliedDiscount;
import com.gridnine.xtrip.common.model.redapp.sws.Baggage;
import com.gridnine.xtrip.common.model.redapp.sws.CommonAccountingLine;
import com.gridnine.xtrip.common.model.redapp.sws.Doca;
import com.gridnine.xtrip.common.model.redapp.sws.Doco;
import com.gridnine.xtrip.common.model.redapp.sws.Docs;
import com.gridnine.xtrip.common.model.redapp.sws.Email;
import com.gridnine.xtrip.common.model.redapp.sws.EmailType;
import com.gridnine.xtrip.common.model.redapp.sws.Endorsement;
import com.gridnine.xtrip.common.model.redapp.sws.EndorsementType;
import com.gridnine.xtrip.common.model.redapp.sws.ExchangeInfo;
import com.gridnine.xtrip.common.model.redapp.sws.FOP;
import com.gridnine.xtrip.common.model.redapp.sws.FormOfPayment;
import com.gridnine.xtrip.common.model.redapp.sws.Gender;
import com.gridnine.xtrip.common.model.redapp.sws.HotelSegment;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.redapp.sws.PassengerType;
import com.gridnine.xtrip.common.model.redapp.sws.Passport;
import com.gridnine.xtrip.common.model.redapp.sws.PassportType;
import com.gridnine.xtrip.common.model.redapp.sws.Phone;
import com.gridnine.xtrip.common.model.redapp.sws.PhoneType;
import com.gridnine.xtrip.common.model.redapp.sws.PriceQuote;
import com.gridnine.xtrip.common.model.redapp.sws.Pricing;
import com.gridnine.xtrip.common.model.redapp.sws.PricingStatus;
import com.gridnine.xtrip.common.model.redapp.sws.ProfileIndex;
import com.gridnine.xtrip.common.model.redapp.sws.ProfileIndexType;
import com.gridnine.xtrip.common.model.redapp.sws.RailwaySegment;
import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.model.redapp.sws.SWSModelHelper;
import com.gridnine.xtrip.common.model.redapp.sws.SpecialFare;
import com.gridnine.xtrip.common.model.redapp.sws.SpecialService;
import com.gridnine.xtrip.common.model.redapp.sws.TariffIndicator;
import com.gridnine.xtrip.common.model.redapp.sws.TechnicalStop;
import com.gridnine.xtrip.common.model.redapp.sws.Ticketing;
import com.gridnine.xtrip.common.model.redapp.sws.Traveller;
import com.gridnine.xtrip.common.model.redapp.sws.Visa;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.gds.sabre.redapp.TIRConverterConfig;
import com.sabre.ns.ticketing.pqs.CodeEndorsementType;
import com.sabre.ns.ticketing.pqs.MessageTextType;
import com.sabre.ns.ticketing.pqs.NameAssociationAttributes;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetailsFareComponent;
import com.sabre.services.res.or.v114.OpenReservationElementType;
import com.sabre.services.res.or.v114.ServiceRequestType;
import com.sabre.services.res.tir.v310.TravelItineraryReadRS;
import com.sabre.webservices.pnrbuilder.v119.AccountingLinePNRB;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import com.sabre.webservices.pnrbuilder.v119.PhoneNumberPNRB;
import com.sabre.webservices.pnrbuilder.v119.ProfilesPNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkPNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.ReservationPNRB;
import com.sabre.webservices.pnrbuilder.v119.SegmentTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.SourceTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.TicketDetailsType;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class GetItineraryConverter {
    private static final Pattern ETICKET_PATTERN = Pattern.compile("[A-Z\\s]{3}(?<ticketNumber>[A-Z0-9]{13,}).*");
    private static final Pattern CORPORATE_ID_FORMAT = Pattern.compile("[A-Z]{3}[0-9]{2}");
    private static Logger LOG = LoggerFactory.getLogger(GetItineraryConverter.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
    private static final Mapper<Passport> DOCS_FIELDS_MAPPER = new Mapper();
    private static final Mapper<Traveller> DOCS_REF_FIELDS_MAPPER = new Mapper();
    private static final Mapper<Passport> DOCS_DB_FIELDS_MAPPER = new Mapper();
    private static final Mapper<Visa> DOCO_FIELDS_MAPPER = new Mapper();
    private static final Mapper<Address> DOCA_FIELDS_MAPPER = new Mapper();
    private static final Mapper<Traveller> INFT_REF_FIELDS_MAPPER = new Mapper();
    private static final Mapper<Traveller> CHLD_REF_FIELDS_MAPPER = new Mapper();
    private static final Mapper<Email> CONTACT_NUMBER_MAPPER = new Mapper();
    private static final Set<String> PREFIXES = Stream.of(Gender.values()).flatMap(v -> v.getPrefixes().stream()).collect(Collectors.toSet());
    private static final Pattern CONTACT_NUMBER_PATTERN = Pattern.compile("([0-9]*)-{0,1}([0-9]*)-{0,1}([0-9]*)-{0,1}([A-Z]*)");
    private static final Pattern EMAIL_COMMENT_PATTERN = Pattern.compile("(?<emailType>[A-Z]{1,2}{2})?(@(?<language>[A-Z]{1,2}))?(?<otherData>/.*)?");
    private static final String CORP_ACCOUNT_LINE = "CORP ID/ACCNT CODE USED:";
    private static final Predicate<? super TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo> SSR_FILTER;
    private static final Predicate<? super TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo> OSI_FILTER;

    GetItineraryConverter() {
    }

    private static String convertSWSGivenNameToFirstName(String givenName) {
        String firstName = givenName.split(" ")[0];
        if (!PREFIXES.contains(firstName)) {
            return firstName;
        }
        return null;
    }

    private static String convertSWSGivenNameToMiddleName(String givenName) {
        String middleName = Stream.of(givenName.split(" ")).skip(1L).filter(s -> !PREFIXES.contains(s)).collect(Collectors.joining(" "));
        if (!middleName.isEmpty()) {
            return middleName;
        }
        return null;
    }

    private static Gender convertSWSGivenNameToGender(PassengerType passengerType, String givenName) {
        String[] splittedGivenName = givenName.split(" ");
        if (splittedGivenName.length >= 2) {
            boolean isAdultType = !SWSModelHelper.isInfantType((PassengerType)passengerType);
            return Stream.iterate(1, i -> i + 1).limit(splittedGivenName.length - 1).filter(i -> PREFIXES.contains(splittedGivenName[i])).findFirst().map(i -> GetItineraryConverter.correctGender(isAdultType, Gender.ofPrefix((String)splittedGivenName[i]))).orElse(null);
        }
        return null;
    }

    private static Gender correctGender(boolean isAdultType, Gender calculatedGender) {
        if (isAdultType) {
            if (calculatedGender == Gender.MI) {
                return Gender.M;
            }
            if (calculatedGender == Gender.FI) {
                return Gender.F;
            }
            return calculatedGender;
        }
        if (calculatedGender == Gender.M) {
            return Gender.MI;
        }
        if (calculatedGender == Gender.F) {
            return Gender.FI;
        }
        return calculatedGender;
    }

    static Itinerary convertSWS2Itinerary(GetReservationRSType getReservationRSType) {
        if (getReservationRSType.getReservation() == null) {
            return null;
        }
        Itinerary result = GetItineraryConverter.convertReservation(getReservationRSType.getReservation());
        if (getReservationRSType.getPriceQuote() != null && getReservationRSType.getPriceQuote().getPriceQuoteInfo() != null && getReservationRSType.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG() != null && getReservationRSType.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG().getDetailList() != null && getReservationRSType.getPriceQuote().getPriceQuoteInfo().getSummary() != null && getReservationRSType.getPriceQuote().getPriceQuoteInfo().getSummary().getNameAssociationList() != null && !getReservationRSType.getPriceQuote().getPriceQuoteInfo().getSummary().getNameAssociationList().isEmpty()) {
            getReservationRSType.getPriceQuote().getPriceQuoteInfo().getGetResultsChoiceCG().getDetailList().stream().filter(pq -> getReservationRSType.getPriceQuote().getPriceQuoteInfo().getSummary().getNameAssociationList().stream().anyMatch(na -> na.getPriceQuoteList() != null && na.getPriceQuoteList().stream().anyMatch(pqca -> MiscUtil.equals((Object)pq.getNumber(), (Object)pqca.getNumber(), (boolean)false) && (pqca.getIndicators() == null || !BooleanUtil.nullAsFalse((Boolean)pqca.getIndicators().getItineraryChange()))))).map(p -> GetItineraryConverter.convertSWS2PriceQuote(result, p)).collect(Collectors.toCollection(() -> ((Itinerary)result).getPriceQuotes()));
        }
        return result;
    }

    static Itinerary convertReservation(ReservationPNRB reservation) {
        if (reservation == null) {
            return null;
        }
        Itinerary result = new Itinerary();
        SourceTypePNRB source = reservation.getPOS().getSource();
        result.setPnr(reservation.getBookingDetails().getRecordLocator());
        result.setHOME_PCC(source.getHomePseudoCityCode());
        result.setPCC(source.getPseudoCityCode());
        if (reservation.getDKNumbers() != null) {
            result.setDkNumber((String)reservation.getDKNumbers().getDKNumberList().get(0));
        }
        if (reservation.getProfiles() != null) {
            GetItineraryConverter.setProfiles(reservation.getProfiles(), result);
        }
        if (reservation.getReservationChoiceGroup() != null && reservation.getReservationChoiceGroup().getPassengerReservation() != null) {
            if (reservation.getReservationChoiceGroup().getPassengerReservation().getSegments() != null && reservation.getReservationChoiceGroup().getPassengerReservation().getSegments().getSegmentList() != null) {
                result.getAirSegments().addAll(reservation.getReservationChoiceGroup().getPassengerReservation().getSegments().getSegmentList().stream().map(GetItineraryConverter::convertAirSegment).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            if (reservation.getReservationChoiceGroup().getPassengerReservation().getPassengers() != null && reservation.getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList() != null) {
                result.getPassengers().addAll(reservation.getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList().stream().map(p -> GetItineraryConverter.convertPassenger(p, result)).collect(Collectors.toList()));
                result.getPhones().addAll(reservation.getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList().stream().filter(p -> p.getPhoneNumbers() != null && p.getPhoneNumbers().getPhoneNumberList() != null).flatMap(p -> p.getPhoneNumbers().getPhoneNumberList().stream().map(GetItineraryConverter::convertSWSToPhone)).collect(Collectors.toList()));
                result.getRemarks().addAll(reservation.getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList().stream().filter(p -> p.getRemarks() != null && p.getRemarks().getRemarkList() != null).flatMap(p -> p.getRemarks().getRemarkList().stream().map(GetItineraryConverter::convertSWSToRemark).peek(r -> r.getPersonsList().add(new Remark.PersonName(p.getLastName() + "/" + p.getFirstName(), p.getNameId())))).collect(Collectors.toList()));
            }
        }
        if (reservation.getPhoneNumbers() != null && reservation.getPhoneNumbers().getPhoneNumberList() != null) {
            result.getPhones().addAll(reservation.getPhoneNumbers().getPhoneNumberList().stream().map(GetItineraryConverter::convertSWSToPhone).collect(Collectors.toSet()));
        }
        if (reservation.getRemarks() != null && reservation.getRemarks().getRemarkList() != null) {
            result.getRemarks().addAll(reservation.getRemarks().getRemarkList().stream().map(GetItineraryConverter::convertSWSToRemark).collect(Collectors.toSet()));
        }
        if (reservation.getOpenReservationElements() != null && reservation.getOpenReservationElements().getOpenReservationElementList() != null) {
            reservation.getOpenReservationElements().getOpenReservationElementList().stream().filter(OpenReservationElementType::ifFormOfPayment).map(e -> GetItineraryConverter.convertSWSToFop(e.getFormOfPayment())).collect(Collectors.toCollection(() -> ((Itinerary)result).getFops()));
            reservation.getOpenReservationElements().getOpenReservationElementList().stream().filter(e -> e.getServiceRequest() != null && "OSI".equals(e.getServiceRequest().getServiceType())).map(e -> GetItineraryConverter.convertSWSToSS(e)).collect(Collectors.toCollection(() -> ((Itinerary)result).getOsis()));
            reservation.getOpenReservationElements().getOpenReservationElementList().stream().filter(e -> e.getServiceRequest() != null && "SSR".equals(e.getServiceRequest().getServiceType())).map(e -> GetItineraryConverter.convertSWSToSS(e)).collect(Collectors.toCollection(() -> ((Itinerary)result).getSsrs()));
        }
        return result;
    }

    static Itinerary convertSWS2Itinerary(TravelItineraryReadRS itineraryReadRS) {
        return GetItineraryConverter.convertSWS2Itinerary(itineraryReadRS, new TIRConverterConfig());
    }

    static Itinerary convertSWS2Itinerary(TravelItineraryReadRS itineraryReadRS, TIRConverterConfig config) {
        Itinerary result = new Itinerary();
        if (itineraryReadRS.getTravelItinerary() == null) {
            return result;
        }
        TravelItineraryReadRS.TravelItinerary.ItineraryRef.Source source = itineraryReadRS.getTravelItinerary().getItineraryRef().getSource();
        result.setPnr(itineraryReadRS.getTravelItinerary().getItineraryRef().getID());
        result.setAAA_PCC(source.getAAAPseudoCityCode());
        result.setHOME_PCC(source.getHomePseudoCityCode());
        result.setPCC(source.getPseudoCityCode());
        result.setDkNumber(itineraryReadRS.getTravelItinerary().getItineraryRef().getCustomerIdentifier());
        if (itineraryReadRS.getTravelItinerary().getItineraryInfo().getReservationItems().getItemList() != null) {
            itineraryReadRS.getTravelItinerary().getItineraryInfo().getReservationItems().getItemList().forEach(i -> {
                if (i.getFlightSegmentList() != null && !i.getFlightSegmentList().isEmpty()) {
                    result.getAirSegments().add(GetItineraryConverter.convertAirSegment(i.getFlightSegmentList(), Integer.parseInt(i.getRPH())));
                } else if (i.getHotel() != null) {
                    result.getHotelSegments().add(GetItineraryConverter.convertHotelSegment(i.getHotel(), Integer.parseInt(i.getRPH())));
                } else if (i.getRail() != null) {
                    result.getRailwaySegments().add(GetItineraryConverter.convertRailSegment(i.getRail(), Integer.parseInt(i.getRPH())));
                }
            });
        }
        if (!config.isPassengerParsingExcluded()) {
            Optional.ofNullable(itineraryReadRS.getTravelItinerary().getCustomerInfo().getPersonNameList()).ifPresent(pnl -> pnl.forEach(pn -> {
                if (pn.getGroupInfo() == null) {
                    result.getPassengers().add(GetItineraryConverter.convertPassenger(pn, result));
                }
            }));
        }
        if (!config.isAccountingLinesParsingExcluded() && itineraryReadRS.getTravelItinerary().getAccountingInfoList() != null) {
            for (int i2 = 0; i2 < itineraryReadRS.getTravelItinerary().getAccountingInfoList().size(); ++i2) {
                result.getAccountingLines().add(GetItineraryConverter.convertAccountingLine((TravelItineraryReadRS.TravelItinerary.AccountingInfo)itineraryReadRS.getTravelItinerary().getAccountingInfoList().get(i2), result, i2));
            }
        }
        if (!config.isPriceQuotesParsingExcluded() && itineraryReadRS.getTravelItinerary().getItineraryInfo().getItineraryPricing() != null) {
            itineraryReadRS.getTravelItinerary().getItineraryInfo().getItineraryPricing().getPriceQuoteList().stream().filter(pq -> Stream.of(pq.getMiscInformation()).filter(Objects::nonNull).map(mf -> mf.getSignatureLineList()).map(sl -> (TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.MiscInformation.SignatureLine)sl.get(0)).map(sl -> sl.getStatus()).anyMatch(st -> "ACTIVE".equals(st))).map(p -> GetItineraryConverter.convertSWS2PriceQuote(result, p)).collect(Collectors.toCollection(() -> ((Itinerary)result).getPriceQuotes()));
        }
        if (!config.isTicketingParsingExcluded() && itineraryReadRS.getTravelItinerary().getItineraryInfo().getTicketingList() != null) {
            itineraryReadRS.getTravelItinerary().getItineraryInfo().getTicketingList().stream().filter(t -> t.getETicketNumber() != null).map(t -> GetItineraryConverter.convertSWS2Ticketing(t)).collect(Collectors.toCollection(() -> ((Itinerary)result).getTicketing()));
        }
        if (!config.isDocsParsingExcluded()) {
            if (itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList() != null) {
                itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList().stream().filter(SSR_FILTER).forEach(ssr -> {
                    if ("INFT".equals(ssr.getService().getSSRType()) && "AFX".equals(ssr.getType())) {
                        GetItineraryConverter.resolveInfants(result, ssr);
                    }
                    if ("CHLD".equals(ssr.getService().getSSRType())) {
                        GetItineraryConverter.resolveChld(result, ssr);
                    }
                });
            }
            if (itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList() != null) {
                itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList().stream().filter(SSR_FILTER).forEach(ssr -> {
                    switch (ssr.getService().getSSRType()) {
                        case "DOCS": {
                            GetItineraryConverter.addDocs(result, ssr);
                            break;
                        }
                        case "DOCO": {
                            GetItineraryConverter.addDoco(result, ssr);
                            break;
                        }
                        case "DOCA": {
                            GetItineraryConverter.addDoca(result, ssr);
                            break;
                        }
                    }
                });
                itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList().stream().filter(OSI_FILTER).forEach(ssr -> GetItineraryConverter.addOsi(result, ssr));
            }
            if (itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList() != null) {
                itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList().stream().filter(SSR_FILTER).filter(ssr -> "FOID".equals(ssr.getService().getSSRType())).forEach(ssr -> GetItineraryConverter.addFoid(result, ssr));
                itineraryReadRS.getTravelItinerary().getSpecialServiceInfoList().stream().filter(OSI_FILTER).forEach(ssr -> GetItineraryConverter.addOsi(result, ssr));
            }
        }
        result.getPassengers().forEach(GetItineraryConverter::determineType);
        if (!config.isContactsParsingExcluded() && itineraryReadRS.getTravelItinerary().getCustomerInfo().getContactNumbers() != null) {
            itineraryReadRS.getTravelItinerary().getCustomerInfo().getContactNumbers().getContactNumberList().stream().map(GetItineraryConverter::convertSWSToPhone).collect(Collectors.toCollection(() -> ((Itinerary)result).getPhones()));
        }
        if (!config.isRemarksParsingExcluded() && itineraryReadRS.getTravelItinerary().getRemarkInfo() != null && itineraryReadRS.getTravelItinerary().getRemarkInfo().getRemarkList() != null) {
            itineraryReadRS.getTravelItinerary().getRemarkInfo().getRemarkList().stream().map(GetItineraryConverter::convertSWSToRemark).collect(Collectors.toCollection(() -> ((Itinerary)result).getRemarks()));
        }
        GetItineraryConverter.setLastPricingParameters(result, itineraryReadRS);
        return result;
    }

    private static void setLastPricingParameters(Itinerary result, TravelItineraryReadRS itineraryReadRS) {
        for (PriceQuote pq : result.getPriceQuotes()) {
            List endorsements = pq.getEndorsements();
            for (Endorsement end : endorsements) {
                String manualPqEndorsement;
                String inputEntry;
                if (end.getType() == EndorsementType.PRICING_PARAMETER && !StringUtils.isEmpty((String)(inputEntry = GetItineraryConverter.getPricingParameter(itineraryReadRS, pq.getRph()))) && !inputEntry.equals("PQ")) {
                    end.setText(inputEntry);
                }
                if (end.getType() != EndorsementType.ENDORSEMENT_OVERRIDE_ED || StringUtils.isEmpty((String)(manualPqEndorsement = GetItineraryConverter.getManualPqEndorsment(itineraryReadRS, pq.getRph())))) continue;
                end.setText(manualPqEndorsement);
            }
        }
    }

    private static String getManualPqEndorsment(TravelItineraryReadRS itineraryReadRS, int pqNumber) {
        String result = null;
        try {
            for (Element elm : XmlUtil.getElements((Element)itineraryReadRS.getPriceQuote().getAny(), (String)"Details")) {
                Map attributes;
                Element mesInfRemarks;
                String elmNumber;
                if (elm == null || StringUtils.isEmpty((String)(elmNumber = (String)XmlUtil.getAttributes((Element)elm).get("number"))) || Integer.parseInt(elmNumber) != pqNumber || (mesInfRemarks = XmlUtil.getElement((Element)elm, (String)"MessageInfo/Remarks")) == null || (attributes = XmlUtil.getAttributes((Element)mesInfRemarks)).isEmpty() || StringUtils.isEmpty((String)((String)attributes.get("type"))) || !((String)attributes.get("type")).equals("EOD")) continue;
                result = XmlUtil.getValue((Element)mesInfRemarks);
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Exception during search 'Remarks' for manual PQ %s. ", pqNumber), (Throwable)e);
        }
        return result;
    }

    private static String getPricingParameter(TravelItineraryReadRS itineraryReadRS, int pqNumber) {
        String result = null;
        try {
            for (Element elm : XmlUtil.getElements((Element)itineraryReadRS.getPriceQuote().getAny(), (String)"Details")) {
                Element mesInfPricingParams;
                String elmNumber;
                if (elm == null || StringUtils.isEmpty((String)(elmNumber = (String)XmlUtil.getAttributes((Element)elm).get("number"))) || Integer.parseInt(elmNumber) != pqNumber || (mesInfPricingParams = XmlUtil.getElement((Element)elm, (String)"MessageInfo/PricingParameters")) == null) continue;
                result = XmlUtil.getValue((Element)mesInfPricingParams);
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Exception during search 'PricingParameter' in PQ %s. ", pqNumber), (Throwable)e);
        }
        return result;
    }

    private static Ticketing convertSWS2Ticketing(TicketDetailsType source, Traveller passenger) {
        Ticketing result = new Ticketing();
        if (source.getIndex() != null) {
            result.setRph(source.getIndex().intValue());
        }
        result.setTicketNumber(source.getTicketNumber());
        result.setTravelerNameNumber(passenger.getSabreNameNumber());
        result.setPcc(source.getAgencyLocation());
        return result;
    }

    private static Ticketing convertSWS2Ticketing(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.Ticketing source) {
        Ticketing result = new Ticketing();
        if (source.getRPH() != null) {
            result.setRph(Integer.parseInt(source.getRPH()));
        }
        result.setTicketNumber(GetItineraryConverter.retrieveTicketNumber(source.getETicketNumber()));
        Optional.ofNullable(source.getPersonName()).map(p -> p.getNameNumber()).ifPresent(arg_0 -> ((Ticketing)result).setTravelerNameNumber(arg_0));
        return result;
    }

    private static String retrieveTicketNumber(String eTicketLine) {
        Matcher matcher = ETICKET_PATTERN.matcher(eTicketLine);
        if (matcher.matches()) {
            return matcher.group("ticketNumber");
        }
        LOG.error(String.format("Cannot find ticket number in [ %s ]", eTicketLine));
        return null;
    }

    private static PriceQuote convertSWS2PriceQuote(Itinerary itinerary, PriceQuoteDetails source) {
        PriceQuote result = new PriceQuote();
        Optional.ofNullable(source.getMiscellaneousInfo()).ifPresent(mi -> {
            boolean isRefundPq = "Y".equals(mi.getItineraryType());
            result.setForRefund(isRefundPq);
        });
        if (source.getNumber() != null) {
            result.setRph(source.getNumber().intValue());
        }
        Optional.ofNullable(source.getTransactionInfo()).ifPresent(ti -> {
            if (TextUtil.nonBlank((String)ti.getInputEntry())) {
                result.setPqCommand(ti.getInputEntry());
            }
        });
        source.getNameAssociationInfoList().stream().map(NameAssociationAttributes::getNameNumber).map(data -> GetItineraryConverter.findTravelerByNumber(itinerary, data)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> ((PriceQuote)result).getTravelers()));
        Optional.ofNullable(source.getPricingType()).ifPresent(s -> {
            switch (s) {
                case "A": {
                    result.setPricingStatus(PricingStatus.AGENT);
                    break;
                }
                case "S": {
                    result.setPricingStatus(PricingStatus.SYSTEM);
                    break;
                }
                case "D": {
                    result.setPricingStatus(PricingStatus.AMENDED);
                }
            }
        });
        Optional.ofNullable(source.getFareInfo()).ifPresent(fi -> {
            Optional.ofNullable(fi.getTaxInfo()).ifPresent(ti -> ti.getTaxList().stream().filter(t -> t.getAmount() != null).map(t -> {
                Tax tax = new Tax();
                tax.setAmount(t.getAmount().getDecimal());
                tax.setCurrency(t.getAmount().getCurrencyCode());
                tax.setCode(t.getCode());
                return tax;
            }).collect(Collectors.toCollection(() -> ((PriceQuote)result).getTaxes())));
            if (fi.getEquivalentFare() != null) {
                Optional.ofNullable(fi.getEquivalentFare().getString()).ifPresent(s -> {
                    Money money = new Money();
                    money.setCurrency(fi.getEquivalentFare().getCurrencyCode());
                    money.setValue(new BigDecimal((String)s));
                    result.setFare(money);
                });
            } else if (fi.getBaseFare() != null) {
                Optional.ofNullable(fi.getBaseFare().getString()).ifPresent(s -> {
                    Money money = new Money();
                    money.setCurrency(fi.getBaseFare().getCurrencyCode());
                    money.setValue(new BigDecimal((String)s));
                    result.setFare(money);
                });
            }
            if (fi.getTotalFare() != null) {
                Optional.ofNullable(fi.getTotalFare().getString()).ifPresent(s -> {
                    Money money = new Money();
                    money.setCurrency(fi.getTotalFare().getCurrencyCode());
                    money.setValue(new BigDecimal((String)s));
                    result.setTotalFare(money);
                });
            }
            if (fi.getFareIndicators() != null) {
                SpecialFare specialFare = new SpecialFare();
                result.setSpecialFare(specialFare);
                specialFare.setPrywatny(Boolean.valueOf(fi.getFareIndicators().getPrivateFareType() != null));
                fi.getFareComponentList().stream().map(PriceQuoteDetailsFareComponent::getCorpIdOrAcctCd).filter(Objects::nonNull).collect(Collectors.toCollection(() -> ((SpecialFare)specialFare).getAccountCodes()));
            }
        });
        result.setPassengerType(source.getPassengerType());
        Optional.ofNullable(source.getMiscellaneousInfo()).ifPresent(mi -> {
            mi.getValidatingCarrierList().stream().findFirst().ifPresent(arg_0 -> ((PriceQuote)result).setValidatingCarrier(arg_0));
            if (mi.getTourNumber() != null) {
                result.setTourCode(mi.getTourNumber().getString());
            }
            if (mi.getCorpIdOrAcctCdList() != null && !mi.getCorpIdOrAcctCdList().isEmpty()) {
                result.setAppliedDiscount(GetItineraryConverter.createDiscount((String)mi.getCorpIdOrAcctCdList().get(0)));
            }
        });
        Optional.ofNullable(source.getMessageInfo()).ifPresent(mi -> {
            if (mi.getMessageList() != null) {
                mi.getMessageList().stream().map(GetItineraryConverter::convertSWS2Endorsement).collect(Collectors.toCollection(() -> ((PriceQuote)result).getEndorsements()));
                if (mi.getPricingParameters() != null) {
                    result.getEndorsements().add(GetItineraryConverter.convertSWS2Endorsement(mi.getPricingParameters(), "PRICING_PARAMETER"));
                }
            }
            if (mi.getRemarkList() != null) {
                result.getEndorsements().addAll(mi.getRemarkList().stream().map(met -> GetItineraryConverter.convertSWS2Endorsement(met.getString(), met.getType())).collect(Collectors.toSet()));
            }
        });
        itinerary.getAirSegments().stream().filter(as -> source.getSegmentInfoList().stream().anyMatch(si -> si.getSegNumber() != null && si.getSegNumber().equals(as.getSegmentNumber().replaceFirst("0+", "")))).collect(Collectors.toCollection(() -> ((PriceQuote)result).getAirSegments()));
        source.getSegmentInfoList().stream().filter(si -> si.getSegNumber() != null && si.getBaggage() != null).forEach(si -> {
            AirSegment segment = itinerary.getAirSegments().stream().filter(as -> si.getSegNumber().equals(as.getSegmentNumber().replaceFirst("0+", ""))).findFirst().orElse(null);
            if (segment != null) {
                Baggage baggage = new Baggage();
                baggage.setAllowance(si.getBaggage().getAllowance());
                baggage.setType(si.getBaggage().getType());
                segment.setBaggage(baggage);
            }
        });
        return result;
    }

    private static PriceQuote convertSWS2PriceQuote(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote source) {
        PriceQuote result = new PriceQuote();
        Optional.ofNullable(source.getMiscInformation()).ifPresent(mi -> {
            boolean isRefundPq = mi.getSignatureLineList().stream().map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.MiscInformation.SignatureLine::getPQRInd).anyMatch("Y"::equals);
            result.setForRefund(isRefundPq);
        });
        source.getPricedItineraryList().stream().findFirst().ifPresent(pq -> result.setRph(Integer.parseInt(pq.getRPH())));
        Optional.ofNullable(source.getPriceQuotePlus()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.PriceQuotePlus::getPassengerInfo).ifPresent(info -> info.getPassengerDataList().stream().map(data -> GetItineraryConverter.findTravelerByNumber(itinerary, data)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> ((PriceQuote)result).getTravelers())));
        Optional.ofNullable(source.getPriceQuotePlus()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.PriceQuotePlus::getPricingStatus).ifPresent(s -> {
            if ("A".equals(s)) {
                result.setPricingStatus(PricingStatus.AGENT);
            } else if ("S".equals(s)) {
                result.setPricingStatus(PricingStatus.SYSTEM);
            } else if ("D".equals(s)) {
                result.setPricingStatus(PricingStatus.AMENDED);
            }
        });
        source.getPricedItineraryList().stream().findFirst().ifPresent(pricedItin -> {
            result.setValidatingCarrier(pricedItin.getValidatingCarrier());
            Optional.ofNullable(pricedItin.getAirItineraryPricingInfo()).map(i -> i.getItinTotalFareList().stream().findFirst().orElse(null)).ifPresent(i -> {
                if (i.getTaxes() != null) {
                    Optional.ofNullable(i.getTaxes().getTaxBreakdownCodeList()).ifPresent(list -> list.stream().map(GetItineraryConverter::convertTaxBreakdownCode2Tax).collect(Collectors.toCollection(() -> ((PriceQuote)result).getTaxes())));
                }
                if (i.getEquivFare() != null) {
                    result.setFare(GetItineraryConverter.getFareForPriceQuote(i.getEquivFare().getAmount(), i.getEquivFare().getCurrencyCode()));
                } else if (i.getBaseFare() != null) {
                    result.setFare(GetItineraryConverter.getFareForPriceQuote(i.getBaseFare().getAmount(), i.getBaseFare().getCurrencyCode()));
                }
            });
            if (pricedItin.getAirItineraryPricingInfo() != null) {
                String passengerType = pricedItin.getAirItineraryPricingInfo().getPassengerTypeQuantityList().stream().findFirst().map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PassengerTypeQuantity::getCode).orElse(null);
                result.setPassengerType(passengerType);
                pricedItin.getAirItineraryPricingInfo().getPTCFareBreakdownList().stream().findFirst().ifPresent(ptc -> {
                    String tourCode;
                    Optional.ofNullable(ptc.getEndorsements()).ifPresent(e -> e.getEndorsementList().stream().map(GetItineraryConverter::convertSWS2Endorsement).collect(Collectors.toCollection(() -> ((PriceQuote)result).getEndorsements())));
                    Map segmentsMap = itinerary.getAirSegments().stream().collect(Collectors.toMap(s -> s.getSegmentNumber().replaceFirst("0+", ""), Function.identity()));
                    ptc.getFlightSegmentList().stream().filter(s -> TextUtil.nonBlank((String)s.getSegmentNumber())).map(c -> (AirSegment)segmentsMap.get(c.getSegmentNumber())).filter(Objects::nonNull).collect(Collectors.toCollection(() -> ((PriceQuote)result).getAirSegments()));
                    if (ptc.getTourCode() != null && TextUtil.nonBlank((String)(tourCode = ptc.getTourCode().getText()))) {
                        result.setTourCode(tourCode);
                    }
                    ptc.getEndorsements().getEndorsementList().stream().filter(e -> e.getText().startsWith(CORP_ACCOUNT_LINE)).map(e -> e.getText().substring(e.getText().lastIndexOf(" ") + 1)).map(accountCode -> GetItineraryConverter.createDiscount(accountCode)).findFirst().ifPresent(arg_0 -> ((PriceQuote)result).setAppliedDiscount(arg_0));
                });
            }
        });
        return result;
    }

    private static AppliedDiscount createDiscount(String discountCode) {
        AppliedDiscount discount = new AppliedDiscount();
        discount.setCode(discountCode);
        if (CORPORATE_ID_FORMAT.matcher(discountCode).matches()) {
            discount.setQualifier(AppliedDiscount.DiscountQualifier.I);
        } else {
            discount.setQualifier(AppliedDiscount.DiscountQualifier.AC);
        }
        return discount;
    }

    private static Endorsement convertSWS2Endorsement(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown.Endorsements.Endorsement source) {
        return GetItineraryConverter.convertSWS2Endorsement(source.getText(), source.getType());
    }

    private static Endorsement convertSWS2Endorsement(MessageTextType source) {
        return GetItineraryConverter.convertSWS2Endorsement(source.getString(), source.getType());
    }

    private static Endorsement convertSWS2Endorsement(String text, CodeEndorsementType type) {
        Endorsement result = new Endorsement();
        result.setText(text);
        if (type == CodeEndorsementType.ENS) {
            result.setType(EndorsementType.SYSTEM);
        } else if (type == CodeEndorsementType.ENO) {
            result.setType(EndorsementType.ENDORSEMENT_OVERRIDE);
        } else if (type == CodeEndorsementType.EOD) {
            result.setType(EndorsementType.ENDORSEMENT_OVERRIDE_ED);
        } else if (type == CodeEndorsementType.E_O1) {
            result.setType(EndorsementType.ENDORSEMENT_OVERRIDE_1);
        }
        return result;
    }

    private static Endorsement convertSWS2Endorsement(String text, String type) {
        Endorsement result = new Endorsement();
        result.setText(text);
        if ("PRICING_PARAMETER".equals(type)) {
            result.setType(EndorsementType.PRICING_PARAMETER);
        } else if ("WARNING".equals(type)) {
            result.setType(EndorsementType.WARNING);
        } else if ("SYSTEM_ENDORSEMENT".equals(type)) {
            result.setType(EndorsementType.SYSTEM);
        } else if ("ENDORSEMENT_OVERRIDE".equals(type)) {
            result.setType(EndorsementType.ENDORSEMENT_OVERRIDE);
        } else if ("ENDORSEMENT_OVERRIDE_ED".equals(type)) {
            result.setType(EndorsementType.ENDORSEMENT_OVERRIDE_ED);
        } else if ("ENDORSEMENT_OVERRIDE_1".equals(type)) {
            result.setType(EndorsementType.ENDORSEMENT_OVERRIDE_1);
        } else if ("ENDORSEMENT_OVERRIDE_2".equals(type)) {
            result.setType(EndorsementType.ENDORSEMENT_OVERRIDE_2);
        }
        return result;
    }

    private static Money getFareForPriceQuote(String amount, String currency) {
        Money fare = new Money();
        fare.setValue((BigDecimal)Optional.ofNullable(amount).map(BigDecimal::new).orElse(null));
        fare.setCurrency(currency);
        return fare;
    }

    private static Tax convertTaxBreakdownCode2Tax(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.TaxBreakdownCode source) {
        Tax result = new Tax();
        Optional.of(source.getString()).map(s -> s.replaceAll("[^0-9.]", "")).map(tb -> {
            if (TextUtil.nonBlank((String)tb)) {
                return new BigDecimal((String)tb);
            }
            return null;
        }).ifPresent(arg_0 -> ((Tax)result).setAmount(arg_0));
        Optional.of(source.getString()).map(s -> s.replaceAll("[0-9.]", "")).ifPresent(arg_0 -> ((Tax)result).setCode(arg_0));
        return result;
    }

    public static Traveller findTravelerByNumber(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ItineraryPricing.PriceQuote.PriceQuotePlus.PassengerInfo.PassengerData data) {
        return itinerary.getPassengers().stream().filter(t -> t.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(data.getNameNumber()))).findAny().orElse(null);
    }

    public static Traveller findTravelerByNumber(Itinerary itinerary, String number) {
        return itinerary.getPassengers().stream().filter(t -> t.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(number))).findAny().orElse(null);
    }

    private static AccountingLine convertAccountingLine(AccountingLinePNRB accountingInfo, Traveller passenger) {
        Object accountingLine = null;
        accountingLine = accountingInfo.getAirlineDesignator() != null ? GetItineraryConverter.retrieveAirAccountingLine(accountingInfo, passenger) : GetItineraryConverter.retrieveCommonAccountingLine(accountingInfo);
        accountingLine.setRph(accountingInfo.getIndex().intValue());
        String mode = accountingInfo.getFareApplication();
        if ("ONE".equals(mode)) {
            accountingLine.setApplicableMode(AccountingLine.ApplicableMode.ONE);
        }
        if ("ALL".equals(mode)) {
            accountingLine.setApplicableMode(AccountingLine.ApplicableMode.ALL);
        }
        if ("PER".equals(mode)) {
            accountingLine.setApplicableMode(AccountingLine.ApplicableMode.PER);
        }
        accountingLine.setPricing(GetItineraryConverter.getPricingData(accountingInfo));
        return accountingLine;
    }

    private static CommonAccountingLine retrieveCommonAccountingLine(AccountingLinePNRB accountingInfo) {
        CommonAccountingLine result = new CommonAccountingLine();
        result.setLinkCode(accountingInfo.getLinkCode());
        result.setChargeCategory(accountingInfo.getChargeCategoryCoded());
        result.setAccountVendor(accountingInfo.getAccountingVendorCode());
        if (accountingInfo.getAccountingLineText() != null) {
            result.setAdditionalText(accountingInfo.getAccountingLineText());
        } else if (accountingInfo.getFreeFormText() != null) {
            result.setAdditionalText(accountingInfo.getFreeFormText());
        }
        Optional.ofNullable(accountingInfo.getNumberOfConjunctedDocuments()).ifPresent(n -> result.setDocumentsCount(Integer.parseInt(n)));
        return result;
    }

    private static AirAccountingLine retrieveAirAccountingLine(AccountingLinePNRB accountingInfo, Traveller passenger) {
        AirAccountingLine result = new AirAccountingLine();
        result.setAirlineCode(accountingInfo.getAirlineDesignator());
        result.setTraveller(passenger);
        AirDocument document = new AirDocument();
        document.setNumber(accountingInfo.getDocumentNumber());
        if ("D".equals(accountingInfo.getTarriffBasis())) {
            document.setTariffIndicator(TariffIndicator.DOMESTIC);
        } else if ("F".equals(accountingInfo.getTarriffBasis())) {
            document.setTariffIndicator(TariffIndicator.FOREIGN);
        }
        if (accountingInfo.getNumberOfConjunctedDocuments() != null) {
            document.setTicketConjunction(Integer.parseInt(accountingInfo.getNumberOfConjunctedDocuments()));
        }
        result.setDocument(document);
        return result;
    }

    private static Pricing getPricingData(AccountingLinePNRB accountingInfo) {
        BigDecimal percent;
        Tax tax;
        Pricing pricing = new Pricing();
        String formOfPayment = accountingInfo.getFormOfPaymentCode();
        if ("CA".equals(formOfPayment)) {
            pricing.setFormOfPayment(FormOfPayment.CASH);
        }
        if ("CK".equals(formOfPayment)) {
            pricing.setFormOfPayment(FormOfPayment.CHECK);
        }
        if ("CC".equals(formOfPayment)) {
            pricing.setFormOfPayment(FormOfPayment.CREDIT_CARD);
        }
        if ("CX".equals(formOfPayment)) {
            pricing.setFormOfPayment(FormOfPayment.CREDIT_CARD_SUPPRESSED);
        }
        if (accountingInfo.getBaseFare() != null) {
            Money fare = new Money();
            if (!StringUtils.isEmpty((String)accountingInfo.getBaseFare())) {
                fare.setValue(new BigDecimal(accountingInfo.getBaseFare().trim()));
            }
            pricing.setFare(fare);
        }
        BigDecimal commission = null;
        if (!StringUtils.isEmpty((String)accountingInfo.getCommissionAmount())) {
            commission = new BigDecimal(accountingInfo.getCommissionAmount().trim());
        } else if (!StringUtils.isEmpty((String)accountingInfo.getCommissionPercentage())) {
            BigDecimal percent2 = new BigDecimal(accountingInfo.getCommissionPercentage().trim());
            commission = pricing.getFare().getValue().multiply(percent2.divide(new BigDecimal(100)));
        }
        pricing.setCommission(commission);
        if (accountingInfo.getTaxAmount() != null) {
            tax = new Tax();
            tax.setAmount(new BigDecimal(accountingInfo.getTaxAmount().trim()));
            tax.setCode(accountingInfo.getTaxSurchargeCode2());
            pricing.getTaxes().add(tax);
        } else if (accountingInfo.getTaxPercentage() != null) {
            tax = new Tax();
            percent = new BigDecimal(accountingInfo.getTaxPercentage().trim());
            tax.setAmount(pricing.getFare().getValue().multiply(percent.divide(new BigDecimal(100))));
            tax.setCode(accountingInfo.getTaxSurchargeCode2());
            pricing.getTaxes().add(tax);
        }
        if (accountingInfo.getGSTAmount() != null) {
            tax = new Tax();
            tax.setAmount(new BigDecimal(accountingInfo.getGSTAmount().trim()));
            tax.setCode(accountingInfo.getGSTCode());
            pricing.getTaxes().add(tax);
        } else if (accountingInfo.getGSTPercent() != null) {
            tax = new Tax();
            percent = new BigDecimal(accountingInfo.getGSTPercent().trim());
            tax.setAmount(pricing.getFare().getValue().multiply(percent.divide(new BigDecimal(100))));
            tax.setCode(accountingInfo.getGSTCode());
            pricing.getTaxes().add(tax);
        }
        if (accountingInfo.getQSTAmount() != null) {
            tax = new Tax();
            tax.setAmount(new BigDecimal(accountingInfo.getQSTAmount().trim()));
            tax.setCode(accountingInfo.getQSTCode());
            pricing.getTaxes().add(tax);
        } else if (accountingInfo.getQSTPercent() != null) {
            tax = new Tax();
            percent = new BigDecimal(accountingInfo.getQSTPercent().trim());
            tax.setAmount(pricing.getFare().getValue().multiply(percent.divide(new BigDecimal(100))));
            tax.setCode(accountingInfo.getQSTCode());
            pricing.getTaxes().add(tax);
        }
        return pricing;
    }

    private static AccountingLine convertAccountingLine(TravelItineraryReadRS.TravelItinerary.AccountingInfo accountingInfo, Itinerary itinerary, int accountingLineNumber) {
        Object accountingLine = null;
        accountingLine = accountingInfo.getAirline() != null ? GetItineraryConverter.retrieveAirAccountingLine(accountingInfo, itinerary) : GetItineraryConverter.retrieveCommonAccountingLine(accountingInfo);
        accountingLine.setRph(accountingLineNumber + 1);
        String mode = accountingInfo.getFareApplication();
        if ("ONE".equals(mode)) {
            accountingLine.setApplicableMode(AccountingLine.ApplicableMode.ONE);
        }
        if ("ALL".equals(mode)) {
            accountingLine.setApplicableMode(AccountingLine.ApplicableMode.ALL);
        }
        if ("PER".equals(mode)) {
            accountingLine.setApplicableMode(AccountingLine.ApplicableMode.PER);
        }
        accountingLine.setPricing(GetItineraryConverter.getPricingData(accountingInfo));
        return accountingLine;
    }

    private static CommonAccountingLine retrieveCommonAccountingLine(TravelItineraryReadRS.TravelItinerary.AccountingInfo accountingInfo) {
        CommonAccountingLine result = new CommonAccountingLine();
        result.setLinkCode(accountingInfo.getLinkCode());
        result.setChargeCategory(accountingInfo.getChargeCategory());
        result.setAccountVendor((String)Optional.ofNullable(accountingInfo.getAccountVendor()).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.AccountVendor::getCode).orElse(null));
        if (accountingInfo.getText() != null) {
            result.setAdditionalText(accountingInfo.getText());
        } else {
            Optional.ofNullable(accountingInfo.getTicketingInfo()).map(t -> t.getTicketing()).map(t -> t.getConjunctedCount()).filter(s -> !StringUtils.isEmpty((String)s)).ifPresent(arg_0 -> ((CommonAccountingLine)result).setAdditionalText(arg_0));
        }
        Optional.ofNullable(accountingInfo.getTicketingInfo()).map(t -> t.getTicketing()).map(t -> t.getConjunctedCount()).filter(s -> !StringUtils.isEmpty((String)s)).map(s -> Integer.parseInt(s.substring(0, 1))).ifPresent(arg_0 -> ((CommonAccountingLine)result).setDocumentsCount(arg_0));
        return result;
    }

    private static AirAccountingLine retrieveAirAccountingLine(TravelItineraryReadRS.TravelItinerary.AccountingInfo accountingInfo, Itinerary itinerary) {
        TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo ticketingInfo;
        AirAccountingLine result = new AirAccountingLine();
        result.setAirlineCode(accountingInfo.getAirline().getCode());
        for (Traveller person : itinerary.getPassengers()) {
            String sabreNameNumber = person.getSabreNameNumber();
            if (accountingInfo.getPersonName() == null) continue;
            String accountingInfoSurname = accountingInfo.getPersonName().getString().split(" ")[0];
            if (!sabreNameNumber.equals(accountingInfo.getPersonName().getNameNumber()) || !person.getLastName().equals(accountingInfoSurname)) continue;
            result.setTraveller(person);
            break;
        }
        AirDocument document = new AirDocument();
        TravelItineraryReadRS.TravelItinerary.AccountingInfo.DocumentInfo docInfo = accountingInfo.getDocumentInfo();
        if (docInfo != null && docInfo.getDocument() != null) {
            document.setNumber(docInfo.getDocument().getNumber());
        }
        if ((ticketingInfo = accountingInfo.getTicketingInfo()) != null) {
            if ("D".equals(ticketingInfo.getTariffBasis())) {
                document.setTariffIndicator(TariffIndicator.DOMESTIC);
            } else if ("F".equals(ticketingInfo.getTariffBasis())) {
                document.setTariffIndicator(TariffIndicator.FOREIGN);
            }
            Optional.ofNullable(ticketingInfo.getTicketing()).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo.Ticketing::getConjunctedCount).filter(s -> !StringUtils.isEmpty((String)s)).filter(s -> s.matches("[0-9]+")).ifPresent(s -> document.setTicketConjunction(Integer.parseInt(s)));
        }
        Optional.ofNullable(ticketingInfo.getETicket()).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo.ETicket::getInd).ifPresent(ind -> document.setEticket(ind.booleanValue()));
        TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo.Exchange exchange = ticketingInfo.getExchange();
        if (exchange != null && exchange.getInd() != null && exchange.getInd().booleanValue()) {
            result.setExchangeInfo(GetItineraryConverter.extractExchangeInfo(ticketingInfo));
        }
        result.setDocument(document);
        return result;
    }

    public static String normalizeNameNumber(String sabreNameNumber) {
        if (sabreNameNumber == null) {
            return null;
        }
        return sabreNameNumber.replaceFirst("^0+", "").replaceAll("\\.0+", ".");
    }

    private static ExchangeInfo extractExchangeInfo(TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo ticketingInfo) {
        ExchangeInfo exDocument = new ExchangeInfo();
        exDocument.setExchangeLocation(ticketingInfo.getIssueLocation());
        exDocument.setInvoiceNumber(ticketingInfo.getOriginalInvoiceNumber());
        ticketingInfo.getOriginalTicketNumberList().stream().findFirst().ifPresent(arg_0 -> ((ExchangeInfo)exDocument).setPreviousTicketNumber(arg_0));
        Optional.ofNullable(ticketingInfo.getIssueDate()).map(GetItineraryConverter::convertShortDateSWS2LocalDate).ifPresent(d -> exDocument.setExchangeDate(d.isAfter(LocalDate.now()) ? d.withYear(d.getYear() - 1) : d));
        Optional.ofNullable(ticketingInfo.getTicketing()).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo.Ticketing::getCouponCount).ifPresent(arg_0 -> ((ExchangeInfo)exDocument).setExchangedCoupons(arg_0));
        return exDocument;
    }

    private static Pricing getPricingData(TravelItineraryReadRS.TravelItinerary.AccountingInfo accountingInfo) {
        TravelItineraryReadRS.TravelItinerary.AccountingInfo.Taxes taxes;
        TravelItineraryReadRS.TravelItinerary.AccountingInfo.PaymentInfo.Commission swsCommission;
        Pricing pricing = new Pricing();
        TravelItineraryReadRS.TravelItinerary.AccountingInfo.PaymentInfo paymentInfo = accountingInfo.getPaymentInfo();
        if (paymentInfo != null && paymentInfo.getPayment() != null) {
            String formOfPayment = paymentInfo.getPayment().getForm();
            if ("CA".equals(formOfPayment)) {
                pricing.setFormOfPayment(FormOfPayment.CASH);
            }
            if ("CK".equals(formOfPayment)) {
                pricing.setFormOfPayment(FormOfPayment.CHECK);
            }
            if ("CC".equals(formOfPayment)) {
                pricing.setFormOfPayment(FormOfPayment.CREDIT_CARD);
            }
            if ("CX".equals(formOfPayment)) {
                pricing.setFormOfPayment(FormOfPayment.CREDIT_CARD_SUPPRESSED);
            }
        }
        if (accountingInfo.getBaseFare() != null) {
            Money fare = new Money();
            if (!StringUtils.isEmpty((String)accountingInfo.getBaseFare().getAmount())) {
                fare.setValue(new BigDecimal(accountingInfo.getBaseFare().getAmount()));
            }
            fare.setCurrency(accountingInfo.getBaseFare().getCurrencyCode());
            pricing.setFare(fare);
        }
        if ((swsCommission = paymentInfo.getCommission()) != null) {
            BigDecimal commission = null;
            if (!StringUtils.isEmpty((String)swsCommission.getAmount())) {
                commission = new BigDecimal(swsCommission.getAmount());
            } else if (!StringUtils.isEmpty((String)swsCommission.getPercent())) {
                BigDecimal percent = new BigDecimal(swsCommission.getPercent());
                commission = pricing.getFare().getValue().multiply(percent.divide(new BigDecimal(100)));
            }
            pricing.setCommission(commission);
        }
        if ((taxes = accountingInfo.getTaxes()) != null) {
            TravelItineraryReadRS.TravelItinerary.AccountingInfo.Taxes.Tax swsTax = taxes.getTax();
            if (swsTax != null) {
                Tax tax = new Tax();
                if (!StringUtils.isEmpty((String)swsTax.getAmount())) {
                    tax.setAmount(new BigDecimal(swsTax.getAmount()));
                }
                tax.setCode(swsTax.getTaxCode());
                pricing.getTaxes().add(tax);
            }
            if (taxes.getGST1() != null) {
                Tax gst = new Tax();
                if (!StringUtils.isEmpty((String)taxes.getGST1().getAmount())) {
                    gst.setAmount(new BigDecimal(taxes.getGST1().getAmount()));
                }
                gst.setCode(taxes.getGST1().getCurrencyCode());
                pricing.getTaxes().add(gst);
            }
            if (taxes.getQST1() != null) {
                Tax qst = new Tax();
                if (!StringUtils.isEmpty((String)taxes.getQST1().getAmount())) {
                    qst.setAmount(new BigDecimal(taxes.getQST1().getAmount()));
                }
                qst.setCode(taxes.getQST1().getTaxCode());
                pricing.getTaxes().add(qst);
            }
        }
        return pricing;
    }

    private static void addFoid(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo ssr) {
        String ssrText = ssr.getService().getTextList().stream().findAny().orElse("");
        Optional<Traveller> optTrav = itinerary.getPassengers().stream().filter(t -> ssr.getService().getPersonNameList().stream().map(pn -> pn.getNameNumber()).filter(Objects::nonNull).anyMatch(nn -> t.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(nn)))).findFirst();
        optTrav.ifPresent(trav -> {
            Optional<Docs> optDocs = trav.getDocs().stream().filter(docs -> ssrText.contains(docs.getPassport().getNumber())).findFirst();
            optDocs.ifPresent(docs -> {
                trav.getSsrs3().add(Integer.parseInt(ssr.getRPH()));
                docs.addSabreRPH(ssr.getRPH());
                docs.setHasFoid(true);
            });
        });
    }

    private static FOP convertSWSToFop(com.sabre.services.res.or.v114.FormOfPayment fop) {
        FOP result = new FOP();
        if (fop.ifCheck()) {
            result.setType(FOP.Type.CHECK);
        } else if (fop.ifCash()) {
            result.setType(FOP.Type.CASH);
        } else if (fop.ifPaymentCard()) {
            if (BooleanUtil.nullAsFalse((Boolean)fop.getPaymentCard().getGenerateApprovalAtTicketing())) {
                result.setType(FOP.Type.CARD_VENDOR);
            } else {
                result.setType(FOP.Type.CARD_AGENCY);
            }
            FOP.Card card = new FOP.Card();
            result.setCard(card);
            card.setCode(fop.getPaymentCard().getCardCode());
            card.setNumber(fop.getPaymentCard().getCardNumberString());
            if (TextUtil.nonBlank((String)fop.getPaymentCard().getExpiryMonth())) {
                card.setExpMonth(Integer.valueOf(Integer.parseInt(fop.getPaymentCard().getExpiryMonth().replaceAll("-", ""))));
            }
            if (TextUtil.nonBlank((String)fop.getPaymentCard().getExpiryYear())) {
                card.setExpYear(Integer.valueOf(Integer.parseInt(fop.getPaymentCard().getExpiryYear())));
            }
        }
        return result;
    }

    private static Remark convertSWSToRemark(RemarkPNRB remark) {
        Remark result = new Remark();
        result.setCode(remark.getCode());
        if (remark.getRemarkLines() != null && remark.getRemarkLines().getRemarkLineList() != null && !remark.getRemarkLines().getRemarkLineList().isEmpty()) {
            result.setText(remark.getRemarkLines().getRemarkLineList().stream().map(r -> r.getText().replaceAll("//", "@").replaceAll("\\.UN\\.", "_")).collect(Collectors.joining("\n")));
        }
        result.setType(GetItineraryConverter.convertRemarkType(remark.getType()));
        result.setRph(remark.getIndex().toString());
        result.setSegmentNumber(remark.getSegmentNumber());
        return result;
    }

    private static Remark convertSWSToRemark(TravelItineraryReadRS.TravelItinerary.RemarkInfo.Remark remark) {
        Remark result = new Remark();
        result.setCode(remark.getCode());
        if (remark.getText() != null) {
            result.setText(remark.getText().replaceAll("//", "@").replaceAll("\\.UN\\.", "_"));
        }
        result.setType(RemarkType.ofCode((String)remark.getType()));
        result.setRph(remark.getRPH());
        result.setSegmentNumber(remark.getSegmentNumber());
        if (remark.getPersonNameList() != null && !remark.getPersonNameList().isEmpty()) {
            result.getPersonsList().addAll(remark.getPersonNameList().stream().filter(Objects::nonNull).map(pn -> new Remark.PersonName(pn.getString(), pn.getNameNumber())).collect(Collectors.toList()));
        }
        return result;
    }

    private static Phone convertSWSToPhone(PhoneNumberPNRB contactNumber) {
        Phone result = new Phone();
        result.setRph(contactNumber.getIndex().toString());
        Matcher matcher = CONTACT_NUMBER_PATTERN.matcher(contactNumber.getNumber());
        result.setNumber(contactNumber.getNumber().replaceAll("-[A-Z]+", ""));
        if (matcher.find()) {
            try {
                String phoneType = matcher.group(4);
                if (!StringUtils.isEmpty((String)phoneType)) {
                    result.setPhoneType(PhoneType.safeValueOf((String)phoneType));
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Invalid phone format [%s]", contactNumber.getNumber()), (Throwable)e);
            }
        }
        return result;
    }

    private static Phone convertSWSToPhone(TravelItineraryReadRS.TravelItinerary.CustomerInfo.ContactNumbers.ContactNumber contactNumber) {
        Phone result = new Phone();
        result.setRph(contactNumber.getRPH());
        Matcher matcher = CONTACT_NUMBER_PATTERN.matcher(contactNumber.getPhone());
        result.setNumber(contactNumber.getPhone().replaceAll("-[A-Z]+", ""));
        if (matcher.find()) {
            try {
                String phoneType = matcher.group(4);
                if (!StringUtils.isEmpty((String)phoneType)) {
                    result.setPhoneType(PhoneType.safeValueOf((String)phoneType));
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Invalid phone format [%s]", contactNumber.getPhone()), (Throwable)e);
            }
        }
        return result;
    }

    private static void resolveInfants(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo ssr) {
        ssr.getService().getPersonNameList().stream().forEach(pnl -> {
            Traveller referer = itinerary.getPassengers().stream().filter(p -> p.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(pnl.getNameNumber()))).findFirst().get();
            ssr.getService().getTextList().stream().forEach(t -> {
                Traveller referenced = GetItineraryConverter.convertReferencedSSRInftPassenger(t, referer, itinerary.getPassengers());
                if (!SWSModelHelper.isInfantType((PassengerType)referenced.getPassengerType())) {
                    throw new IllegalStateException(String.format("Illegal passenger type [%s]", referenced.getPassengerType()));
                }
                referenced.setParent(referer);
            });
        });
    }

    private static SpecialService convertSWSToSS(OpenReservationElementType oret) {
        ServiceRequestType srt = oret.getServiceRequest();
        SpecialService ss = new SpecialService();
        if (oret.getAssociations() != null && oret.getAssociations().getNameAssociationList() != null) {
            ss.getAssociatedPassengerNumbers().addAll(oret.getAssociations().getNameAssociationList().stream().map(nat -> GetItineraryConverter.normalizeNameNumber(nat.getNameRefNumber())).filter(TextUtil::nonBlank).collect(Collectors.toSet()));
        }
        ss.setAirlineCode(srt.getAirlineCode());
        ss.setFreeText(srt.getFreeText());
        ss.setFullText(srt.getFullText());
        ss.setCode(srt.getCode());
        if (srt.getChoice() != null && srt.getChoice().ifTravelDocument()) {
            ss.setDocType(srt.getChoice().getTravelDocument().getType());
        }
        return ss;
    }

    private static void addOsi(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo ssr) {
        Optional.ofNullable(ssr.getService().getPersonNameList()).ifPresent(personNameList -> personNameList.forEach(pnl -> {
            Traveller referencedPassenger = itinerary.getPassengers().stream().filter(p -> p.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(pnl.getNameNumber()))).findFirst().get();
            ssr.getService().getTextList().stream().forEach(t -> {
                if (t.startsWith("PSPT")) {
                    if ("GFX".equals(ssr.getType())) {
                        referencedPassenger.getSsrs3().add(Integer.parseInt(ssr.getRPH()));
                    } else {
                        referencedPassenger.getSsrs4().add(Integer.parseInt(ssr.getRPH()));
                    }
                }
            });
        }));
    }

    private static void addDoca(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo ssr) {
        ssr.getService().getPersonNameList().stream().forEach(pnl -> {
            Traveller referencedPassenger = itinerary.getPassengers().stream().filter(p -> p.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(pnl.getNameNumber()))).findFirst().get();
            ssr.getService().getTextList().stream().forEach(t -> {
                Address address = GetItineraryConverter.convertSSR2Address(t);
                Traveller ssrPassenger = address.isInfant() ? GetItineraryConverter.findAccompainied(itinerary.getPassengers(), referencedPassenger) : referencedPassenger;
                Doca doca = new Doca();
                doca.setSabreRPH(ssr.getRPH());
                if ("GFX".equals(ssr.getType())) {
                    ssrPassenger.getSsrs3().add(doca.getSabreRPH());
                } else {
                    ssrPassenger.getSsrs4().add(doca.getSabreRPH());
                }
                doca.setAddress(address);
                ssrPassenger.getDoca().add(doca);
            });
        });
    }

    private static void addDoco(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo ssr) {
        ssr.getService().getPersonNameList().stream().forEach(pnl -> {
            Traveller referencedPassenger = itinerary.getPassengers().stream().filter(p -> p.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(pnl.getNameNumber()))).findFirst().get();
            ssr.getService().getTextList().stream().forEach(t -> {
                Visa visa = GetItineraryConverter.convertSSR2Visa(t);
                Traveller ssrPassenger = visa.isInfant() ? GetItineraryConverter.findAccompainied(itinerary.getPassengers(), referencedPassenger) : referencedPassenger;
                Doco doco = ssrPassenger.getDoco().stream().filter(ds -> Objects.equals(ds.getVisa(), visa)).findFirst().orElseGet(() -> {
                    Doco o = new Doco();
                    o.addSabreRPH(ssr.getRPH());
                    o.setVisa(visa);
                    ssrPassenger.getDoco().add(o);
                    return o;
                });
                if ("GFX".equals(ssr.getType())) {
                    ssrPassenger.getSsrs3().add(Integer.parseInt(ssr.getRPH()));
                } else {
                    ssrPassenger.getSsrs4().add(Integer.parseInt(ssr.getRPH()));
                }
                doco.getApplicableSegmentsRPH().addAll(GetItineraryConverter.getSSRSerments(t, itinerary.getAirSegments()));
            });
        });
    }

    private static void resolveChld(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo ssr) {
        ssr.getService().getPersonNameList().stream().forEach(pnl -> {
            Traveller referencedPassenger = itinerary.getPassengers().stream().filter(p -> p.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(pnl.getNameNumber()))).findFirst().get();
            referencedPassenger.setPassengerType(PassengerType.CHILD);
            ssr.getService().getTextList().stream().forEach(t -> {
                Traveller referencedChld = new Traveller();
                CHLD_REF_FIELDS_MAPPER.map(referencedChld, (String)t);
                LocalDate dob = referencedChld.getBirthDate();
                if (referencedPassenger.getBirthDate() == null) {
                    referencedPassenger.setBirthDate(dob);
                } else if (dob != null && !dob.equals(referencedPassenger.getBirthDate())) {
                    throw new IllegalStateException(String.format("CHLD ssr of passenger %s %s has different birthdates %s and %s", referencedPassenger.getLastName(), referencedPassenger.getFirstName(), referencedPassenger.getBirthDate(), referencedChld.getBirthDate()));
                }
            });
        });
    }

    private static Traveller findAccompainied(List<Traveller> passengers, Traveller accompainying) {
        return passengers.stream().filter(p -> accompainying.equals((Object)p.getParent())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find accompainied for passenger [%s %s]", accompainying.getLastName(), accompainying.getFirstName())));
    }

    private static void addDocs(Itinerary itinerary, TravelItineraryReadRS.TravelItinerary.SpecialServiceInfo ssr) {
        ssr.getService().getPersonNameList().stream().forEach(pnl -> {
            Traveller referencedPassenger = itinerary.getPassengers().stream().filter(p -> p.getSabreNameNumber().equals(GetItineraryConverter.normalizeNameNumber(pnl.getNameNumber()))).findFirst().get();
            ssr.getService().getTextList().stream().forEach(t -> {
                Docs docs;
                Traveller ssrPassenger = GetItineraryConverter.findPassenger(GetItineraryConverter.getDocsPassenger(t), itinerary.getPassengers());
                if (ssrPassenger == null) {
                    LOG.info(String.format("Docs ssr [%s] has passenger [%s] with the different first/last names", t, referencedPassenger));
                    ssrPassenger = referencedPassenger;
                }
                if (!referencedPassenger.equals((Object)ssrPassenger)) {
                    LOG.info(String.format("Docs ssr [%s] has passenger [%s][%s] different from referenced [%s]", t, ssrPassenger, ssrPassenger.getPassengerType(), referencedPassenger));
                    if (SWSModelHelper.isAdultTraveller((Traveller)ssrPassenger)) {
                        LOG.info(String.format("Infants expected for ssr [%s], [%s] found", t, ssrPassenger.getPassengerType()));
                        return;
                    }
                }
                Passport passport = GetItineraryConverter.convertSSR2Passport(t);
                if (ssrPassenger.getGender() == null) {
                    ssrPassenger.setGender(passport.getGender());
                }
                if ((docs = (Docs)ssrPassenger.getDocs().stream().filter(ds -> Objects.equals(ds.getPassport(), passport)).findFirst().orElse(null)) == null) {
                    docs = new Docs();
                    docs.addSabreRPH(ssr.getRPH());
                    docs.setDocument(passport);
                    ssrPassenger.getDocs().add(docs);
                }
                if ("GFX".equals(ssr.getType())) {
                    ssrPassenger.getSsrs3().add(Integer.parseInt(ssr.getRPH()));
                } else {
                    ssrPassenger.getSsrs4().add(Integer.parseInt(ssr.getRPH()));
                }
                docs.getApplicableSegmentsRPH().addAll(GetItineraryConverter.getSSRSerments(t, itinerary.getAirSegments()));
            });
        });
    }

    private static Traveller getDocsPassenger(String ssr) {
        Traveller passenger = new Traveller();
        DOCS_REF_FIELDS_MAPPER.map(passenger, ssr);
        return passenger;
    }

    private static Traveller findPassenger(Traveller passenger, List<Traveller> passengers) {
        return passengers.stream().filter(p -> GetItineraryConverter.isSamePassenger(p, passenger)).findFirst().orElse(null);
    }

    private static boolean isSamePassenger(Traveller p1, Traveller p2) {
        if (!p1.getFirstName().equalsIgnoreCase(p2.getFirstName())) {
            return false;
        }
        if (!p1.getLastName().equalsIgnoreCase(p2.getLastName())) {
            return false;
        }
        return GetItineraryConverter.safeEquals(p1.getMiddleName(), p2.getMiddleName());
    }

    private static boolean safeEquals(String s1, String s2) {
        if (StringUtils.isEmpty((String)s1) || StringUtils.isEmpty((String)s2)) {
            return true;
        }
        return s1.equalsIgnoreCase(s2);
    }

    private static void setProfiles(ProfilesPNRB p, Itinerary itinerary) {
        if (p != null) {
            Map profilesIndexes = p.getProfileList().stream().map(ProfilesPNRB.Profile::getProfilesDataGroupPNRB).filter(Objects::nonNull).filter(dg -> ProfileIndexType.ofCode((String)dg.getProfileType()) != null).map(dg -> new ProfileIndex(ProfileIndexType.ofCode((String)dg.getProfileType()), dg.getProfileID())).collect(Collectors.toMap(ProfileIndex::getType, UnaryOperator.identity()));
            if (profilesIndexes.containsKey(ProfileIndexType.TAGENCY)) {
                itinerary.getAgencies().add(profilesIndexes.get(ProfileIndexType.TAGENCY));
            }
            if (profilesIndexes.containsKey(ProfileIndexType.CORPID)) {
                itinerary.getCorporants().add(profilesIndexes.get(ProfileIndexType.CORPID));
            }
        }
    }

    private static Traveller convertPassenger(PassengerPNRB pn, Itinerary itinerary) {
        Traveller passenger = new Traveller();
        String nameNumber = GetItineraryConverter.normalizeNameNumber(pn.getNameId());
        passenger.setSabreNameNumber(nameNumber);
        passenger.setPassengerType(PassengerType.ofCode((String)pn.getPassengerType()));
        if (BooleanUtil.nullAsFalse((Boolean)pn.getWithInfant())) {
            passenger.setPassengerType(PassengerType.INFANT);
        }
        passenger.setLastName(pn.getLastName());
        passenger.setFirstName(GetItineraryConverter.convertSWSGivenNameToFirstName(pn.getFirstName()));
        passenger.setMiddleName(GetItineraryConverter.convertSWSGivenNameToMiddleName(pn.getFirstName()));
        passenger.setGender(GetItineraryConverter.convertSWSGivenNameToGender(passenger.getPassengerType(), pn.getFirstName()));
        if (pn.getProfiles() != null) {
            Map profilesIndexes = pn.getProfiles().getProfileList().stream().map(ProfilesPNRB.Profile::getProfilesDataGroupPNRB).filter(Objects::nonNull).filter(dg -> ProfileIndexType.ofCode((String)dg.getProfileType()) != null).map(dg -> new ProfileIndex(ProfileIndexType.ofCode((String)dg.getProfileType()), dg.getProfileID())).collect(Collectors.toMap(ProfileIndex::getType, UnaryOperator.identity()));
            passenger.setSabreProfileIndex((ProfileIndex)profilesIndexes.get(ProfileIndexType.TRAVELER));
            if (profilesIndexes.containsKey(ProfileIndexType.TAGENCY)) {
                itinerary.getAgencies().add(profilesIndexes.get(ProfileIndexType.TAGENCY));
            }
            if (profilesIndexes.containsKey(ProfileIndexType.CORPID)) {
                itinerary.getCorporants().add(profilesIndexes.get(ProfileIndexType.CORPID));
            }
        }
        if (pn.getAccountingLines() != null && pn.getAccountingLines().getAccountingLineList() != null) {
            itinerary.getAccountingLines().addAll(pn.getAccountingLines().getAccountingLineList().stream().map(al -> GetItineraryConverter.convertAccountingLine(al, passenger)).collect(Collectors.toSet()));
        }
        if (pn.getTicketingInfo() != null && pn.getTicketingInfo().getTicketDetailList() != null) {
            itinerary.getTicketing().addAll(pn.getTicketingInfo().getTicketDetailList().stream().map(et -> GetItineraryConverter.convertSWS2Ticketing(et, passenger)).collect(Collectors.toSet()));
        }
        return passenger;
    }

    private static Traveller convertPassenger(TravelItineraryReadRS.TravelItinerary.CustomerInfo.PersonName pn, Itinerary itinerary) {
        Traveller passenger = new Traveller();
        String nameNumber = GetItineraryConverter.normalizeNameNumber(pn.getNameNumber());
        passenger.setSabreNameNumber(nameNumber);
        passenger.setPassengerType(PassengerType.ofCode((String)pn.getPassengerType()));
        if (Boolean.parseBoolean(pn.getWithInfant())) {
            passenger.setPassengerType(PassengerType.INFANT);
        }
        if (pn.getNameReference() == null || pn.getNameReference().startsWith("CHD")) {
            // empty if block
        }
        passenger.setLastName(pn.getSurname());
        passenger.setFirstName(GetItineraryConverter.convertSWSGivenNameToFirstName(pn.getGivenName()));
        passenger.setMiddleName(GetItineraryConverter.convertSWSGivenNameToMiddleName(pn.getGivenName()));
        passenger.setGender(GetItineraryConverter.convertSWSGivenNameToGender(passenger.getPassengerType(), pn.getGivenName()));
        if (pn.getProfileIndexList() != null) {
            Map profilesIndexes = pn.getProfileIndexList().stream().map(pi -> pi.getId()).map(GetItineraryConverter::convertToProfileIndex).filter(Objects::nonNull).collect(Collectors.toMap(ProfileIndex::getType, UnaryOperator.identity()));
            passenger.setSabreProfileIndex((ProfileIndex)profilesIndexes.get(ProfileIndexType.TRAVELER));
            if (profilesIndexes.containsKey(ProfileIndexType.TAGENCY)) {
                itinerary.getAgencies().add(profilesIndexes.get(ProfileIndexType.TAGENCY));
            }
            if (profilesIndexes.containsKey(ProfileIndexType.CORPID)) {
                itinerary.getCorporants().add(profilesIndexes.get(ProfileIndexType.CORPID));
            }
        }
        if (pn.getEmailList() != null && !pn.getEmailList().isEmpty()) {
            passenger.getEmails().addAll(pn.getEmailList().stream().map(email -> GetItineraryConverter.convertSWSToEmail(email, passenger)).collect(Collectors.toList()));
        }
        return passenger;
    }

    private static Email convertSWSToEmail(TravelItineraryReadRS.TravelItinerary.CustomerInfo.PersonName.Email email, Traveller owner) {
        Matcher matcher;
        Email result = new Email();
        result.setAddress(email.getName());
        if (email.getComment() != null && (matcher = EMAIL_COMMENT_PATTERN.matcher(email.getComment())).matches()) {
            result.setEmailType(EmailType.lookUpValue((String)matcher.group("emailType")));
            result.setLanguageOverride(matcher.group("language"));
        }
        if (!PassengerType.INFANT.equals((Object)owner.getPassengerType())) {
            result.setNameNumber(owner.getSabreNameNumber());
        }
        return result;
    }

    private static AirSegment convertAirSegment(List<SegmentTypePNRB.Segment> ss) {
        if (ss == null || ss.size() == 0) {
            return null;
        }
        if (ss.size() == 1) {
            return GetItineraryConverter.convertAirSegment(ss.get(0));
        }
        List sorted = ss.stream().map(GetItineraryConverter::convertAirSegment).filter(Objects::nonNull).sorted(Comparator.comparing(AirSegment::getDepartureDateTime)).collect(Collectors.toList());
        AirSegment first = (AirSegment)sorted.get(0);
        AirSegment last = (AirSegment)sorted.get(sorted.size() - 1);
        AirSegment segment = new AirSegment();
        segment.setRph(first.getRph());
        segment.setSeatsNumber(first.getSeatsNumber());
        segment.setClassOfServiceCode(first.getClassOfServiceCode());
        segment.setStatus(first.getStatus());
        segment.setSegmentNumber(first.getSegmentNumber());
        segment.setDepartureDateTime(first.getDepartureDateTime());
        segment.setDepartureLocation(first.getDepartureLocation());
        segment.setFlightNumber(first.getFlightNumber());
        segment.setStopQuantity(Integer.parseInt(ss.stream().map(SegmentTypePNRB.Segment::getAir).filter(Objects::nonNull).map(AirType::getStopQuantity).filter(Objects::nonNull).findFirst().orElse("0")));
        segment.setArrivalDateTime(last.getArrivalDateTime());
        segment.setArrivalLocation(last.getArrivalLocation());
        segment.setMarketingAirline(first.getMarketingAirline());
        segment.setOperatingAirline(first.getOperatingAirline());
        for (int i = 0; i < sorted.size() - 1; ++i) {
            AirSegment prev = (AirSegment)sorted.get(i);
            AirSegment next = (AirSegment)sorted.get(i + 1);
            TechnicalStop stop = new TechnicalStop();
            stop.setArrivalDateTime(prev.getArrivalDateTime());
            stop.setArrivalLocation(prev.getArrivalLocation());
            stop.setDepartureDateTime(next.getDepartureDateTime());
            stop.setDepartureLocation(next.getDepartureLocation());
            segment.getTechnicalStops().add(stop);
        }
        segment.getSubSegments().addAll(sorted);
        return segment;
    }

    private static AirSegment convertAirSegment(SegmentTypePNRB.Segment s) {
        if (s.getAir() == null) {
            return null;
        }
        AirSegment segment = new AirSegment();
        segment.setRph((int)s.getSequence().shortValue());
        if (s.getAir().getNumberInParty() != null) {
            segment.setSeatsNumber(s.getAir().getNumberInParty().intValue());
        }
        segment.setClassOfServiceCode(s.getAir().getResBookDesigCode());
        segment.setStatus(s.getAir().getActionCode());
        segment.setSegmentNumber(String.valueOf(s.getSequence()));
        segment.setFlightNumber(s.getAir().getFlightNumber());
        segment.setDepartureLocation(s.getAir().getDepartureAirport());
        segment.setArrivalLocation(s.getAir().getArrivalAirport());
        segment.setMarketingAirline(s.getAir().getMarketingAirlineCode());
        if (s.getAir().getOperatingAirlinePricing() != null) {
            segment.setOperatingAirline(s.getAir().getOperatingAirlinePricing().getCode());
        } else if (s.getAir().getOperatingAirlineCode() != null) {
            segment.setOperatingAirline(s.getAir().getOperatingAirlineCode());
        } else {
            segment.setOperatingAirline(s.getAir().getMarketingAirlineCode());
        }
        segment.setOpen("OPEN".equals(s.getAir().getFlightNumber()));
        if (!segment.isOpen()) {
            segment.setDepartureDateTime(LocalDateTime.parse(s.getAir().getDepartureDateTime()));
            segment.setArrivalDateTime(GetItineraryConverter.convertSWS2LocalDateTime(s.getAir().getArrivalDateTime(), false));
            if (TextUtil.nonBlank((String)s.getAir().getElapsedTime())) {
                try {
                    String[] time = s.getAir().getElapsedTime().split("\\.");
                    segment.setFlightDurationInMinutes(Integer.valueOf(Integer.parseInt(time[0]) * 60 + Integer.parseInt(time[1])));
                }
                catch (Exception e) {
                    LOG.error(String.format("Cannot parse flight duration [%s]", s.getAir().getElapsedTime()), (Throwable)e);
                }
            }
        }
        return segment;
    }

    private static AirSegment convertAirSegment(List<TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.FlightSegment> fs, int rph) {
        if (fs == null || fs.size() == 0) {
            return null;
        }
        if (fs.size() == 1) {
            return GetItineraryConverter.convertAirSegment(fs.get(0), rph);
        }
        List sorted = fs.stream().map(fss -> GetItineraryConverter.convertAirSegment(fss, rph)).sorted((s, s1) -> s.getDepartureDateTime().compareTo(s1.getDepartureDateTime())).collect(Collectors.toList());
        AirSegment first = (AirSegment)sorted.get(0);
        AirSegment last = (AirSegment)sorted.get(sorted.size() - 1);
        AirSegment segment = new AirSegment();
        segment.setRph(rph);
        segment.setSeatsNumber(first.getSeatsNumber());
        segment.setClassOfServiceCode(first.getClassOfServiceCode());
        segment.setStatus(first.getStatus());
        segment.setSegmentNumber(first.getSegmentNumber());
        segment.setDepartureDateTime(first.getDepartureDateTime());
        segment.setDepartureLocation(first.getDepartureLocation());
        segment.setFlightNumber(first.getFlightNumber());
        segment.setStopQuantity(Integer.parseInt(fs.get(0).getStopQuantity()));
        segment.setArrivalDateTime(last.getArrivalDateTime());
        segment.setArrivalLocation(last.getArrivalLocation());
        segment.setMarketingAirline(first.getMarketingAirline());
        segment.setOperatingAirline(first.getOperatingAirline());
        for (int i = 0; i < sorted.size() - 1; ++i) {
            AirSegment prev = (AirSegment)sorted.get(i);
            AirSegment next = (AirSegment)sorted.get(i + 1);
            TechnicalStop stop = new TechnicalStop();
            stop.setArrivalDateTime(prev.getArrivalDateTime());
            stop.setArrivalLocation(prev.getArrivalLocation());
            stop.setDepartureDateTime(next.getDepartureDateTime());
            stop.setDepartureLocation(next.getDepartureLocation());
            segment.getTechnicalStops().add(stop);
        }
        segment.getSubSegments().addAll(sorted);
        return segment;
    }

    private static AirSegment convertAirSegment(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.FlightSegment s, int rph) {
        AirSegment segment = new AirSegment();
        segment.setRph(rph);
        segment.setSeatsNumber(Integer.parseInt(s.getNumberInParty()));
        segment.setClassOfServiceCode(s.getResBookDesigCode());
        segment.setStatus(s.getStatus());
        segment.setSegmentNumber(s.getSegmentNumber());
        segment.setFlightNumber(s.getFlightNumber());
        segment.setDepartureLocation(s.getOriginLocation().getLocationCode());
        segment.setArrivalLocation(s.getDestinationLocation().getLocationCode());
        segment.setMarketingAirline(s.getMarketingAirline().getCode());
        if (s.getOperatingAirlineRecord() != null) {
            segment.setOperatingAirlineRecord(s.getOperatingAirlineRecord().getID());
        }
        if (s.getOperatingAirlinePricing() != null) {
            segment.setOperatingAirline(s.getOperatingAirlinePricing().getCode());
        } else if (s.getOperatingAirlineList().size() > 0) {
            segment.setOperatingAirline(((TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.FlightSegment.OperatingAirline)s.getOperatingAirlineList().get(0)).getCode());
        } else {
            segment.setOperatingAirline(s.getMarketingAirline().getCode());
        }
        segment.setOpen("OPEN".equals(s.getFlightNumber()));
        if (!segment.isOpen()) {
            segment.setDepartureDateTime(LocalDateTime.parse(s.getDepartureDateTime(), DATE_TIME_FORMATTER));
            segment.setArrivalDateTime(GetItineraryConverter.convertSWS2LocalDateTime(s.getArrivalDateTime()));
        }
        return segment;
    }

    private static HotelSegment convertHotelSegment(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel hotel, int rph) {
        HotelSegment result = new HotelSegment();
        result.setRph(rph);
        result.setLinkCode(hotel.getLinkCode());
        result.setTypeCode(hotel.getType());
        result.setStatus(hotel.getStatus());
        result.setLateCheckInGuaranteed("G".equals(hotel.getGuarantee()));
        result.setSegmentNumber(Optional.ofNullable(hotel.getSegmentNumber()).map(Integer::parseInt).orElse(0).intValue());
        result.setRoomCount(Optional.ofNullable(hotel.getNumberOfUnits()).map(Integer::parseInt).orElse(0).intValue());
        result.setCheckInDate((LocalDate)Optional.ofNullable(hotel.getTimeSpan()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.TimeSpan::getStart).map(GetItineraryConverter::convertShortDateSWS2LocalDate).orElse(null));
        result.setCheckOutDate((LocalDate)Optional.ofNullable(hotel.getTimeSpan()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.TimeSpan::getEnd).map(GetItineraryConverter::convertShortDateSWS2LocalDate).orElse(null));
        result.setRateAmount((String)Optional.ofNullable(hotel.getRoomRates()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.RoomRates::getRate).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.RoomRates.Rate::getAmount).orElse(null));
        result.setRateCurrency((String)Optional.ofNullable(hotel.getRoomRates()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.RoomRates::getRate).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.RoomRates.Rate::getCurrencyCode).orElse(null));
        result.setRoomType((String)Optional.ofNullable(hotel.getRoomRates()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.RoomRates::getRate).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.RoomRates.Rate::getRoomTypeCode).orElse(null));
        Optional.ofNullable(hotel.getBasicPropertyInfo()).ifPresent(info -> {
            result.setHotelChainCode(info.getChainCode());
            result.setHotelName(info.getHotelName());
            result.setHotelCity(Optional.ofNullable(info.getServiceCityName()).orElse(info.getHotelCityCode()));
            result.setConfirmationNumber((String)Stream.of(info.getConfirmationNumberList()).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).findAny().map(GetItineraryConverter::trimConfirmation).orElse(null));
            result.setHotelPhone(GetItineraryConverter.getHotelPhone(info));
            result.getHotelAddress().addAll(GetItineraryConverter.getAddress(info));
        });
        result.getNotes().addAll(Optional.ofNullable(hotel.getSpecialPrefs()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.SpecialPrefs::getTextList).orElse(Collections.emptyList()));
        return result;
    }

    private static String trimConfirmation(String confirmation) {
        String result = new String(confirmation);
        if (result.endsWith("-")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String getHotelPhone(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.BasicPropertyInfo info) {
        return Optional.ofNullable(info.getContactNumbers()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.BasicPropertyInfo.ContactNumbers::getContactNumberList).filter(l -> !l.isEmpty()).map(l -> (TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.BasicPropertyInfo.ContactNumbers.ContactNumber)l.get(0)).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.BasicPropertyInfo.ContactNumbers.ContactNumber::getPhone).orElse(null);
    }

    private static List<String> getAddress(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.BasicPropertyInfo info) {
        return Optional.ofNullable(info.getAddress()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Hotel.BasicPropertyInfo.Address::getAddressLineList).orElse(Collections.emptyList());
    }

    private static RailwaySegment convertRailSegment(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail rail, int rph) {
        RailwaySegment result = new RailwaySegment();
        result.setRph(rph);
        result.setLinkCode(rail.getLinkCode());
        result.setTypeCode(rail.getType());
        result.setDeparturePoint((String)Optional.ofNullable(rail.getOriginLocation()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail.OriginLocation::getPointList).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).orElse(null));
        result.setDepartureLocation((String)Optional.ofNullable(rail.getOriginLocation()).map(o -> o.getLocationNameList()).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).orElse(Optional.ofNullable(rail.getOriginLocation()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail.OriginLocation::getLocationCode).orElse(null)));
        result.setDepartureDate((LocalDate)Optional.ofNullable(rail.getOriginLocation()).map(o -> o.getDepartureDate()).map(GetItineraryConverter::convertShortDateSWS2LocalDate).orElse(null));
        result.setDepartureTime((LocalTime)Optional.ofNullable(rail.getOriginLocation()).map(o -> o.getDepartureTimeList()).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).map(GetItineraryConverter::convertSWS2LocalTime).orElse(null));
        result.setArrivalPoint((String)Optional.ofNullable(rail.getDestinationLocation()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail.DestinationLocation::getPointList).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).orElse(null));
        result.setArrivalLocation((String)Optional.ofNullable(rail.getDestinationLocation()).map(o -> o.getLocationName()).orElse(Optional.ofNullable(rail.getDestinationLocation()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail.DestinationLocation::getLocationCode).orElse(null)));
        result.setArrivalDate((LocalDate)Optional.ofNullable(rail.getDestinationLocation()).map(o -> o.getArrivalDateList()).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).map(GetItineraryConverter::convertShortDateSWS2LocalDate).orElse(null));
        result.setArrivalTime((LocalTime)Optional.ofNullable(rail.getDestinationLocation()).map(o -> o.getArrivalTimeList()).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).map(GetItineraryConverter::convertSWS2LocalTime).orElse(null));
        result.setTrain((String)Optional.ofNullable(rail.getTrainList()).filter(l -> !l.isEmpty()).map(l -> (TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail.Train)l.get(0)).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail.Train::getNumber).orElse(null));
        result.setSegmentNumber(rail.getSegmentNumber());
        result.setStatus(rail.getStatus());
        result.setVendor((String)Optional.ofNullable(rail.getVendor()).map(TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.Rail.Vendor::getCode).orElse(null));
        result.setConfirmationNumber((String)rail.getConfirmationNumberList().stream().findFirst().map(GetItineraryConverter::trimConfirmation).orElse(null));
        Optional.ofNullable(rail.getSpaceReservedList()).filter(l -> !l.isEmpty()).map(l -> (String)l.get(0)).ifPresent(s -> {
            Matcher matcher = Pattern.compile("(COACH)\\s+([^,]+),(SEAT)\\s+(.*)").matcher((CharSequence)s);
            if (matcher.find()) {
                result.setCoach(matcher.group(2));
                result.setSeat(matcher.group(4));
            }
        });
        return result;
    }

    private static Traveller convertReferencedSSRInftPassenger(String ssr, Traveller referer, List<Traveller> passengers) {
        if (ssr.endsWith("/OS")) {
            String[] arr;
            referer.setPassengerType(PassengerType.INFANT_WITH_SEAT);
            if (referer.getBirthDate() == null && (arr = ssr.split("/")).length > 1 && arr[1] != null) {
                LocalDate dob = GetItineraryConverter.convertSWS2LocalDate(arr[1]);
                referer.setBirthDate(dob);
            }
            return referer;
        }
        Traveller referencedInft = new Traveller();
        INFT_REF_FIELDS_MAPPER.map(referencedInft, ssr);
        Traveller infant = passengers.stream().filter(p -> p.getFirstName().equals(referencedInft.getFirstName()) && p.getLastName().equals(referencedInft.getLastName()) && PassengerType.INFANT.equals((Object)p.getPassengerType())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unable to find passenger from ssr [%s]", ssr)));
        if (infant.getBirthDate() == null) {
            infant.setBirthDate(referencedInft.getBirthDate());
        } else if (!infant.getBirthDate().equals(referencedInft.getBirthDate())) {
            throw new IllegalStateException(String.format("INFT ssr of passenger %s %s has different birthdates %s and %s", infant.getLastName(), infant.getFirstName(), infant.getBirthDate(), referencedInft.getBirthDate()));
        }
        return infant;
    }

    private static void determineType(Traveller passenger) {
        if (passenger.getPassengerType() != null) {
            return;
        }
        if (passenger.getBirthDate() == null) {
            return;
        }
        Period period = Period.between(passenger.getBirthDate(), LocalDate.now());
        if (period.getYears() >= 12) {
            passenger.setPassengerType(PassengerType.ADULT);
        }
        if (period.getYears() >= 2 && period.getYears() < 12) {
            passenger.setPassengerType(PassengerType.CHILD);
        }
        if (period.getYears() < 2) {
            passenger.setPassengerType(PassengerType.INFANT);
        }
    }

    private static ProfileIndex convertToProfileIndex(String profileIndex) {
        if (StringUtils.isEmpty((String)profileIndex)) {
            return null;
        }
        String[] data = profileIndex.split("/");
        ProfileIndex result = new ProfileIndex();
        result.setType(ProfileIndexType.valueOf((String)data[0]));
        result.setUniqueId(data[1]);
        return result;
    }

    private static Passport convertSSR2Passport(String ssr) {
        Passport result = new Passport();
        String[] texts = ssr.split("/");
        if (texts[1].equals(PassportType.DB.name())) {
            DOCS_DB_FIELDS_MAPPER.map(result, texts);
        } else {
            DOCS_FIELDS_MAPPER.map(result, texts);
        }
        return result;
    }

    private static Visa convertSSR2Visa(String ssr) {
        Visa result = new Visa();
        DOCO_FIELDS_MAPPER.map(result, ssr);
        return result;
    }

    private static Address convertSSR2Address(String ssr) {
        Address result = new Address();
        DOCA_FIELDS_MAPPER.map(result, ssr);
        return result;
    }

    private static LocalDateTime convertSWS2LocalDateTime(String date) {
        return GetItineraryConverter.convertSWS2LocalDateTime(date, true);
    }

    private static LocalDateTime convertSWS2LocalDateTime(String date, boolean withFormatter) {
        LocalDateTime arrivalDateTimeParsed;
        LocalDateTime now = LocalDateTime.now();
        String arrivalDateTime = now.getYear() + "-" + date;
        LocalDateTime localDateTime = arrivalDateTimeParsed = withFormatter ? LocalDateTime.parse(arrivalDateTime, DATE_TIME_FORMATTER) : LocalDateTime.parse(date);
        if (now.isAfter(arrivalDateTimeParsed)) {
            return arrivalDateTimeParsed.plusYears(1L);
        }
        return arrivalDateTimeParsed;
    }

    private static LocalDate convertSWS2LocalDate(String date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyy", Locale.ENGLISH);
        try {
            return simpleDateFormat.parse(date).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        catch (ParseException e) {
            LOG.error(String.format("Cannot parse a date [%s]", date), (Throwable)e);
            return null;
        }
    }

    private static LocalTime convertSWS2LocalTime(String time) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        try {
            return LocalTime.parse(time, formatter);
        }
        catch (Exception e) {
            LOG.error(String.format("Cannot parse a time [%s]", time), (Throwable)e);
            return null;
        }
    }

    private static LocalDate convertShortDateSWS2LocalDate(String departureDate) {
        String fullDate = LocalDate.now().getYear() + "-" + departureDate;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            LocalDate date = LocalDate.parse(fullDate, formatter);
            if (date.isBefore(LocalDate.now())) {
                date = date.plusYears(1L);
            }
            return date;
        }
        catch (Exception e) {
            LOG.error(String.format("Cannot parse a date [%s]", departureDate), (Throwable)e);
            return null;
        }
    }

    private static Set<String> getSSRSerments(String ssr, List<AirSegment> segments) {
        HashSet<String> result = new HashSet<String>();
        Pattern p = Pattern.compile("([A-Z]{3})([A-Z]{3})([0-9]{4})([A-Z])([0-3][0-9][A-Z]{3})");
        Matcher m = p.matcher(ssr);
        if (!m.find()) {
            result.add("A");
            return result;
        }
        String departure = m.group(1);
        String arrival = m.group(2);
        AirSegment s = new AirSegment();
        s.setDepartureLocation(departure);
        s.setArrivalLocation(arrival);
        result.add(GetItineraryConverter.findSameSegment(s, segments));
        return result;
    }

    private static String findSameSegment(AirSegment s, List<AirSegment> segments) {
        for (int i = 0; i < segments.size(); ++i) {
            AirSegment existed = segments.get(i);
            if (!s.getArrivalLocation().equals(existed.getArrivalLocation()) || !s.getDepartureLocation().equals(existed.getDepartureLocation())) continue;
            return String.valueOf(existed.getRph());
        }
        return null;
    }

    private static RemarkType convertRemarkType(RemarkTypePNRB typePNRB) {
        switch (typePNRB) {
            case ITINERARY: {
                return RemarkType.Itinerary;
            }
            case ITINSEGASSOC: {
                return RemarkType.ItinerarySegAssoc;
            }
            case INVOICE: {
                return RemarkType.Invoice;
            }
            case CODED: {
                return RemarkType.AlphaCoded;
            }
            case FOP: {
                return RemarkType.Fop;
            }
            case REG: {
                return RemarkType.General;
            }
            case HS: {
                return RemarkType.Historical;
            }
            case HD: {
                return RemarkType.Hidden;
            }
            case QQ: {
                return RemarkType.QueuePlace;
            }
            case CLIADR: {
                return RemarkType.ClientAddress;
            }
            case DELADR: {
                return RemarkType.DeliveryAddress;
            }
            case INVSEGASSOC: {
                return RemarkType.InvoiceSegAssoc;
            }
            case INTERFACE: {
                return RemarkType.Interface;
            }
            case FILLER: {
                return RemarkType.Filler;
            }
            case PRTONTKT: {
                return RemarkType.PrintOnTicket;
            }
            case CORPORATE: {
                return RemarkType.Corporate;
            }
        }
        return null;
    }

    static {
        DOCS_FIELDS_MAPPER.addMapping(1, (passport, s) -> passport.setType(PassportType.valueOf((String)s)));
        DOCS_FIELDS_MAPPER.addMapping(2, (passport, s) -> passport.setCitizenship(s));
        DOCS_FIELDS_MAPPER.addMapping(3, (passport, s) -> passport.setNumber(s));
        DOCS_FIELDS_MAPPER.addMapping(4, (passport, s) -> passport.setOrigin(s));
        DOCS_FIELDS_MAPPER.addMapping(5, (passport, s) -> passport.setBirthDate(GetItineraryConverter.convertSWS2LocalDate(s)));
        DOCS_FIELDS_MAPPER.addMapping(6, (passport, s) -> passport.setGender(Gender.valueOf((String)s)));
        DOCS_FIELDS_MAPPER.addMapping(7, (passport, s) -> passport.setExpiredDate(GetItineraryConverter.convertSWS2LocalDate(s)));
        DOCS_FIELDS_MAPPER.addMapping(8, (passport, s) -> passport.setLastName(s));
        DOCS_FIELDS_MAPPER.addMapping(9, (passport, s) -> {
            String[] tokens = s.split(" ");
            passport.setFirstName(tokens[0]);
            if (tokens.length >= 2) {
                passport.setMiddleName(s.substring(s.indexOf(" ") + 1));
            }
        });
        DOCS_FIELDS_MAPPER.addMapping(11, (passport, s) -> passport.setHolder("H".equals(s)));
        DOCS_REF_FIELDS_MAPPER.addMapping(6, (passenger, s) -> passenger.setGender(Gender.valueOf((String)s)));
        DOCS_REF_FIELDS_MAPPER.addMapping(8, (passenger, s) -> passenger.setLastName(s));
        DOCS_REF_FIELDS_MAPPER.addMapping(9, (passenger, s) -> passenger.setFirstName(s));
        DOCS_REF_FIELDS_MAPPER.addMapping(10, (passenger, s) -> passenger.setMiddleName(s));
        DOCO_FIELDS_MAPPER.addMapping(1, (visa, s) -> visa.setPlaceOfBirth(s));
        DOCO_FIELDS_MAPPER.addMapping(3, (visa, s) -> visa.setNumber(s));
        DOCO_FIELDS_MAPPER.addMapping(4, (visa, s) -> visa.setPlaceOfIssue(s));
        DOCO_FIELDS_MAPPER.addMapping(5, (visa, s) -> visa.setIssuedDate(GetItineraryConverter.convertSWS2LocalDate(s)));
        DOCO_FIELDS_MAPPER.addMapping(6, (visa, s) -> visa.setApplicableCountry(s));
        DOCO_FIELDS_MAPPER.addMapping(6, (visa, s) -> visa.setApplicableCountry(s));
        DOCO_FIELDS_MAPPER.addMapping(7, (visa, s) -> visa.setInfant("I".equals(s)));
        DOCA_FIELDS_MAPPER.addMapping(1, (address, s) -> address.setType(AddressType.valueOf((String)s)));
        DOCA_FIELDS_MAPPER.addMapping(2, (address, s) -> address.setCountry(s));
        DOCA_FIELDS_MAPPER.addMapping(3, (address, s) -> address.setStreet(s));
        DOCA_FIELDS_MAPPER.addMapping(4, (address, s) -> address.setCity(s));
        DOCA_FIELDS_MAPPER.addMapping(5, (address, s) -> address.setState(s));
        DOCA_FIELDS_MAPPER.addMapping(6, (address, s) -> address.setInfant("I".equals(s)));
        INFT_REF_FIELDS_MAPPER.addMapping(1, (passenger, s) -> passenger.setLastName(s));
        INFT_REF_FIELDS_MAPPER.addMapping(2, (passenger, s) -> passenger.setFirstName(s.split(" ")[0]));
        INFT_REF_FIELDS_MAPPER.addMapping(3, (passenger, s) -> passenger.setBirthDate(GetItineraryConverter.convertSWS2LocalDate(s)));
        CHLD_REF_FIELDS_MAPPER.addMapping(1, (passenger, s) -> passenger.setBirthDate(GetItineraryConverter.convertSWS2LocalDate(s)));
        CONTACT_NUMBER_MAPPER.addMapping(0, (email, s) -> email.setEmailType(EmailType.valueOf((String)s)));
        CONTACT_NUMBER_MAPPER.addMapping(1, (email, s) -> email.setLanguageOverride(s.substring(1)));
        DOCS_DB_FIELDS_MAPPER.addMapping(1, (passport, s) -> passport.setType(PassportType.valueOf((String)s)));
        DOCS_DB_FIELDS_MAPPER.addMapping(2, (passport, s) -> passport.setBirthDate(GetItineraryConverter.convertSWS2LocalDate(s)));
        DOCS_DB_FIELDS_MAPPER.addMapping(3, (passport, s) -> passport.setGender(Gender.valueOf((String)s)));
        DOCS_DB_FIELDS_MAPPER.addMapping(4, (passport, s) -> passport.setLastName(s));
        DOCS_DB_FIELDS_MAPPER.addMapping(5, (passport, s) -> {
            String[] tokens = s.split(" ");
            passport.setFirstName(tokens[0]);
            if (tokens.length >= 2) {
                passport.setMiddleName(s.substring(s.indexOf(" ") + 1));
            }
        });
        DOCS_DB_FIELDS_MAPPER.addMapping(6, (passport, s) -> passport.setHolder("H".equals(s)));
        SSR_FILTER = ssr -> "SSR".equals(ssr.getService().getSSRCode());
        OSI_FILTER = ssr -> "OSI".equals(ssr.getService().getSSRCode());
    }

    private static class Mapper<T> {
        protected Map<Integer, BiConsumer<T, String>> mappedFields = new HashMap<Integer, BiConsumer<T, String>>();

        private Mapper() {
        }

        void addMapping(int index, BiConsumer<T, String> fieldMapping) {
            this.mappedFields.put(index, fieldMapping);
        }

        void map(T model, String ssr) {
            String[] texts = ssr.split("/");
            this.map(model, texts);
        }

        void map(T model, String[] texts) {
            IntStream.iterate(0, i -> i + 1).limit(texts.length).forEach(i -> Optional.ofNullable(this.mappedFields.get(i)).ifPresent(bc -> bc.accept(model, texts[i])));
        }
    }
}

