/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.redapp;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.res.tir.v310.TravelItineraryReadRS;
import java.util.HashMap;
import java.util.Map;

public class TravelItineraryReadCheckResponseProcessor
extends BaseProcessor {
    private static final Map<String, L10nMessage> ERROR_STATUS_TRANSLATIONS = new HashMap<String, L10nMessage>();

    public void process(MessageContext ctx) throws Exception {
        TravelItineraryReadRS response = (TravelItineraryReadRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        String command = (String)ctx.getObject((Enum)IBusGdsSabreContextKeys.WORKFLOW_COMMAND);
        if (response.getTravelItinerary().getItineraryInfo().getReservationItems().getItemList() != null) {
            for (TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item item : response.getTravelItinerary().getItineraryInfo().getReservationItems().getItemList()) {
                TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.FlightSegment sabreFs;
                L10nMessage errorMessage;
                if (item.getFlightSegmentList() == null || item.getFlightSegmentList().isEmpty() || (errorMessage = ERROR_STATUS_TRANSLATIONS.get((sabreFs = (TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.FlightSegment)item.getFlightSegmentList().get(0)).getStatus())) == null || "CANCEL".equalsIgnoreCase(command)) continue;
                throw new Xeption(errorMessage, null, null, null);
            }
        }
    }

    static {
        ERROR_STATUS_TRANSLATIONS.put("HX", L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_OPERATION_IS_NOT_POSSIBLE_AS_ONE_OR_MORE_SEGMENTS_CANCELED_BY_AIRLINE", (Object[])new Object[0]));
        ERROR_STATUS_TRANSLATIONS.put("UC", L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_OPERATION_IS_IMPOSSIBLE_BECAUSE_THE_SEATS_ON_ONE_OF_THE_FLIGHTS_CANCELED_BY_THE_AIRLINE", (Object[])new Object[0]));
        ERROR_STATUS_TRANSLATIONS.put("NO", L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_OPERATION_IS_IMPOSSIBLE_BECAUSE_THE_SEATS_ON_ONE_OF_THE_FLIGHTS_CANCELED_BY_THE_AIRLINE_NO_STATUS", (Object[])new Object[0]));
        ERROR_STATUS_TRANSLATIONS.put("UN", L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_OPERATION_IS_IMPOSSIBLE_BECAUSE_THE_SEATS_ON_ONE_OF_THE_FLIGHTS_CANCELED_BY_THE_AIRLINE_UN_STATUS", (Object[])new Object[0]));
    }
}

