/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.redapp;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.res.tir.v310.TravelItineraryReadRQ;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.commons.lang.StringUtils;

public class TravelItineraryReadRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        TravelItineraryReadRQ request = reservation != null ? this.buildRequest(reservation) : this.buildRequest();
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"TravelItineraryReadRQ");
    }

    private TravelItineraryReadRQ buildRequest(Reservation reservation) {
        TravelItineraryReadRQ request = new TravelItineraryReadRQ();
        request.setVersion("3.10.0");
        TravelItineraryReadRQ.SubjectAreas sa = new TravelItineraryReadRQ.SubjectAreas();
        sa.getSubjectAreaList().add("FULL");
        request.setMessagingDetails(sa);
        if (reservation != null) {
            String recordLocator = SabreHelper.getRecordLocator((Reservation)reservation);
            if (StringUtils.isBlank((String)recordLocator)) {
                throw Xeption.forAdmin((String)"\u0412 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d PNR, \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430", (Object[])new Object[0]);
            }
            TravelItineraryReadRQ.UniqueID id = new TravelItineraryReadRQ.UniqueID();
            id.setID(recordLocator);
            request.setUniqueID(id);
        }
        return request;
    }

    private TravelItineraryReadRQ buildRequest() {
        TravelItineraryReadRQ request = new TravelItineraryReadRQ();
        request.setTimeStamp(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        request.setVersion("3.10.0");
        TravelItineraryReadRQ.SubjectAreas sa = new TravelItineraryReadRQ.SubjectAreas();
        sa.getSubjectAreaList().add("PRICE_QUOTE");
        sa.getSubjectAreaList().add("FULL");
        request.setMessagingDetails(sa);
        return request;
    }
}

