/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.redappAfs;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.redapp.sws.Endorsement;
import com.gridnine.xtrip.common.model.redapp.sws.EndorsementType;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.redapp.sws.PriceQuote;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.redapp.IBusRedAppContextKeys;

public class RedAppAfsP3DCommandBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Itinerary itinerary = (Itinerary)ctx.getObject((Enum)IBusRedAppContextKeys.ITINERARY);
        Integer pqNumber = (Integer)ctx.getObject((Enum)IBusRedAppContextKeys.REDAPP_PQ);
        PriceQuote priceQuote = itinerary.getPriceQuotes().stream().filter(pq -> pq.getRph() == pqNumber.intValue()).findFirst().orElse(null);
        if (priceQuote == null) {
            throw Xeption.forEndUser((String)("PQ with number " + pqNumber + " is not present in pnr"), (Object[])new Object[0]);
        }
        Endorsement endorsement = priceQuote.getEndorsements().stream().filter(item -> EndorsementType.PRICING_PARAMETER == item.getType()).findFirst().get();
        String pricingCommand = endorsement.getText();
        String[] pricingCommandSplit = pricingCommand.substring(2).split("\\$");
        StringBuilder newPricingCommandBuilder = new StringBuilder("WP");
        for (String s : pricingCommandSplit) {
            if (this.checkCommand(s)) continue;
            if (!newPricingCommandBuilder.toString().equals("WP")) {
                newPricingCommandBuilder.append('\u00a5');
            }
            newPricingCommandBuilder.append(s);
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_REQUEST, (Object)newPricingCommandBuilder.toString());
    }

    private boolean checkCommand(String cmd) {
        return cmd.startsWith("AC*") || cmd.startsWith("UAC*") || cmd.startsWith("I") || cmd.startsWith("F") || cmd.startsWith("ID") || cmd.startsWith("UID") || cmd.equals("RQ");
    }
}

