/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.redappAfs;

import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.redapp.IBusRedAppContextKeys;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;

public class RedAppAfsP3DCommandRSParser
extends BaseProcessor {
    private static final Pattern first = Pattern.compile("\\s*BASE\\s+FARE\\s+EQUIV\\s+AMT\\s+TAXES/FEES/CHARGES\\s+TOTAL\\s*");

    public void process(MessageContext ctx) throws Exception {
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        Map calculationMap = (Map)ctx.getMandatoryObject((Enum)IBusRedAppContextKeys.REDAPP_AFS_CALC_MAP);
        BigDecimal p3dValue = null;
        String[] rsLines = response.split("\\n");
        if (rsLines.length >= 3) {
            boolean next = false;
            for (String rsLine : rsLines) {
                String[] pqLineSplit;
                String pqLineP3DValuePart;
                if (next && (pqLineP3DValuePart = (pqLineSplit = rsLine.split("\\s+"))[pqLineSplit.length - 1]).matches("[A-Z]{3}\\d+[A-Z]{3}")) {
                    p3dValue = new BigDecimal(pqLineP3DValuePart.substring(3, pqLineP3DValuePart.length() - 3));
                    break;
                }
                next = first.matcher(rsLine).find();
            }
        }
        String afsType = (String)ctx.getMandatoryObject((Enum)IBusRedAppContextKeys.REDAPP_AFS_TYPE);
        if (p3dValue != null) {
            calculationMap.put(afsType, p3dValue);
        }
    }
}

