/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.redappAfs;

import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.redapp.IBusRedAppContextKeys;
import com.gridnine.xtrip.server.parsers2.redapp.service.RedAppServiceHelper;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessage;
import com.gridnine.xtrip.server.web.rest.redapp.service.model.RedappMessageType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedAppAfsWPNIOutputParser
extends BaseProcessor {
    private static final String NO_LOWER_FARE_DETERMINED = "{0}: NO LOWER FARE DETERMINED";
    private static final String CURRENT_ITINERARY_PROVIDES_LOWEST_FARE_USE_WPNCB = "{0}: CURRENT ITINERARY PROVIDES LOWEST FARE-USE WPNCB";
    private static final String CURRENT_ITINERARY_ALREADY_BOOKED_AT_LOWEST_AVAIL_FARE = "{0}: CURRENT ITINERARY-ALREADY BOOKED AT LOWEST AVAIL FARE";
    private static final String NO_FARES_FOUND = "{0}: NO FARES FOUND";
    private static final Pattern OPTION_PATTERN = Pattern.compile(".*" + Pattern.quote("OPTION 1") + ".*?" + Pattern.quote("TOTAL FARE") + "[^0-9\\.]+([0-9\\.]+).*", 40);
    private static final Pattern LOWER_CLASS_PATTERN = Pattern.compile(".*" + Pattern.quote("LOWER AVAIL CLASS OF SERVICE FOUND") + ".*?" + Pattern.quote("TOTAL FARE") + "[^0-9\\.]+([0-9\\.]+).*", 40);
    private static final Pattern NO_LOWER_PATTERN = Pattern.compile(".*" + Pattern.quote("TOTAL FARE") + "[^0-9\\.]+([0-9\\.]+).*" + Pattern.quote("NO LOWER FARE DETERMINED") + ".*", 40);
    private static final Pattern ALREADY_BOOKED_AT_LOWEST_AVAIL_FARE_PATTERN = Pattern.compile(".*" + Pattern.quote("CURRENT ITINERARY-ALREADY BOOKED AT LOWEST AVAIL FARE") + ".*?" + Pattern.quote("TOTAL FARE") + "[^0-9\\.]+([0-9\\.]+).*", 40);

    public void process(MessageContext ctx) throws Exception {
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        Map calculationMap = (Map)ctx.getMandatoryObject((Enum)IBusRedAppContextKeys.REDAPP_AFS_CALC_MAP);
        String afsType = (String)ctx.getMandatoryObject((Enum)IBusRedAppContextKeys.REDAPP_AFS_TYPE);
        List messages = (List)ctx.getMandatoryObject((Enum)IBusRedAppContextKeys.REDAPP_MESSAGES);
        BigDecimal value = null;
        Matcher noMatcher = NO_LOWER_PATTERN.matcher(response);
        Matcher lowerMatcher = LOWER_CLASS_PATTERN.matcher(response);
        Matcher alreadyMatcher = ALREADY_BOOKED_AT_LOWEST_AVAIL_FARE_PATTERN.matcher(response);
        Matcher optionMatcher = OPTION_PATTERN.matcher(response);
        RedappMessage message = null;
        if (noMatcher.matches()) {
            value = new BigDecimal(noMatcher.group(1));
            message = RedAppServiceHelper.buildMessage((RedappMessageType)RedappMessageType.Info, (String)NO_LOWER_FARE_DETERMINED, (Object[])new Object[]{afsType});
        } else if (lowerMatcher.matches()) {
            value = new BigDecimal(lowerMatcher.group(1));
            message = RedAppServiceHelper.buildMessage((RedappMessageType)RedappMessageType.Info, (String)CURRENT_ITINERARY_PROVIDES_LOWEST_FARE_USE_WPNCB, (Object[])new Object[]{afsType});
        } else if (alreadyMatcher.matches()) {
            value = new BigDecimal(alreadyMatcher.group(1));
            message = RedAppServiceHelper.buildMessage((RedappMessageType)RedappMessageType.Info, (String)CURRENT_ITINERARY_ALREADY_BOOKED_AT_LOWEST_AVAIL_FARE, (Object[])new Object[]{afsType});
        }
        if (optionMatcher.matches()) {
            BigDecimal opt = new BigDecimal(optionMatcher.group(1));
            if (value == null || value.compareTo(opt) > 0) {
                value = opt;
                message = null;
            }
        }
        if (value == null) {
            value = (BigDecimal)calculationMap.get(AFSType.ATF2.name());
            message = RedAppServiceHelper.buildMessage((RedappMessageType)RedappMessageType.Info, (String)NO_FARES_FOUND, (Object[])new Object[]{afsType});
        }
        if (message != null) {
            messages.add(message);
        }
        calculationMap.put(afsType, value);
    }
}

