/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.refundReservation;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AccountingLinePNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import org.apache.commons.lang.StringUtils;

public class FillProductGdsIdProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        AccountingLinePNRB line;
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Product prod = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        if (StringUtils.isBlank((String)prod.getGdsId()) && !StringUtils.isBlank((String)prod.getSystemNumber()) && (line = this.findAccountingInfoBySystemNumber(response, prod.getSystemNumber())) != null && line.getPassengerName() != null) {
            prod.setGdsId(GetReservationHelper.getNameNumberFromAccountingLine(line));
        }
    }

    private AccountingLinePNRB findAccountingInfoBySystemNumber(GetReservationRSType response, String systemNumber) {
        if (response.getReservation().getAccountingLines() != null && response.getReservation().getAccountingLines().getAccountingLineList() != null) {
            for (AccountingLinePNRB line : response.getReservation().getAccountingLines().getAccountingLineList()) {
                if (line.getDocumentNumber() == null || !systemNumber.equals(line.getDocumentNumber())) continue;
                return line;
            }
        }
        return null;
    }
}

