/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.refundReservation;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetRefundAccountingLineNumberProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        Pattern pattern = Pattern.compile("(?<number>\\d+)\\. +R.*" + product.getSystemNumber());
        Matcher matcher = pattern.matcher(response);
        if (!matcher.find()) {
            throw Xeption.forDeveloper((String)"refund accounting line not found for ticket {0}", (Object[])new Object[]{product.getSystemNumber()});
        }
        BigInteger lineNumber = new BigInteger(matcher.group("number"));
        ctx.putObject((Enum)IBusGdsSabreContextKeys.REFUND_ACCOUNTING_LINE_NUMBER, (Object)lineNumber);
    }
}

