/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.refundReservation;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.InvoiceItineraryRQ;
import java.math.BigInteger;

public class InvoiceItineraryRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BigInteger refundAccountingLineNumber = (BigInteger)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.REFUND_ACCOUNTING_LINE_NUMBER);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        InvoiceItineraryRQ request = this.buildRequest(product, refundAccountingLineNumber);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"InvoiceItineraryLLSRQ");
    }

    private InvoiceItineraryRQ buildRequest(Product product, BigInteger refundAccountingLineNumber) {
        InvoiceItineraryRQ request = new InvoiceItineraryRQ();
        request.setVersion("2.0.0");
        request.setReturnHostCommand(Boolean.TRUE);
        request.setActionIdentifier(InvoiceItineraryRQ.ActionIdentifier.DIN);
        InvoiceItineraryRQ.OptionalQualifiers oq = new InvoiceItineraryRQ.OptionalQualifiers();
        InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers mq = new InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers();
        InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers.AccountingInfo info = new InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers.AccountingInfo();
        InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers.AccountingInfo.Line line = new InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers.AccountingInfo.Line();
        line.setNumber(refundAccountingLineNumber);
        info.getLineList().add(line);
        mq.setAccountingInfo(info);
        InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers.NameSelect ns = new InvoiceItineraryRQ.OptionalQualifiers.MiscQualifiers.NameSelect();
        ns.setNameNumber(product.getGdsId());
        mq.getNameSelectList().add(ns);
        oq.setMiscQualifiers(mq);
        request.setOptionalQualifiers(oq);
        return request;
    }
}

