/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.refundReservation;

import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.text.DecimalFormat;

public class RfndPnltyRemarkBuilder
extends BaseProcessor {
    private static DecimalFormat DF = new DecimalFormat("#0");

    public void process(MessageContext ctx) throws Exception {
        GdsProductRefexFinanceDetails details = (GdsProductRefexFinanceDetails)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PRODUCT_REFEX_FINANCE_DETAILS);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        StringBuilder sb = new StringBuilder();
        sb.append("X*RFND PNLTY-");
        CurrencyInfo eqvCurrInfo = DictHelper.getCurrencyInfoByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        sb.append(DF.format(details.getPenalty()));
        sb.append(eqvCurrInfo.getCode());
        sb.append('/');
        sb.append(product.getCarrierNumber());
        sb.append(product.getSystemNumber());
        sb.append("/CPNA");
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.INVOICE);
        remark.setText(sb.toString());
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }
}

