/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.refundReservation;

import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class TaxUsedRemarkBuilder
extends BaseProcessor {
    private static DecimalFormat DF = new DecimalFormat("#0");

    public void process(MessageContext ctx) throws Exception {
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        StringBuilder sb = new StringBuilder();
        sb.append("X*TAX USED-");
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        GdsProductRefexFinanceDetails details = (GdsProductRefexFinanceDetails)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PRODUCT_REFEX_FINANCE_DETAILS);
        boolean firstDifference = true;
        for (Tax tax : product.getTaxes()) {
            BigDecimal refundAmount = BigDecimal.ZERO;
            for (SimpleTax st : details.getTaxes()) {
                if (!tax.getCode().equals(st.getCode())) continue;
                refundAmount = st.getAmount();
                break;
            }
            if (tax.getEquivalentAmount().compareTo(refundAmount) == 0) continue;
            if (firstDifference) {
                firstDifference = false;
            } else {
                sb.append(' ');
            }
            sb.append(DF.format(tax.getEquivalentAmount().subtract(refundAmount)));
            sb.append(tax.getCode());
        }
        sb.append('/');
        sb.append(product.getCarrierNumber());
        sb.append(product.getSystemNumber());
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.INVOICE);
        remark.setText(sb.toString());
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }
}

