/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.refundReservation;

import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.DecimalFormat;
import java.util.Collection;

public class WFRTaxUpdateGroupMaskBuilder
extends BaseProcessor {
    private static final DecimalFormat DF = new DecimalFormat("#0");

    public void process(MessageContext ctx) {
        Collection taxes = (Collection)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.TAX_UPDATE_GROUP);
        Integer groupsIndex = (Integer)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.TAX_UPDATE_GROUP_INDEX);
        Integer groupsSize = (Integer)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.TAX_UPDATE_GROUP_SIZE);
        boolean hasMoreTaxes = groupsIndex < groupsSize;
        StringBuilder cmd = new StringBuilder();
        cmd.append("WF");
        for (SimpleTax tax : taxes) {
            cmd.append('<');
            cmd.append(DF.format(tax.getAmount()));
            cmd.append('>');
            cmd.append('<');
            cmd.append(tax.getCode());
            cmd.append('>');
        }
        if (hasMoreTaxes) {
            cmd.append("<A>");
        } else {
            cmd.append("<>");
        }
        cmd.append("<>");
        cmd.append("<>");
        cmd.append("<>");
        if (hasMoreTaxes) {
            cmd.append("<>");
        } else {
            cmd.append("<X>");
        }
        cmd.append("<>");
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_REQUEST, (Object)cmd.toString());
    }
}

