/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.refundReservation;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class WFRefundInformationMaskBuilder
extends BaseProcessor {
    private static final Pattern P_COMMISSION_ON_REFUND_AMT = Pattern.compile("^[ ]*COMMISSION ON REFUND AMT[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_COMMISSION_ON_REFUND_AMT_OR_PCT = Pattern.compile("^[ ]*COMMISSION ON REFUND AMT[^A-Z]+OR PCT[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_COMMISSION_ON_PENALTY_AMT = Pattern.compile("^[ ]*COMMISSION ON PENALTY AMT[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_WAIVER = Pattern.compile("^.*WAIVER[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_DK_NBR = Pattern.compile("^.*DK NBR[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_TOURCODE = Pattern.compile("^.*TOURCODE[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_INVOICE_NBR = Pattern.compile("^.*INVOICE NBR[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_FREE_TEXT = Pattern.compile("^.*FREE TEXT[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_REFUND = Pattern.compile("^.*REFUND[ ]+<([^>]+)>.*$", 8);
    private static final Pattern P_QUIT = Pattern.compile("^.*QUIT[ ]+<([^>]+)>.*$", 8);

    public void process(MessageContext ctx) throws Exception {
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        StringBuilder cmd = new StringBuilder();
        cmd.append("WF");
        Matcher m = P_COMMISSION_ON_REFUND_AMT.matcher(response);
        if (m.find()) {
            cmd.append('<');
            cmd.append(m.group(1).trim());
            cmd.append('>');
        }
        if ((m = P_COMMISSION_ON_REFUND_AMT_OR_PCT.matcher(response)).find()) {
            cmd.append('<');
            cmd.append(m.group(1).trim());
            cmd.append('>');
        }
        if ((m = P_COMMISSION_ON_PENALTY_AMT.matcher(response)).find()) {
            cmd.append('<');
            cmd.append(m.group(1).trim());
            cmd.append('>');
        }
        if ((m = P_WAIVER.matcher(response)).find()) {
            cmd.append('<');
            cmd.append(m.group(1).trim());
            cmd.append('>');
        }
        if ((m = P_DK_NBR.matcher(response)).find()) {
            cmd.append('<');
            String clientCode = ((Organization)EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile()).getEntity()).getCode();
            if (SabreHelper.isValidDkNumber((String)clientCode, (boolean)((Organization)EntityStorage.get().resolve(AirProductHelper.getSubagency((Product)product)).getEntity()).isWeakerDkNumberValidation())) {
                cmd.append(clientCode);
            }
            cmd.append('>');
        }
        if ((m = P_TOURCODE.matcher(response)).find()) {
            cmd.append('<');
            if (!StringUtils.isBlank((String)product.getTourCode())) {
                cmd.append(product.getTourCode());
            }
            cmd.append('>');
        }
        if ((m = P_INVOICE_NBR.matcher(response)).find()) {
            cmd.append('<');
            cmd.append(m.group(1).trim());
            cmd.append('>');
        }
        if ((m = P_FREE_TEXT.matcher(response)).find()) {
            cmd.append('<');
            cmd.append(m.group(1).trim());
            cmd.append('>');
        }
        if ((m = P_REFUND.matcher(response)).find()) {
            cmd.append('<');
            cmd.append('X');
            cmd.append('>');
        }
        if ((m = P_QUIT.matcher(response)).find()) {
            cmd.append('<');
            cmd.append('>');
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_REQUEST, (Object)cmd.toString());
    }
}

