/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.OBFeesInfo;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.GDSRepriceHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.AmountPattern;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetailsSegmentInfo;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;

public class GetReservationReadUpdateAfterRepriceProcessor
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"yyyy-MM-dd");

    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map endorsements = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.ENDORSEMENTS);
        Map cabinInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_INFO);
        Map luggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.LUGGAGE_INFO);
        Map cabinLuggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_LUGGAGE_INFO);
        HashMap<String, PriceQuoteDetails> pqs = new HashMap<String, PriceQuoteDetails>();
        for (PriceQuoteDetails pq : GetReservationHelper.getValidPriceQuotes(response)) {
            pqs.put(GetReservationHelper.deteminePassengerTypeCode(pq), pq);
        }
        for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
            String type = SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType());
            PriceQuoteDetails pq = (PriceQuoteDetails)pqs.get(type);
            PriceComponents oldComponents = new PriceComponents(prod);
            PriceComponents newComponents = new PriceComponents(pq);
            ProductFare theFare = PriceComponents.getTheFare(prod);
            Money baseFare = new Money();
            baseFare.setValue((BigDecimal)newComponents.baseFare.getFirst());
            baseFare.setCurrency((String)newComponents.baseFare.getSecond());
            theFare.setBaseFare(baseFare);
            theFare.setEquivalentFare((BigDecimal)newComponents.equivFare.getFirst());
            prod.setGdsCurrency((String)newComponents.equivFare.getSecond());
            prod.getTaxes().clear();
            for (GetReservationHelper.TaxAbstraction ta : newComponents.taxes) {
                prod.getTaxes().add(ta.toProductTax());
            }
            OBFeesInfo obFeesInfo = new OBFeesInfo();
            if (GetReservationHelper.parseObFeesInfo(pq, obFeesInfo)) {
                prod.setObFeesInfo(obFeesInfo);
            }
            if (!MiscUtil.equals(oldComponents.getTotal(), newComponents.getTotal())) {
                BigDecimal hiddenFee = GDSRepriceHelper.getHiddenFee((Product)prod);
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u043e\u043b\u043d\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0431\u0438\u043b\u0435\u0442\u0430 {0} \u0431\u044b\u043b\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430 \u0441 {1} {2} \u043d\u0430 {2} {3}", (Object[])new Object[]{AirProductHelper.getShortNameString((Product)prod), ((BigDecimal)oldComponents.getTotal().getFirst()).add(hiddenFee), oldComponents.getTotal().getSecond(), ((BigDecimal)newComponents.getTotal().getFirst()).add(hiddenFee), newComponents.getTotal().getSecond()}));
            }
            prod.setEndorsement(GetReservationHelper.buildProductEndorsement(pq, (String)endorsements.get(prod.getTraveller().getUid())));
            prod.setFareCalculationData(pq.getFareInfo().getFareCalculation().getString());
            prod.setFareOverlay(GetReservationHelper.parseFareOverlay(pq));
            HashMap pqSegments = new HashMap();
            pq.getSegmentInfoList().forEach(si -> pqSegments.put(si.getSegNumber(), si));
            HashMap itinSegments = new HashMap();
            GetReservationHelper.getAirs(response).forEach(air -> itinSegments.put(air.getSequence().toString(), air));
            Iterator cabinsItr = ((List)cabinInfo.get(SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType()))).iterator();
            String passengerTypeCode = SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType());
            Map ptcLuggageInfo = (Map)luggageInfo.get(passengerTypeCode);
            Map ptcCabinLuggageInfo = (Map)cabinLuggageInfo.get(passengerTypeCode);
            if (prod.getSegmentTariffs().size() != pqSegments.size()) continue;
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                if (st.getSegments().size() != pqSegments.size()) continue;
                for (Segment s : st.getSegments()) {
                    AirType itinSegment = (AirType)itinSegments.get(s.getGdsId());
                    GetReservationHelper.updateSegmentFromItinSegment(s, itinSegment);
                    PriceQuoteDetailsSegmentInfo pqSegment = (PriceQuoteDetailsSegmentInfo)pqSegments.get(s.getGdsId());
                    if (pqSegment.getBaggage() != null && pqSegment.getBaggage().getAllowance() != null) {
                        s.setLuggageInfo(GetReservationHelper.prepareLuggageInfo(pqSegment.getBaggage()));
                    } else {
                        s.setLuggageInfo(null);
                    }
                    s.setFareBasis(pqSegment.getFareBasis());
                    if (pqSegment.getNotValidBefore() != null) {
                        s.setNotValidBefore((Date)pqSegment.getNotValidBefore());
                    } else {
                        s.setNotValidBefore(null);
                    }
                    if (pqSegment.getNotValidAfter() != null) {
                        s.setNotValidAfter((Date)pqSegment.getNotValidAfter());
                    } else {
                        s.setNotValidAfter(null);
                    }
                    s.setServiceClass(SabreHelper.cabin2ClassOfService((String)((String)cabinsItr.next())));
                    if (ptcLuggageInfo == null && ptcCabinLuggageInfo == null) continue;
                    try {
                        List<String> key = Arrays.asList(SabreHelper.getNativeCode((DictionaryReference)s.getAirline()), DF.format(s.getStartDate()), s.getFlightNo(), SabreHelper.getNativeCode((DictionaryReference)s.getDepartureLocation()), SabreHelper.getNativeCode((DictionaryReference)s.getArriveLocation()));
                        if (s.getFareDetails() == null) {
                            s.setFareDetails(new FareDetails());
                        }
                        if (ptcLuggageInfo != null) {
                            s.getFareDetails().setLuggageInfo((ExtendedLuggageInfo)ptcLuggageInfo.get(key));
                        }
                        if (ptcCabinLuggageInfo == null) continue;
                        s.getFareDetails().setCabinLuggageInfo((ExtendedLuggageInfo)ptcCabinLuggageInfo.get(key));
                    }
                    catch (Exception ex) {
                        IncidentsLog.reportException((String)"failed populating luggage/cabin luggage info", (Throwable)ex);
                    }
                }
            }
        }
    }

    static class PriceComponents {
        final MiscUtil.Pair<BigDecimal, String> baseFare;
        final MiscUtil.Pair<BigDecimal, String> equivFare;
        final List<GetReservationHelper.TaxAbstraction> taxes = new ArrayList<GetReservationHelper.TaxAbstraction>();

        static ProductFare getTheFare(Product product) {
            for (ProductFare pf : product.getFares()) {
                if (pf.getSegmentTariff() != null) continue;
                return pf;
            }
            return null;
        }

        PriceComponents(Product product) {
            ProductFare fare = PriceComponents.getTheFare(product);
            if (fare == null) {
                this.baseFare = null;
                this.equivFare = null;
            } else {
                this.baseFare = new MiscUtil.Pair((Object)fare.getBaseFare().getValue(), (Object)fare.getBaseFare().getCurrency());
                this.equivFare = new MiscUtil.Pair((Object)fare.getEquivalentFare(), (Object)product.getGdsCurrency());
            }
            for (Tax tax : product.getTaxes()) {
                GetReservationHelper.TaxAbstraction ta = new GetReservationHelper.TaxAbstraction();
                ta.setBaseAmount(tax.getAmount());
                ta.setCode(tax.getCode());
                ta.setEquivalentAmount(tax.getEquivalentAmount());
                this.taxes.add(ta);
            }
        }

        PriceComponents(PriceQuoteDetails pq) {
            AmountPattern bf = pq.getFareInfo().getBaseFare();
            AmountPattern ef = GetReservationHelper.getEquivalentFareFromPq(pq);
            this.baseFare = new MiscUtil.Pair((Object)new BigDecimal(bf.getString()), (Object)bf.getCurrencyCode());
            this.equivFare = new MiscUtil.Pair((Object)new BigDecimal(ef.getString()), (Object)ef.getCurrencyCode());
            this.taxes.addAll(GetReservationHelper.parseTaxes(pq.getFareInfo().getTaxInfo()));
        }

        MiscUtil.Pair<BigDecimal, String> getTotal() {
            BigDecimal result = BigDecimal.ZERO;
            if (this.equivFare.getFirst() != null) {
                result = result.add((BigDecimal)this.equivFare.getFirst());
            }
            for (GetReservationHelper.TaxAbstraction tax : this.taxes) {
                if (tax.getEquivalentAmount() == null) continue;
                result = result.add(tax.getEquivalentAmount());
            }
            return new MiscUtil.Pair((Object)result, this.equivFare.getSecond());
        }
    }
}

