/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.repriceReservation;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import com.sabre.webservices.pnrbuilder.v119.FutureTicketingPNRB;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;

public class HasToUpdate7TAWProvider
extends BaseRoutingKeyProvider {
    private static final DateTimeFormatter DTF_hhmma = DateTimeFormatter.ofPattern("hhmma");
    private static final DateTimeFormatter DTF_HHmm = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter DTF_ddMMMyyyy = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMMyyyy").toFormatter(Locale.ENGLISH);
    private static final DateTimeFormatter DTF_yyyyMMdd = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public String getRoutingKey(MessageContext ctx) throws Exception {
        FutureTicketingPNRB ticketTimeLimit = (FutureTicketingPNRB)ctx.getObject((Enum)IBusGdsSabreContextKeys.FUTURE_TICKETING);
        if (ticketTimeLimit == null) {
            return Boolean.toString(true);
        }
        PassengerDetailsRQ.TravelItineraryAddInfoRQ.AgencyInfo.Ticketing ticketing = PassengerDetailsHelper.build7TAWBlock(ctx);
        return Boolean.toString(!HasToUpdate7TAWProvider.matches(ticketing, ticketTimeLimit));
    }

    private static boolean matches(PassengerDetailsRQ.TravelItineraryAddInfoRQ.AgencyInfo.Ticketing ticketing, FutureTicketingPNRB ticketTimeLimit) {
        try {
            if (!ticketTimeLimit.getCode().equals("TAW")) {
                return false;
            }
            if (!ticketTimeLimit.getBranchPCC().equals(ticketing.getPseudoCityCode())) {
                return false;
            }
            if (ticketTimeLimit.getTime() == null && ticketing.getTicketTimeLimit() != null) {
                return false;
            }
            if (ticketTimeLimit.getTime() != null && ticketing.getTicketTimeLimit() == null) {
                return false;
            }
            if (ticketTimeLimit.getTime() == null && ticketing.getTicketTimeLimit() == null) {
                return true;
            }
            String year = Integer.toString(LocalDate.now().getYear());
            if (!LocalDate.parse(year + "-" + ticketing.getTicketTimeLimit().substring(0, 5), DTF_yyyyMMdd).equals(LocalDate.parse(ticketTimeLimit.getDate() + year, DTF_ddMMMyyyy))) {
                return false;
            }
            return LocalTime.parse(ticketing.getTicketTimeLimit().substring(6), DTF_HHmm).equals(LocalTime.parse(ticketTimeLimit.getTime().concat("M"), DTF_hhmma));
        }
        catch (IndexOutOfBoundsException ex) {
            IncidentsLog.reportException((String)("unexpected RS.ticketTimeLimit=" + ticketTimeLimit + ", RQ.ticketTimeLimit=" + ticketing.getTicketTimeLimit()), (Throwable)ex);
            return false;
        }
    }
}

