/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.LocatorWithPartitionType;
import com.sabre.webservices.pnrbuilder.v119.OperationTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.ReceivedFromPNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkPNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkUpdatePNRB;
import com.sabre.webservices.pnrbuilder.v119.RequestEnumerationType;
import com.sabre.webservices.pnrbuilder.v119.RequestType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateItemType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateListType;
import com.sabre.webservices.pnrbuilder.v119.UpdateReservationRQ;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

public class UpdateTimeLimitRemarkBuilder
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"ddMMMyy HHmm", (Locale)Locale.ENGLISH);

    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RemarkPNRB remark = (RemarkPNRB)ctx.getObject((Enum)IBusGdsSabreContextKeys.TIME_LIMIT_REMARK);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Date newTimeLimit = PassengerDetailsHelper.getTimelimitForRemark(ctx);
        UpdateReservationRQ request = new UpdateReservationRQ();
        request.setVersion("1.19.11");
        RequestType requestType = new RequestType();
        requestType.setRequestEnumerationType(RequestEnumerationType.STATELESS);
        request.setRequestType(requestType);
        ReservationUpdateListType reservationUpdateList = new ReservationUpdateListType();
        LocatorWithPartitionType locator = new LocatorWithPartitionType();
        locator.setString(SabreHelper.getRecordLocator((Reservation)reservation));
        reservationUpdateList.setLocator(locator);
        ReservationUpdateListType.Choice choice = new ReservationUpdateListType.Choice();
        ReservationUpdateItemType reservationUpdateItem = new ReservationUpdateItemType();
        RemarkUpdatePNRB remarkUpdate = new RemarkUpdatePNRB();
        remarkUpdate.setId(remark != null ? remark.getId() : null);
        remarkUpdate.setOp(remark != null ? OperationTypePNRB.U : OperationTypePNRB.C);
        remarkUpdate.setType(RemarkTypePNRB.INTERFACE);
        remarkUpdate.setRemarkText(UpdateTimeLimitRemarkBuilder.buildText(newTimeLimit));
        reservationUpdateItem.getRemarkUpdateList().add(remarkUpdate);
        choice.getReservationUpdateItemList().add(reservationUpdateItem);
        reservationUpdateList.setChoice(choice);
        ReceivedFromPNRB receivedFrom = new ReceivedFromPNRB();
        receivedFrom.setAgentName(((SabreGdsAccount)gdsAccountCtr.getEntity()).getTransactionExecutor());
        reservationUpdateList.setReceivedFrom(receivedFrom);
        request.setReservationUpdateList(reservationUpdateList);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"UpdateReservationRQ");
    }

    private static String buildText(Date timeLimit) {
        StringBuilder sb = new StringBuilder();
        sb.append("IBE AUTO CANCEL/");
        sb.append(DF.format(timeLimit).toUpperCase());
        sb.append(" ");
        sb.append(TimeZone.getDefault().getID().toUpperCase());
        return sb.toString();
    }
}

