/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.reservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FrequentTravellerAgreements;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ConvertTravellerBonusCardToCustLoyaltyProcessor
extends BaseProcessor {
    private boolean skipIncompatible;
    private boolean trySegmentNumbers;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.skipIncompatible = Boolean.parseBoolean(parameters.get("skip_incompatible"));
        this.trySegmentNumbers = Boolean.parseBoolean(parameters.get("try_segment_numbers"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageContext ctx) throws Exception {
        BookingAirlineBonusCard card = (BookingAirlineBonusCard)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.BOOKING_AIRLINE_BONUS_CARD);
        String nameNumber = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER);
        PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.CustLoyalty loyalty = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.CustLoyalty();
        loyalty.setMembershipID(card.getNumber());
        loyalty.setNameNumber(nameNumber);
        loyalty.setProgramID(SabreHelper.getNativeCode((DictionaryReference)card.getAirline()));
        List<DictionaryReference<Airline>> compatibleAirlines = null;
        Flight flight = null;
        Product product = null;
        if (ctx.hasObject((Enum)IBusGdsContextKeys.FLIGHT)) {
            flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
            compatibleAirlines = ConvertTravellerBonusCardToCustLoyaltyProcessor.getCompatibleAirlinesForFFCard(flight, (DictionaryReference<Airline>)card.getAirline());
        } else {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            product = (Product)GDSHelper.getProducts((Reservation)reservation).get(0);
            compatibleAirlines = ConvertTravellerBonusCardToCustLoyaltyProcessor.getCompatibleAirlinesForFFCard(product, (DictionaryReference<Airline>)card.getAirline());
        }
        if (compatibleAirlines.isEmpty()) {
            if (this.skipIncompatible) {
                return;
            }
        } else if (compatibleAirlines.size() > 1 || !compatibleAirlines.contains(card.getAirline())) {
            if (compatibleAirlines.size() > 4) {
                String segmentNumbers;
                if (!this.trySegmentNumbers) throw Xeption.forEndUser((String)"Unable to add FF card to more than 4 airlines, try to book without FF info and ask the agent to add it manually later", (Object[])new Object[0]);
                String string = segmentNumbers = flight != null ? ConvertTravellerBonusCardToCustLoyaltyProcessor.getApplicableSegmentsString(flight, (DictionaryReference<Airline>)card.getAirline()) : ConvertTravellerBonusCardToCustLoyaltyProcessor.getApplicableSegmentsString(product, (DictionaryReference<Airline>)card.getAirline());
                if (segmentNumbers != null) {
                    loyalty.setSegmentNumber(segmentNumbers);
                }
            } else {
                StringBuilder sb = new StringBuilder(12);
                for (DictionaryReference dictionaryReference : compatibleAirlines) {
                    sb.append(SabreHelper.getNativeCode((DictionaryReference)dictionaryReference));
                    sb.append(',');
                }
                sb.setLength(sb.length() - 1);
                loyalty.setTravelingCarrierCode(sb.toString());
            }
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.CUST_LOYALTY, (Object)loyalty);
    }

    private static List<DictionaryReference<Airline>> getCompatibleAirlinesForFFCard(Flight flight, DictionaryReference<Airline> cardOwnerAirline) {
        Collection<FrequentTravellerAgreements> agreements = SabreServerHelper.getFrequentTravellerAgreementsByOwningCarrier(cardOwnerAirline);
        ArrayList<DictionaryReference<Airline>> compatibleAirlines = new ArrayList<DictionaryReference<Airline>>(4);
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            block1: for (FlightSegment fs : fst.getSegments()) {
                DictionaryReference airline = fs.getAirline();
                if (compatibleAirlines.contains(airline)) continue;
                if (airline.equals(cardOwnerAirline)) {
                    compatibleAirlines.add((DictionaryReference<Airline>)airline);
                    continue;
                }
                for (FrequentTravellerAgreements agreement : agreements) {
                    if (!airline.equals((Object)agreement.getReceivingCarrier())) continue;
                    compatibleAirlines.add((DictionaryReference<Airline>)airline);
                    continue block1;
                }
            }
        }
        return compatibleAirlines;
    }

    private static List<DictionaryReference<Airline>> getCompatibleAirlinesForFFCard(Product product, DictionaryReference<Airline> cardOwnerAirline) {
        Collection<FrequentTravellerAgreements> agreements = SabreServerHelper.getFrequentTravellerAgreementsByOwningCarrier(cardOwnerAirline);
        ArrayList<DictionaryReference<Airline>> compatibleAirlines = new ArrayList<DictionaryReference<Airline>>(4);
        for (SegmentTariff fst : product.getSegmentTariffs()) {
            block1: for (Segment fs : fst.getSegments()) {
                DictionaryReference airline = fs.getAirline();
                if (compatibleAirlines.contains(airline)) continue;
                if (airline.equals(cardOwnerAirline)) {
                    compatibleAirlines.add((DictionaryReference<Airline>)airline);
                    continue;
                }
                for (FrequentTravellerAgreements agreement : agreements) {
                    if (!airline.equals((Object)agreement.getReceivingCarrier())) continue;
                    compatibleAirlines.add((DictionaryReference<Airline>)airline);
                    continue block1;
                }
            }
        }
        return compatibleAirlines;
    }

    private static String getApplicableSegmentsString(Flight flight, DictionaryReference<Airline> cardOwnerAirline) {
        Collection<FrequentTravellerAgreements> agreements = SabreServerHelper.getFrequentTravellerAgreementsByOwningCarrier(cardOwnerAirline);
        StringBuilder sb = new StringBuilder();
        int segmentNumber = 1;
        boolean hasPartnerSegments = false;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                DictionaryReference airline = fs.getAirline();
                if (airline.equals(cardOwnerAirline)) {
                    sb.append(segmentNumber);
                    sb.append(',');
                } else {
                    for (FrequentTravellerAgreements agreement : agreements) {
                        if (!airline.equals((Object)agreement.getReceivingCarrier())) continue;
                        sb.append(segmentNumber);
                        sb.append(',');
                        hasPartnerSegments = true;
                        break;
                    }
                }
                ++segmentNumber;
            }
        }
        if (hasPartnerSegments && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    private static String getApplicableSegmentsString(Product flight, DictionaryReference<Airline> cardOwnerAirline) {
        Collection<FrequentTravellerAgreements> agreements = SabreServerHelper.getFrequentTravellerAgreementsByOwningCarrier(cardOwnerAirline);
        StringBuilder sb = new StringBuilder();
        int segmentNumber = 1;
        boolean hasPartnerSegments = false;
        for (SegmentTariff fst : flight.getSegmentTariffs()) {
            for (Segment fs : fst.getSegments()) {
                DictionaryReference airline = fs.getAirline();
                if (airline.equals(cardOwnerAirline)) {
                    sb.append(segmentNumber);
                    sb.append(',');
                } else {
                    for (FrequentTravellerAgreements agreement : agreements) {
                        if (!airline.equals((Object)agreement.getReceivingCarrier())) continue;
                        sb.append(segmentNumber);
                        sb.append(',');
                        hasPartnerSegments = true;
                        break;
                    }
                }
                ++segmentNumber;
            }
        }
        if (hasPartnerSegments && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }
}

