/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.reservation;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ReservationAirPriceRQParametersProcessor
extends BaseProcessor {
    private boolean retain;
    private boolean lowestFare;
    private boolean lowestFareRebook;
    private boolean incomplete;

    public void configure(Map<String, String> parameters) {
        this.retain = MiscUtil.isTrue((String)parameters.get("retain"));
        this.lowestFare = MiscUtil.isTrue((String)parameters.get("lowestFare"));
        this.lowestFareRebook = MiscUtil.isTrue((String)parameters.get("lowestFareRebook"));
        this.incomplete = MiscUtil.isTrue((String)parameters.get("incomplete"));
    }

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        final SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SpecialTariff specialTariff = reservation.getSpecialTariff() != null ? (SpecialTariff)EntityStorage.get().resolve(reservation.getSpecialTariff()).getEntity() : null;
        final GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        ImmutableListMultimap productsByUniqueQualifiers = Multimaps.index((Iterable)GDSHelper.getProducts((Reservation)reservation), (Function)new Function<Product, AirPriceHelper.UniqueQualifiers>(){

            public AirPriceHelper.UniqueQualifiers apply(Product product) {
                try {
                    AirPriceHelper.UniqueQualifiers result = new AirPriceHelper.UniqueQualifiers();
                    result.commission = AirPriceHelper.buildCommissionQualifier(SabreHelper.getTotalVendorCommissionForSabre((Product)product), product.getGdsCurrency());
                    result.endorsement = SabreServerHelper.buildEndorsement(gdsParameters, product);
                    result.suOnBsp = product.getBlankOwnerRef() == null ? SabreHelper.isSuOnBsp((DictionaryReference)product.getCarrier(), (EntityReference)gdsParameters.getBlankOwner(), (EntityReference)salesContext.getSalesPoint()) : SabreHelper.isSuOnBsp((Product)product);
                    result.brandIds = AirPriceHelper.getBrandIds(product);
                    if (product.getReservation().isSabreSmartPricePricing()) {
                        Product adultProduct = GDSHelper.getProducts((Reservation)product.getReservation()).stream().filter(p -> DictHelper.getAdultPassengerType().equals((Object)p.getPassengerType())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"SmartPrice reservation without adult", (Object[])new Object[0]));
                        result.smartPriceFareBasises = AirPriceHelper.getSmartPriceFareBasises(adultProduct);
                    }
                    result.publicFare = AirPriceHelper.getPublicFare(product);
                    result.refundableAny = AirPriceHelper.getRefundableAny(product);
                    result.privateFare = product.isPrivateFare();
                    result.vatInfo = SabreServerHelper.buildEndorsementVatInfo(product);
                    return result;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        ArrayList<AirPriceRQParameters> result = new ArrayList<AirPriceRQParameters>();
        HashMap<String, String> endorsements = new HashMap<String, String>();
        for (Map.Entry entry : productsByUniqueQualifiers.asMap().entrySet()) {
            AirPriceHelper.UniqueQualifiers uq = (AirPriceHelper.UniqueQualifiers)entry.getKey();
            ImmutableListMultimap productsByType = Multimaps.index((Iterable)((Iterable)entry.getValue()), (Function)new Function<Product, String>(){

                public String apply(Product prod) {
                    return SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType());
                }
            });
            ArrayList types = new ArrayList(productsByType.keySet());
            Collections.sort(types);
            for (List atomicTypes : Lists.partition(types, (int)4)) {
                AirPriceRQParameters parameters = new AirPriceRQParameters();
                ArrayList<Product> atomicProducts = new ArrayList<Product>();
                for (String atomicType : atomicTypes) {
                    for (BaseProduct bp : productsByType.get((Object)atomicType)) {
                        atomicProducts.add((Product)bp);
                    }
                }
                Product anyProduct = (Product)atomicProducts.get(0);
                parameters.setGdsAccount(reservation.getGdsNameInfo().getOnlineGdsAccount());
                if (!StringUtils.isBlank((String)reservation.getAccountCode())) {
                    parameters.getAccountCodes().add(reservation.getAccountCode());
                }
                parameters.setCorporateId(reservation.getCorporateId());
                if (gdsParameters.getValidatingCarrier() != null) {
                    parameters.setCarrier(gdsParameters.getValidatingCarrier());
                } else {
                    parameters.setCarrier(anyProduct.getCarrier());
                }
                parameters.setGdsCurrencyCode(anyProduct.getGdsCurrency());
                parameters.setCommission(SabreHelper.getTotalVendorCommissionForSabre((Product)anyProduct));
                for (String atomicType : atomicTypes) {
                    parameters.getPassengerTypes().add(new MiscUtil.Pair((Object)atomicType, (Object)productsByType.get((Object)atomicType).size()));
                }
                if (!this.incomplete) {
                    for (Product atomicProduct : atomicProducts) {
                        parameters.getNameNumbers().add(atomicProduct.getGdsId());
                    }
                }
                parameters.setRetain(this.retain);
                parameters.setLowestFare(this.lowestFare);
                parameters.setLowestFareRebook(this.lowestFareRebook);
                parameters.setTourCode(anyProduct.getTourCode());
                parameters.setTripartiteContractDetails(anyProduct.getTripartiteContractDetails());
                if (specialTariff != null) {
                    parameters.setExemptAllTaxes(specialTariff.isExcludeTaxes());
                    parameters.setResidentCountry(specialTariff.getResidentCountry());
                }
                parameters.setEndorsement(uq.endorsement);
                for (Product atomicProduct : atomicProducts) {
                    endorsements.put(atomicProduct.getTraveller().getUid(), uq.endorsement);
                }
                for (Segment s : AirProductHelper.getSegments((Collection)anyProduct.getSegmentTariffs())) {
                    parameters.getSegmentNumbers().add(s.getGdsId());
                }
                parameters.setIncomplete(this.incomplete);
                if (uq.brandIds != null) {
                    parameters.getBrandIds().addAll(uq.brandIds);
                }
                if (uq.smartPriceFareBasises != null) {
                    parameters.getSmartPriceFareBasises().addAll(uq.smartPriceFareBasises);
                }
                parameters.setPublicFare(uq.publicFare);
                parameters.setRefundableAny(uq.refundableAny);
                if (SabreHelper.isTchBlankOwner((EntityReference)anyProduct.getBlankOwnerRef())) {
                    parameters.setValidationMethod("TCH");
                }
                parameters.setVatInfo(uq.vatInfo);
                parameters.setSupplier(AirProductHelper.getSupplier((Product)anyProduct));
                parameters.setBlankOwner(anyProduct.getBlankOwnerRef());
                result.add(parameters);
            }
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.ENDORSEMENTS, endorsements);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.AIR_PRICE_RQ_PARAMETERS_SET, result);
    }
}

