/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.reservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Iterator;

public class SabreReservationContextProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        HashMap<String, String> nameNumbers = new HashMap<String, String>();
        for (Product product : GDSHelper.getProducts((Reservation)reservation)) {
            nameNumbers.put(product.getTraveller().getUid(), product.getGdsId());
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS, nameNumbers);
        Iterator iter = GDSHelper.getProducts((Reservation)reservation).iterator();
        HashMap<String, String> infantToMajorAssociatios = new HashMap<String, String>();
        for (Product product : GDSHelper.getProducts((Reservation)reservation)) {
            if (!DictHelper.isInfantPassengerType((DictionaryReference)product.getPassengerType())) continue;
            boolean found = false;
            while (iter.hasNext()) {
                Product majProduct = (Product)iter.next();
                if (!DictHelper.isEqualsPredifinedValue((DictionaryReference)majProduct.getPassengerType(), (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.ADULT, PassengerTypeValue.YOUTH, PassengerTypeValue.SENIOR})) continue;
                infantToMajorAssociatios.put(product.getTraveller().getUid(), majProduct.getTraveller().getUid());
                found = true;
                break;
            }
            if (found) continue;
            throw Xeption.forDeveloper((String)"could not associate a major for infant", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.INFANT_TO_MAJOR_ASSOCIATIONS, infantToMajorAssociatios);
    }
}

