/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRQ;
import java.util.Collection;
import java.util.Iterator;

public class AirPriceRQAlternativePricingRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection corporateIds;
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        OTAAirPriceRQ request = new OTAAirPriceRQ();
        request.setVersion("2.17.0");
        request.setReturnHostCommand(Boolean.TRUE);
        request.setPriceRequestInformationAlternativePricing(Boolean.TRUE);
        OTAAirPriceRQ.OptionalQualifiers oq = new OTAAirPriceRQ.OptionalQualifiers();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers pq = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers();
        Iterator iter = flight.getSeats().iterator();
        while (iter.hasNext()) {
            SeatPreferences sp = (SeatPreferences)iter.next();
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.PassengerType pt = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.PassengerType();
            pt.setQuantity(Integer.toString(sp.getCount()));
            pt.setCode(SabreHelper.getNativeCode((DictionaryReference)sp.getPassengerType()));
            if (!iter.hasNext()) {
                pt.setForce(Boolean.TRUE);
            }
            pq.getPassengerTypeList().add(pt);
        }
        Collection accountCodes = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES);
        if (accountCodes != null && !accountCodes.isEmpty()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Account account = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Account();
            for (Object accountCode : accountCodes) {
                account.getCodeList().add(accountCode);
            }
            pq.setAccount(account);
        }
        if ((corporateIds = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.CORPORATE_IDS)) != null && !corporateIds.isEmpty()) {
            OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Corporate corporate = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.Corporate();
            for (String corporateId : corporateIds) {
                corporate.getIDList().add(corporateId);
            }
            pq.setCorporate(corporate);
        }
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificPenalty sp = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.SpecificPenalty();
        sp.setAdditionalInfo(Boolean.TRUE);
        pq.setSpecificPenalty(sp);
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing ap = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides o = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides();
        OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides.MatchNoMatch mnm = new OTAAirPriceRQ.OptionalQualifiers.PricingQualifiers.AlternativePricing.Overrides.MatchNoMatch();
        mnm.setInd(Boolean.TRUE);
        o.setMatchNoMatch(mnm);
        ap.setOverrides(o);
        pq.setAlternativePricing(ap);
        oq.setPricingQualifiers(pq);
        request.setOptionalQualifiers(oq);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirPriceLLSRQ");
    }
}

