/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreRemarksSearchContext;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.GdsTracingFlightItemBuilder;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class AirPriceRSAlternativePricingFlightsParser
extends BaseProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        boolean enableSmartPricePricing = ((SabreGdsAccount)gdsAccountCtr.getEntity()).isEnableSmartPricePricing();
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Map accountCodes = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE);
        Map corporateIds = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CORPORATE_IDS_BY_AIRLINE);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingFlightItemBuilder builder = isSaveRulesTraces ? new GdsTracingFlightItemBuilder() : null;
        try {
            String gdsCurrencyCode = response.getPriceQuote().getPricedItinerary().getCurrencyCode();
            HashMap<List<String>, Map<String, List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>>> data = new HashMap<List<String>, Map<String, List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>>>();
            for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info : response.getPriceQuote().getPricedItinerary().getAirItineraryPricingInfoList()) {
                List classCombination = AirPriceHelper.getBookingClasses(info, response.getPriceQuote().getMiscInformation().getHeaderInformationList());
                if (!data.containsKey(classCombination)) {
                    data.put(classCombination, new HashMap());
                }
                String pt = info.getPassengerTypeQuantity().getCode();
                if (!((Map)data.get(classCombination)).containsKey(pt)) {
                    ((Map)data.get(classCombination)).put(pt, new ArrayList());
                }
                if (((List)((Map)data.get(classCombination)).get(pt)).isEmpty() || enableSmartPricePricing) {
                    ((List)((Map)data.get(classCombination)).get(pt)).add(info);
                    continue;
                }
                BigDecimal oldEquivFareAmount = AirPriceHelper.getEquivFareAmount(((OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo)CollectionUtil.single((Collection)((Collection)((Map)data.get(classCombination)).get(pt)))).getItinTotalFare());
                BigDecimal newEquivFareAmount = AirPriceHelper.getEquivFareAmount(info.getItinTotalFare());
                if (newEquivFareAmount.compareTo(oldEquivFareAmount) < 0) {
                    OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo excludedInfo = ((List)((Map)data.get(classCombination)).get(pt)).set(0, info);
                    if (builder == null) continue;
                    String message = String.format("excluded because not cheapest within rbd combination %s and SmartPrice is not enabled", String.join((CharSequence)"/", classCombination));
                    builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(excludedInfo), MessageType.MESSAGE, message);
                    continue;
                }
                if (builder == null) continue;
                String message = String.format("excluded because not cheapest within rbd combination %s and SmartPrice is not enabled", String.join((CharSequence)"/", classCombination));
                builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message);
            }
            Set requiredPts = flight.getSeats().stream().map(sp -> SabreHelper.getNativeCode((DictionaryReference)sp.getPassengerType())).collect(Collectors.toSet());
            for (List classCombination : new HashSet(data.keySet())) {
                Set pts = ((Map)data.get(classCombination)).keySet();
                if (pts.equals(requiredPts)) continue;
                Map removed = (Map)data.remove(classCombination);
                if (builder == null) continue;
                Object[] objectArray = new Object[2];
                objectArray[0] = String.join((CharSequence)"/", classCombination);
                objectArray[1] = requiredPts.stream().filter(Predicates.not(pts::contains)).collect(Collectors.joining(", "));
                String message = String.format("excluded because rbd combination %s is missing for PTCs %s", objectArray);
                removed.values().stream().flatMap(Collection::stream).forEach(arg_0 -> AirPriceRSAlternativePricingFlightsParser.lambda$process$1((GdsTracingItemBuilder)builder, message, arg_0));
            }
            for (Map classCombinationOptions : data.values()) {
                for (List options : classCombinationOptions.values()) {
                    Iterator iter = options.iterator();
                    block7: while (iter.hasNext()) {
                        OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info = (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo)iter.next();
                        for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo otherInfo : new ArrayList(options)) {
                            if (info == otherInfo || !AirPriceRSAlternativePricingFlightsParser.isUnpriceable(info, otherInfo)) continue;
                            iter.remove();
                            if (builder == null) continue block7;
                            builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, String.format("excluded because option #%s is cheaper and has conflicting fare basises", otherInfo.getSolutionSequenceNmbr()));
                            continue block7;
                        }
                    }
                }
            }
            for (Option option : AirPriceRSAlternativePricingFlightsParser.combineOptions(data, (GdsTracingItemBuilder<Flight>)builder)) {
                Object fst2;
                Flight newFlight = FlightHelper.cloneFlightItin((Flight)flight);
                newFlight.setAccountCode(null);
                newFlight.setAccountCodeApplied(false);
                newFlight.setCorporateId(null);
                newFlight.setCorporateIdApplied(false);
                newFlight.setSabreSmartPricePricing(option.isSmartPriceRequired());
                newFlight.setGdsCurrencyCode(gdsCurrencyCode);
                Iterator<String> bookingClassesIter = option.getBookingClasses().iterator();
                for (Object fst2 : newFlight.getSegmentTariffs()) {
                    for (FlightSegment fs : fst2.getSegments()) {
                        String bookingClass = bookingClassesIter.next();
                        fs.setBookingClass(bookingClass);
                    }
                }
                List flightSegments = FlightHelper.getSegments((Flight)newFlight);
                newFlight.getSegmentTariffs().clear();
                fst2 = option.getInfos().iterator();
                while (fst2.hasNext()) {
                    OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info = (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo)fst2.next();
                    String passengerTypeCode = info.getPassengerTypeQuantity().getCode();
                    DictionaryReference passengerType = SabreHelper.resolveNativeCode(PassengerType.class, (String)passengerTypeCode);
                    SeatPreferences sp2 = new SeatPreferences();
                    sp2.setPassengerType(passengerType);
                    sp2.setCount(Integer.parseInt(info.getPassengerTypeQuantity().getQuantity()));
                    newFlight.getSeats().add(sp2);
                    FlightFare fare = new FlightFare();
                    Money baseAmount = new Money();
                    baseAmount.setCurrency(info.getItinTotalFare().getBaseFare().getCurrencyCode());
                    baseAmount.setValue(new BigDecimal(info.getItinTotalFare().getBaseFare().getAmount()));
                    fare.setEquivalentAmount(AirPriceHelper.getEquivFareAmount(info.getItinTotalFare()));
                    fare.setBaseAmount(baseAmount);
                    fare.setPassengerType(passengerType);
                    newFlight.getFares().add(fare);
                    if (info.getItinTotalFare().getTaxes() != null && info.getItinTotalFare().getTaxes().getTaxList() != null) {
                        for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.ItinTotalFare.Taxes.Tax tax : info.getItinTotalFare().getTaxes().getTaxList()) {
                            FlightTax ft = new FlightTax();
                            ft.setEquivalentAmount(new BigDecimal(tax.getAmount()));
                            ft.setCode(tax.getTicketingTaxCode());
                            ft.setPassengerType(passengerType);
                            newFlight.getTaxes().add(ft);
                        }
                    }
                    if (newFlight.getSegmentTariffs().isEmpty()) {
                        String calcLine = info.getFareCalculation().getText();
                        List fstList = GDSHelper.buildFlightSegmentTariffs((List)flightSegments, (String)calcLine);
                        newFlight.getSegmentTariffs().addAll(fstList);
                    }
                    Iterator<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown> ptcFBIter = AirPriceHelper.getValidPTCFareBreakdownList(info).iterator();
                    for (FlightSegment fs : FlightHelper.getSegments((Flight)newFlight)) {
                        OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown ptcFB = ptcFBIter.next();
                        FareInfo fi = new FareInfo();
                        fi.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)ptcFB.getFreeBaggageAllowance()));
                        fi.setFareBasis(ptcFB.getFareBasis().getCode());
                        fi.setPassengerType(passengerType);
                        SabreRemarksSearchContext srsc = new SabreRemarksSearchContext();
                        srsc.setPType(passengerTypeCode);
                        srsc.setSegNumber(fs.getGdsId());
                        fi.setRemarksSearchContext(XSUtil.toString((XSSerializable)srsc));
                        fs.getFareInfos().add(fi);
                        fs.setServiceClass(SabreHelper.cabin2ClassOfService((String)ptcFB.getCabin()));
                        String value = ptcFB.getFareBasis().getCorporateID();
                        if (SabreServerHelper.isAccountCode(value, accountCodes, corporateIds, (DictionaryReference<Airline>)newFlight.getCarrier())) {
                            newFlight.setAccountCode(value);
                        } else {
                            newFlight.setCorporateId(value);
                        }
                        if (!StringUtils.isBlank((String)value)) {
                            if (flight.getTripartiteContractDetails() == null) {
                                flight.setTripartiteContractDetails(new TripartiteContractDetails());
                            }
                            flight.getTripartiteContractDetails().setIssuedUnder3d(true);
                        }
                        newFlight.setAccountCodeApplied(true);
                        newFlight.setCorporateIdApplied(true);
                    }
                }
                ArrayList<Flight> flights = (ArrayList<Flight>)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
                if (flights == null) {
                    flights = new ArrayList<Flight>();
                    ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
                }
                flights.add(newFlight);
            }
        }
        finally {
            GdsTracingDocument document;
            if (builder != null && (document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT)) != null) {
                document.getParts().add(builder.buildGdsTracingDocumentPart("AirPriceRSAlternativePricingFlightsParser"));
            }
        }
    }

    private static boolean isUnpriceable(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info, OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo otherInfo) {
        if (AirPriceHelper.getEquivFareAmount(otherInfo.getItinTotalFare()).compareTo(AirPriceHelper.getEquivFareAmount(info.getItinTotalFare())) > 0) {
            return false;
        }
        List fareBasises = AirPriceHelper.getValidPTCFareBreakdownList(info).stream().map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown::getFareBasis).map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown.FareBasis::getCode).map(AirPriceHelper::stripTicketDesignator).collect(Collectors.toList());
        List otherFareBasises = AirPriceHelper.getValidPTCFareBreakdownList(otherInfo).stream().map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown::getFareBasis).map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown.FareBasis::getCode).collect(Collectors.toList());
        for (int i = 0; i < fareBasises.size(); ++i) {
            if (((String)otherFareBasises.get(i)).startsWith((String)fareBasises.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<Option> combineOptions(Map<List<String>, Map<String, List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>>> data, GdsTracingItemBuilder<Flight> builder) {
        String adultPtc = SabreHelper.getNativeCode((DictionaryReference)DictHelper.getAdultPassengerType());
        ArrayList<Option> result = new ArrayList<Option>();
        for (Map.Entry<List<String>, Map<String, List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>>> entry : data.entrySet()) {
            String message;
            Option option;
            if (entry.getValue().values().stream().noneMatch(l -> l.size() > 1)) {
                option = new Option(entry.getKey(), entry.getValue().values().stream().map(CollectionUtil::single).collect(Collectors.toList()), false);
                result.add(option);
                if (builder == null) continue;
                message = String.format("added with SmartPrice=false and no combination logic because infos %s are unique within their PTC for rbd combination %s", option.getInfos().stream().map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo::getSolutionSequenceNmbr).collect(Collectors.joining(", ")), String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey()));
                option.getInfos().forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message));
                continue;
            }
            if (entry.getValue().size() == 1) {
                List infos2 = (List)((Map.Entry)CollectionUtil.single(entry.getValue().entrySet())).getValue();
                ValueHolder cheapestHolder = new ValueHolder((Object)true);
                infos2.stream().sorted(Comparator.comparing(info -> AirPriceHelper.getEquivFareAmount(info.getItinTotalFare()))).forEachOrdered(info -> {
                    boolean cheapest = (Boolean)cheapestHolder.getValue();
                    result.add(new Option((List)entry.getKey(), Collections.singletonList(info), !cheapest));
                    if (builder != null) {
                        String message = String.format("added with SmartPrice=%s and no combination logic because of single requested ptc and cheapest = %s", !cheapest, cheapest);
                        builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message);
                    }
                    if (cheapest) {
                        cheapestHolder.setValue((Object)false);
                    }
                });
                continue;
            }
            if (!entry.getValue().containsKey(adultPtc)) {
                option = new Option(entry.getKey(), entry.getValue().values().stream().map(l -> l.stream().min(Comparator.comparing(info -> AirPriceHelper.getEquivFareAmount(info.getItinTotalFare()))).orElseThrow(() -> Xeption.forDeveloper((String)"unexpected empty list", (Object[])new Object[0]))).collect(Collectors.toList()), false);
                result.add(option);
                if (builder == null) continue;
                String message1 = String.format("added with SmartPrice=false and no combination logic because it's cheapest within rbd combination %s", String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey()));
                option.getInfos().forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message1));
                String message2 = String.format("excluded because no ADT in request (thus no way to combine) and not the cheapest within rbd combination %s", String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey()));
                entry.getValue().values().stream().flatMap(l -> l.stream().sorted(Comparator.comparing(info -> AirPriceHelper.getEquivFareAmount(info.getItinTotalFare()))).skip(1L)).forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message2));
                continue;
            }
            Option cheapestOption = new Option(entry.getKey(), entry.getValue().values().stream().map(l -> {
                OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo cheapestInfo = l.stream().min(Comparator.comparing(info -> AirPriceHelper.getEquivFareAmount(info.getItinTotalFare()))).orElseThrow(() -> Xeption.forDeveloper((String)"unexpected empty list", (Object[])new Object[0]));
                l.remove(cheapestInfo);
                return cheapestInfo;
            }).collect(Collectors.toList()), false);
            result.add(cheapestOption);
            if (builder != null) {
                message = String.format("added with SmartPrice=false and pulled out from combination logic because it's cheapest within rbd combination %s", String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey()));
                cheapestOption.getInfos().forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message));
            }
            Stream<Object> stream = AirPriceRSAlternativePricingFlightsParser.combineAirItineraryPricingInfos(entry.getValue(), cheapestOption, builder).stream();
            if (builder != null) {
                stream = stream.peek(infos -> infos.forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, "added with SmartPrice=true")));
            }
            result.addAll(stream.map(infos -> new Option((List)entry.getKey(), (List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>)infos, true)).collect(Collectors.toList()));
        }
        return result;
    }

    private static List<List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>> combineAirItineraryPricingInfos(Map<String, List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>> data, Option cheapestOption, GdsTracingItemBuilder<Flight> builder) {
        String adultPtc = SabreHelper.getNativeCode((DictionaryReference)DictHelper.getAdultPassengerType());
        List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo> adultData = data.get(adultPtc);
        if (adultData.isEmpty()) {
            if (builder != null) {
                String message = "excluded because no matching adult data found";
                data.values().stream().flatMap(Collection::stream).forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message));
            }
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        int segCount = AirPriceHelper.getValidPTCFareBreakdownList(adultData.get(0)).size();
        Comparator<List> comparator = Comparator.comparing(l -> ((String)l.get(0)).length());
        int i2 = 1;
        while (i2 < segCount) {
            int j = i2++;
            comparator = comparator.thenComparing(l -> ((String)l.get(j)).length());
        }
        List adultFareBasisesSorted = adultData.stream().map(info -> AirPriceHelper.getValidPTCFareBreakdownList(info).stream().map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown::getFareBasis).map(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown.FareBasis::getCode).collect(Collectors.toList())).sorted(comparator).collect(Collectors.toList());
        for (List adultFareBasis : adultFareBasisesSorted) {
            HashMap<String, Object> option2 = new HashMap<String, Object>();
            HashSet<String> invalidPtcs = new HashSet<String>();
            for (Map.Entry<String, List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo>> entry : data.entrySet()) {
                BiPredicate<Integer, String> p = entry.getKey().equals(adultPtc) ? (i, s) -> ((String)adultFareBasis.get((int)i)).equals(s) : (i, s) -> s.startsWith((String)adultFareBasis.get((int)i));
                List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo> matchingInfos = entry.getValue().stream().filter(info -> IntStream.range(0, segCount).allMatch(i -> p.test(i, AirPriceRSAlternativePricingFlightsParser.getFareBasisAtSegment(info, i)))).collect(Collectors.toList());
                if (matchingInfos.size() == 1) {
                    option2.put(entry.getKey(), matchingInfos.get(0));
                } else if (matchingInfos.isEmpty()) {
                    OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info2 = (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo)Streams.single(cheapestOption.getInfos().stream().filter(cheapestInfo -> ((String)entry.getKey()).equals(cheapestInfo.getPassengerTypeQuantity().getCode())));
                    option2.put(entry.getKey(), info2);
                    if (builder != null) {
                        String message = String.format("used as a fallback while matching by fare basises %s", String.join((CharSequence)"-", adultFareBasis));
                        builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info2), MessageType.MESSAGE, message);
                    }
                } else {
                    invalidPtcs.add(entry.getKey());
                }
                if (builder == null || matchingInfos.size() <= 1) continue;
                String message = String.format("caused ambiguous matching by fare basises %s", String.join((CharSequence)"-", adultFareBasis));
                matchingInfos.forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message));
            }
            if (invalidPtcs.isEmpty()) {
                result.add(option2);
                continue;
            }
            if (builder == null) continue;
            String message = String.format("excluded because PTCs %s caused ambiguous matching by fare basises %s", String.join((CharSequence)", ", invalidPtcs), String.join((CharSequence)"-", adultFareBasis));
            option2.values().forEach(info -> builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message));
        }
        return result.stream().map(option -> new ArrayList(option.values())).collect(Collectors.toList());
    }

    private static String getFareBasisAtSegment(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info, int idx) {
        return AirPriceHelper.getValidPTCFareBreakdownList(info).get(idx).getFareBasis().getCode();
    }

    private static Flight createFakeFlight(OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info) {
        Flight result = new Flight();
        FlightSegmentTariff fst = new FlightSegmentTariff();
        fst.getSegments().addAll(AirPriceHelper.getValidPTCFareBreakdownList(info).stream().map(fb -> {
            FlightSegment fs = new FlightSegment();
            fs.setFlightNumber(fb.getFareBasis().getCode());
            fs.setAirline((DictionaryReference)new AirlineReference(""));
            return fs;
        }).collect(Collectors.toList()));
        result.getSegmentTariffs().add(fst);
        return result;
    }

    private static /* synthetic */ void lambda$process$1(GdsTracingItemBuilder builder, String message, OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info) {
        builder.traceFlightLogic((BaseEntity)AirPriceRSAlternativePricingFlightsParser.createFakeFlight(info), MessageType.MESSAGE, message);
    }

    private static class Option {
        private final List<String> bookingClasses;
        private final List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo> infos;
        private final boolean smartPriceRequired;

        public Option(List<String> bookingClasses, List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo> infos, boolean smartPriceRequired) {
            this.bookingClasses = bookingClasses;
            this.infos = infos;
            this.smartPriceRequired = smartPriceRequired;
        }

        public List<String> getBookingClasses() {
            return this.bookingClasses;
        }

        public List<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo> getInfos() {
            return this.infos;
        }

        public boolean isSmartPriceRequired() {
            return this.smartPriceRequired;
        }
    }
}

