/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlightFares.AirPriceRSAlternativePricingFlightsParser;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibx.JiBXHelper;
import com.gridnine.xtrip.server.model.test.ProcessorTestBase;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

public class AirPriceRSAlternativePricingFlightsParserTest
extends ProcessorTestBase {
    private AirPriceRSAlternativePricingFlightsParser processor;

    public void setUp() throws Exception {
        super.setUp();
        this.processor = new AirPriceRSAlternativePricingFlightsParser();
    }

    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        metaRegistry.register(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/model/model-profile.xml")));
    }

    @Test
    public void test() throws Exception {
        Flight flight = (Flight)this.loadXSerializable("AirPriceRSAlternativePricingFlightsParserTest-FLIGHT.xml", Flight.class);
        OTAAirPriceRS response = (OTAAirPriceRS)JiBXHelper.read(OTAAirPriceRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("AirPriceRSAlternativePricingFlightsParserTest-OTA_AirPriceRS.xml"));
        EntityContainer gdsAccountCtr = EntityContainer.create((BaseEntity)new SabreGdsAccount());
        ((SabreGdsAccount)gdsAccountCtr.getEntity()).setEnableSmartPricePricing(true);
        List ad = IntStream.range(0, 2).mapToObj(i -> new HashMap()).collect(Collectors.toList());
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD, (Object)response);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)gdsAccountCtr);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.AVAILABILITY_DATA, ad);
        ctx.putObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE, Collections.emptyMap());
        ctx.putObject((Enum)IBusGdsContextKeys.CORPORATE_IDS_BY_AIRLINE, Collections.emptyMap());
        this.processor.process(ctx);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)23L, (long)flights.size());
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "TK50BALA", "TK50BALA", "TK50BALA/CH25", "TK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "VK50BALA", "VK50BALA", "VK50BALA/CH25", "VK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "VK50BBSA", "VK50BBSA", "VK50BBSA/CH25", "VK50BBSA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "TK50BDFA", "TK50BDFA", "TK50BDFA/CH25", "TK50BDFA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "SK50BALA", "SK50BALA", "SK50BALA/CH25", "SK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "SK50BBSA", "SK50BBSA", "SK50BBSA/CH25", "SK50BBSA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "VK50BDFA", "VK50BDFA", "VK50BDFA/CH25", "VK50BDFA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "RK50BALA", "RK50BALA", "RK50BALA/CH25", "RK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "RK50BBSA", "RK50BBSA", "RK50BBSA/CH25", "RK50BBSA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "SK50BDFA", "SK50BDFA", "SK50BDFA/CH25", "SK50BDFA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "NK50BALA", "NK50BALA", "NK50BALA/CH25", "NK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "NK50BBSA", "NK50BBSA", "NK50BBSA/CH25", "NK50BBSA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "YB", "TK50BALA", "YB/CH50", "TK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "NK50BDFA", "NK50BDFA", "NK50BALA/CH25", "NK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "YB", "VK50BALA", "YB/CH50", "VK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "YB", "TK50BDFA", "YB/CH50", "TK50BDFA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "SOWBJ", "TK50BALA", "SOWBJ/CH50", "TK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "YB", "SK50BALA", "YB/CH50", "SK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "YB", "SK50BBSA", "YB/CH50", "SK50BBSA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "VOWBJ", "VK50BALA", "VOWBJ/CH50", "VK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "YB", "VK50BDFA", "YB/CH50", "VK50BDFA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "BOWBJ", "TK50BALA", "BOWBJ/CH50", "TK50BALA/CH25");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombination(flights, "BOWBJ", "TK50BDFA", "BOWBJ/CH50", "TK50BDFA/CH25");
    }

    private static void assertHasCombination(Collection<Flight> flights, String fareBasisAdtSeg0, String fareBasisAdtSeg1, String fareBasisCnnSeg0, String fareBasisCnnSeg1) {
        Assert.assertTrue((String)String.format("combination ADT: %s-%s, CNN: %s-%s not found", fareBasisAdtSeg0, fareBasisAdtSeg1, fareBasisCnnSeg0, fareBasisCnnSeg1), (boolean)flights.stream().map(FlightHelper::getSegments).filter(segs -> AirPriceRSAlternativePricingFlightsParserTest.getFareInfo(((FlightSegment)segs.get(0)).getFareInfos(), (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType()).getFareBasis().equals(fareBasisAdtSeg0)).filter(segs -> AirPriceRSAlternativePricingFlightsParserTest.getFareInfo(((FlightSegment)segs.get(1)).getFareInfos(), (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType()).getFareBasis().equals(fareBasisAdtSeg1)).filter(segs -> AirPriceRSAlternativePricingFlightsParserTest.getFareInfo(((FlightSegment)segs.get(0)).getFareInfos(), (DictionaryReference<PassengerType>)DictHelper.getChildPassengerType()).getFareBasis().equals(fareBasisCnnSeg0)).filter(segs -> AirPriceRSAlternativePricingFlightsParserTest.getFareInfo(((FlightSegment)segs.get(1)).getFareInfos(), (DictionaryReference<PassengerType>)DictHelper.getChildPassengerType()).getFareBasis().equals(fareBasisCnnSeg1)).findAny().isPresent());
    }

    private static FareInfo getFareInfo(Collection<FareInfo> fareInfos, DictionaryReference<PassengerType> passengerType) {
        return (FareInfo)Streams.single(fareInfos.stream().filter(fi -> fi.getPassengerType().equals((Object)passengerType)));
    }

    @Test
    public void testVip54788() throws Exception {
        Flight flight = (Flight)this.loadXSerializable("AirPriceRSAlternativePricingFlightsParserTest-testVip54778-FLIGHT.xml", Flight.class);
        OTAAirPriceRS response = (OTAAirPriceRS)JiBXHelper.read(OTAAirPriceRS.class, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("AirPriceRSAlternativePricingFlightsParserTest-testVip54778-OTA_AirPriceRS.xml"));
        EntityContainer gdsAccountCtr = EntityContainer.create((BaseEntity)new SabreGdsAccount());
        ((SabreGdsAccount)gdsAccountCtr.getEntity()).setEnableSmartPricePricing(true);
        List ad = IntStream.range(0, 2).mapToObj(i -> new HashMap()).collect(Collectors.toList());
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD, (Object)response);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)gdsAccountCtr);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.AVAILABILITY_DATA, ad);
        ctx.putObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE, Collections.emptyMap());
        ctx.putObject((Enum)IBusGdsContextKeys.CORPORATE_IDS_BY_AIRLINE, Collections.emptyMap());
        this.processor.process(ctx);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertEquals((long)15L, (long)flights.size());
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "ULXOWRUTO");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "HLXOWRUTO");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "VLXOWRUTO");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "LLXOWRUTO");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "KLXOWRUTO");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "MLXOWRUTO");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "BLXOWRUTO");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "SXOWRU");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "GXOWRU");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "YXOWRU");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "DEYA0WRU");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "JFFF0WRU");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "CFFF0WRU");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "YIFOW");
        AirPriceRSAlternativePricingFlightsParserTest.assertHasCombinationVip54788(flights, "CIFOW");
    }

    private static void assertHasCombinationVip54788(Collection<Flight> flights, String fareBasis) {
        Assert.assertTrue((String)String.format("combination %s not found", fareBasis), (boolean)flights.stream().map(FlightHelper::getSegments).filter(segs -> AirPriceRSAlternativePricingFlightsParserTest.getFareInfo(((FlightSegment)segs.get(0)).getFareInfos(), (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType()).getFareBasis().equals(fareBasis)).findAny().isPresent());
    }
}

