/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirPriceRS;
import java.util.Collection;
import java.util.Iterator;

public class BrandedFaresAirPriceRSAlternativePricingPenalties
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight theFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        OTAAirPriceRS response = (OTAAirPriceRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        for (Flight flight : flights) {
            block1: for (OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo info : response.getPriceQuote().getPricedItinerary().getAirItineraryPricingInfoList()) {
                if (info.getSpecificPenaltyList() == null || info.getSpecificPenaltyList().isEmpty()) continue;
                DictionaryReference passengerType = SabreHelper.resolveNativeCode(PassengerType.class, (String)info.getPassengerTypeQuantity().getCode());
                Iterator<OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown> ptcFBIter = AirPriceHelper.getValidPTCFareBreakdownList(info).iterator();
                for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
                    OTAAirPriceRS.PriceQuote.PricedItinerary.AirItineraryPricingInfo.PTCFareBreakdown ptcFB = ptcFBIter.next();
                    FareInfo fareInfo = fs.getFareInfos().stream().filter(fi -> fi.getPassengerType().equals((Object)passengerType)).findAny().get();
                    if (fareInfo.getFareBasis().equals(ptcFB.getFareBasis().getCode())) continue;
                    continue block1;
                }
                flight.getPenaltiesInfos().put(passengerType, AirPriceHelper.parsePenaltiesInfo(info));
            }
        }
        if (!theFlight.getPenaltiesInfos().containsKey(DictHelper.getAdultPassengerType())) {
            // empty if block
        }
    }
}

