/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirAvailRQ;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;

public class FlightSegmentAirAvailRQBuilder
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"MM-dd");
    private boolean useOperatingAirlineData;

    public void configure(Map<String, String> parameters) {
        this.useOperatingAirlineData = Boolean.parseBoolean(parameters.get("useOperatingAirlineData"));
    }

    public void process(MessageContext ctx) throws Exception {
        FlightSegment flightSegment = (FlightSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENT);
        OTAAirAvailRQ request = new OTAAirAvailRQ();
        request.setVersion("2.4.0");
        request.setReturnHostCommand(Boolean.TRUE);
        OTAAirAvailRQ.OriginDestinationInformation odi = new OTAAirAvailRQ.OriginDestinationInformation();
        odi.setFlightSegmentOriginLocation(SabreHelper.getNativeCode((DictionaryReference)flightSegment.getLocationBegin()));
        odi.setFlightSegmentDestinationLocation(SabreHelper.getNativeCode((DictionaryReference)flightSegment.getLocationEnd()));
        odi.setFlightSegmentDepartureDateTime(DF.format(flightSegment.getDateBegin()));
        if (this.useOperatingAirlineData) {
            odi.setFlightSegmentFlightNumber(String.format("%04d", Integer.valueOf(flightSegment.getOperatingFlightNumber())));
        } else {
            odi.setFlightSegmentFlightNumber(String.format("%04d", Integer.valueOf(flightSegment.getFlightNumber())));
        }
        odi.setFlightSegmentResBookDesigCode("/");
        request.setOriginDestinationInformation(odi);
        OTAAirAvailRQ.OptionalQualifiers oq = new OTAAirAvailRQ.OptionalQualifiers();
        OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers fq = new OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers();
        OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs vp = new OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs();
        OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs.Airline a = new OTAAirAvailRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs.Airline();
        if (this.useOperatingAirlineData) {
            a.setCode(SabreHelper.getNativeCode((DictionaryReference)flightSegment.getOperatingAirline()));
        } else {
            a.setCode(SabreHelper.getNativeCode((DictionaryReference)flightSegment.getAirline()));
        }
        vp.getAirlineList().add(a);
        fq.setVendorPrefs(vp);
        oq.setFlightQualifiers(fq);
        request.setOptionalQualifiers(oq);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirAvailLLSRQ");
    }
}

