/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RemoveDuplicatesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        List duplicates = flights.stream().collect(Collectors.groupingBy(RemoveDuplicatesProcessor::getBrandIds)).values().stream().filter(group -> group.size() > 1).flatMap(group -> group.stream().skip(1L)).collect(Collectors.toList());
        flights.removeAll(duplicates);
    }

    private static Map<DictionaryReference<PassengerType>, List<String>> getBrandIds(Flight flight) {
        HashMap<DictionaryReference<PassengerType>, List<String>> result = new HashMap<DictionaryReference<PassengerType>, List<String>>();
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            for (FareInfo fi : fs.getFareInfos()) {
                List brandIds = result.computeIfAbsent((DictionaryReference<PassengerType>)fi.getPassengerType(), k -> new ArrayList());
                brandIds.add(Optional.ofNullable(fi.getFareDetails()).map(FareDetails::getPricingParameters).map(FarePricingParameters::getBrandId).orElse(null));
            }
        }
        return result;
    }
}

