/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.sabre.bfm.AirSearchPrefsType;
import com.gridnine.sabre.bfm.AirlineType;
import com.gridnine.sabre.bfm.BaggageRequestType;
import com.gridnine.sabre.bfm.BrandedFareIndicatorsBase;
import com.gridnine.sabre.bfm.CodeListAirGroup;
import com.gridnine.sabre.bfm.CodeListGroup;
import com.gridnine.sabre.bfm.CurrentOriginDestinationFlightExchangeAttributeGroup;
import com.gridnine.sabre.bfm.OTAAirLowFareSearchRQ;
import com.gridnine.sabre.bfm.OTAPayloadStdAttributes;
import com.gridnine.sabre.bfm.OriginDestinationFlightAttributeGroup;
import com.gridnine.sabre.bfm.OriginDestinationFlightGroup;
import com.gridnine.sabre.bfm.OriginDestinationFlightType;
import com.gridnine.sabre.bfm.PassengerInfoType;
import com.gridnine.sabre.bfm.PassengerTypeQuantityType;
import com.gridnine.sabre.bfm.PriceRequestInformationType;
import com.gridnine.sabre.bfm.RequestLocationType;
import com.gridnine.sabre.bfm.RequestSpecifiedLocationType;
import com.gridnine.sabre.bfm.TravelerInfoSummaryType;
import com.gridnine.sabre.bfm.TravelerInformationType;
import com.gridnine.sabre.bfm.VerificationItinCallLogicType;
import com.gridnine.sabre.bfm.VoluntaryChangesSMPType;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.OTAAirLowFareSearchRQHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class RevalidateItineraryRequestBuilder
extends BaseProcessor {
    private static final FastDateFormat DF_SEGMENT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss");
    private boolean itinParityMode;

    public void configure(Map<String, String> parameters) {
        this.itinParityMode = Boolean.parseBoolean(parameters.get("itin-parity-mode"));
    }

    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        SabreSession session = (SabreSession)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        Collection accountCodes = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES);
        Collection corporateIds = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.CORPORATE_IDS);
        OTAAirLowFareSearchRQ request = this.buildRequest(flight, gdsParameters, session, accountCodes, corporateIds);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"RevalidateItinRQ");
    }

    OTAAirLowFareSearchRQ buildRequest(Flight flight, GDSParameters gdsParameters, SabreSession session, Collection<String> accountCodes, Collection<String> corporateIds) {
        OTAAirLowFareSearchRQ request = new OTAAirLowFareSearchRQ();
        OTAPayloadStdAttributes stdattr = new OTAPayloadStdAttributes();
        stdattr.setVersion("6.6.0");
        request.setOTAPayloadStdAttributes(stdattr);
        String pcc = PccHelper.getSearchPccCode((GDSParameters)gdsParameters);
        if (StringUtils.isBlank((String)pcc)) {
            pcc = session.getPcc();
        }
        request.setPOS(OTAAirLowFareSearchRQHelper.buildPos(pcc));
        request.getOriginDestinationInformationList().addAll(this.buildOriginDestinationInformation(flight));
        request.setTravelerInfoSummary(this.buildTravelInfoSummary(flight, accountCodes, corporateIds));
        request.setTravelPreferences(this.buildTravelPreferences());
        return request;
    }

    private AirSearchPrefsType buildTravelPreferences() {
        AirSearchPrefsType result = new AirSearchPrefsType();
        AirSearchPrefsType.TPAExtensions tpaExtensions = new AirSearchPrefsType.TPAExtensions();
        AirSearchPrefsType.TPAExtensions.VerificationItinCallLogic vicl = new AirSearchPrefsType.TPAExtensions.VerificationItinCallLogic();
        vicl.setValue(VerificationItinCallLogicType.L);
        tpaExtensions.setVerificationItinCallLogic(vicl);
        AirSearchPrefsType.Baggage baggage = new AirSearchPrefsType.Baggage();
        baggage.setRequestType(BaggageRequestType.A);
        baggage.setDescription(Boolean.valueOf(true));
        baggage.setCarryOnInfo(Boolean.valueOf(true));
        result.setBaggage(baggage);
        result.setTPAExtensions1(tpaExtensions);
        return result;
    }

    private TravelerInfoSummaryType buildTravelInfoSummary(Flight flight, Collection<String> accountCodes, Collection<String> corporateIds) {
        PriceRequestInformationType.Choice.AccountCode code;
        PriceRequestInformationType.Choice choice;
        TravelerInfoSummaryType result = new TravelerInfoSummaryType();
        TravelerInformationType info = new TravelerInformationType();
        for (SeatPreferences sp : flight.getSeats()) {
            PassengerInfoType ptq = new PassengerInfoType();
            ptq.setCode(SabreHelper.getNativeCode((DictionaryReference)sp.getPassengerType()));
            ptq.setQuantity(new BigInteger(Integer.toString(sp.getCount())));
            PassengerTypeQuantityType.TPAExtensions tpa = new PassengerTypeQuantityType.TPAExtensions();
            VoluntaryChangesSMPType vc = new VoluntaryChangesSMPType();
            vc.setMatch(VoluntaryChangesSMPType.Match.INFO);
            tpa.setVoluntaryChanges(vc);
            ptq.setTPAExtensions1(tpa);
            info.getPassengerTypeQuantityList().add(ptq);
        }
        result.getAirTravelerAvailList().add(info);
        PriceRequestInformationType priceRequestInfo = new PriceRequestInformationType();
        PriceRequestInformationType.TPAExtensions tpaExtensions = new PriceRequestInformationType.TPAExtensions();
        priceRequestInfo.setTPAExtensions1(tpaExtensions);
        PriceRequestInformationType.TPAExtensions.BrandedFareIndicators bfIndicators = new PriceRequestInformationType.TPAExtensions.BrandedFareIndicators();
        bfIndicators.setMultipleBrandedFares(Boolean.TRUE);
        if (this.itinParityMode) {
            bfIndicators.setParityMode(BrandedFareIndicatorsBase.ParityMode.ITIN);
        }
        tpaExtensions.setBrandedFareIndicators(bfIndicators);
        for (String accountCode : accountCodes) {
            choice = new PriceRequestInformationType.Choice();
            code = new PriceRequestInformationType.Choice.AccountCode();
            code.setCode(accountCode);
            choice.setAccountCode(code);
            priceRequestInfo.getChoiceList().add(choice);
        }
        for (String corporateId : corporateIds) {
            choice = new PriceRequestInformationType.Choice();
            code = new PriceRequestInformationType.Choice.NegotiatedFareCode();
            CodeListAirGroup codeListAirGroup = new CodeListAirGroup();
            CodeListGroup codeListGroup = new CodeListGroup();
            codeListGroup.setCode(corporateId);
            codeListAirGroup.setCodeListGroup(codeListGroup);
            code.setCodeListAirGroup(codeListAirGroup);
            choice.setNegotiatedFareCode((PriceRequestInformationType.Choice.NegotiatedFareCode)code);
            priceRequestInfo.getChoiceList().add(choice);
        }
        result.setPriceRequestInformation(priceRequestInfo);
        return result;
    }

    private Collection<? extends OTAAirLowFareSearchRQ.OriginDestinationInformation> buildOriginDestinationInformation(Flight flight) {
        ArrayList<OTAAirLowFareSearchRQ.OriginDestinationInformation> result = new ArrayList<OTAAirLowFareSearchRQ.OriginDestinationInformation>();
        List segments = FlightHelper.getSegments((Flight)flight);
        ArrayList segmentsByLegs = new ArrayList();
        ArrayList<FlightSegment> leg = null;
        for (FlightSegment flightSegment : segments) {
            if (flightSegment.isStarting()) {
                if (leg != null) {
                    segmentsByLegs.add(leg);
                }
                leg = new ArrayList<FlightSegment>();
            }
            leg.add(flightSegment);
        }
        segmentsByLegs.add(leg);
        int rph = 1;
        for (List list : segmentsByLegs) {
            OTAAirLowFareSearchRQ.OriginDestinationInformation odi = new OTAAirLowFareSearchRQ.OriginDestinationInformation();
            odi.setRPH(String.valueOf(rph++));
            odi.setDepartureDateTime(DF_SEGMENT.format(((FlightSegment)list.get(0)).getDateBegin()));
            RequestSpecifiedLocationType location = new RequestSpecifiedLocationType();
            RequestLocationType rlt = new RequestLocationType();
            rlt.setLocationCode(SabreHelper.getNativeCode((DictionaryReference)((FlightSegment)list.get(0)).getLocationBegin()));
            rlt.setString("");
            location.setRequestLocationType(rlt);
            odi.setOriginLocationRequestSpecifiedLocationType(location);
            location = new RequestSpecifiedLocationType();
            rlt = new RequestLocationType();
            rlt.setLocationCode(SabreHelper.getNativeCode((DictionaryReference)((FlightSegment)list.get(list.size() - 1)).getLocationEnd()));
            rlt.setString("");
            location.setRequestLocationType(rlt);
            odi.setDestinationLocationRequestSpecifiedLocationType(location);
            OTAAirLowFareSearchRQ.OriginDestinationInformation.TPAExtensions tpaExtensions = new OTAAirLowFareSearchRQ.OriginDestinationInformation.TPAExtensions();
            for (FlightSegment segment : list) {
                OriginDestinationFlightType odft = new OriginDestinationFlightType();
                OriginDestinationFlightGroup odfg = new OriginDestinationFlightGroup();
                RequestLocationType rlt2 = new RequestLocationType();
                rlt2.setLocationCode(SabreHelper.getNativeCode((DictionaryReference)segment.getLocationBegin()));
                rlt2.setString("");
                odfg.setOriginLocation(rlt2);
                RequestLocationType rlt3 = new RequestLocationType();
                rlt3.setLocationCode(SabreHelper.getNativeCode((DictionaryReference)segment.getLocationEnd()));
                rlt3.setString("");
                odfg.setDestinationLocation(rlt3);
                AirlineType airlineType = new AirlineType();
                airlineType.setMarketing(SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()));
                airlineType.setOperating(SabreHelper.getNativeCode((DictionaryReference)segment.getOperatingAirline()));
                odfg.setAirline(airlineType);
                odft.setOriginDestinationFlightGroup(odfg);
                CurrentOriginDestinationFlightExchangeAttributeGroup codfeag = new CurrentOriginDestinationFlightExchangeAttributeGroup();
                codfeag.setClassOfService(segment.getBookingClass());
                odft.setCurrentOriginDestinationFlightExchangeAttributeGroup(codfeag);
                OriginDestinationFlightAttributeGroup odfag = new OriginDestinationFlightAttributeGroup();
                odfag.setType("A");
                odfag.setNumber((short)Integer.parseInt(segment.getFlightNumber()));
                odfag.setDepartureDateTime(DF_SEGMENT.format(segment.getDateBegin()));
                odfag.setArrivalDateTime(DF_SEGMENT.format(segment.getDateEnd()));
                odft.setOriginDestinationFlightAttributeGroup(odfag);
                tpaExtensions.getFlightList().add(odft);
            }
            odi.setTPAExtensions1(tpaExtensions);
            result.add(odi);
        }
        return result;
    }
}

