/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlightFares;

import com.gridnine.sabre.bfm.AirItineraryPricingInfoType;
import com.gridnine.sabre.bfm.BookFlightSegmentType;
import com.gridnine.sabre.bfm.FareType;
import com.gridnine.sabre.bfm.OTAAirLowFareSearchRS;
import com.gridnine.sabre.bfm.OriginDestinationOptionType;
import com.gridnine.sabre.bfm.PTCFareBreakdownType;
import com.gridnine.sabre.bfm.PricedItineraryType;
import com.gridnine.sabre.bfm.ResponseEquipmentType;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MealServiceIndicator;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.OTAAirLowFareSearchRSParsingHelper;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class RevalidateItineraryResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        OTAAirLowFareSearchRS response = (OTAAirLowFareSearchRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Map accountCodes = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE);
        Map corporateIds = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CORPORATE_IDS_BY_AIRLINE);
        ArrayList<Flight> flights = (ArrayList<Flight>)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (flights == null) {
            flights = new ArrayList<Flight>();
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
        }
        flights.addAll(this.parseResponse(flight, response, accountCodes, corporateIds));
    }

    private List<Flight> parseResponse(Flight originalFlight, OTAAirLowFareSearchRS response, Map<DictionaryReference<Airline>, Collection<String>> accountCodes, Map<DictionaryReference<Airline>, Collection<String>> corporateIds) throws Exception {
        Flight lowestFareFlight;
        ArrayList<Flight> flights = new ArrayList<Flight>();
        PricedItineraryType pricedItinerary = (PricedItineraryType)response.getPricedItineraries().getPricedItineraryList().get(0);
        PricedItineraryType.AirItineraryPricingInfo airItineraryPricingInfo = (PricedItineraryType.AirItineraryPricingInfo)pricedItinerary.getAirItineraryPricingInfoList().get(0);
        boolean lowestFareReturned = Boolean.TRUE.equals(airItineraryPricingInfo.getFareSourceAndTypeAttributes().getFareReturned());
        List<String> passengerTypeCodes = originalFlight.getSeats().stream().map(sp -> SabreHelper.getNativeCode((DictionaryReference)sp.getPassengerType())).collect(Collectors.toList());
        if (lowestFareReturned) {
            List fareBreakDowns = airItineraryPricingInfo.getPTCFareBreakdowns1().getPTCFareBreakdownList();
            String fareCalcLine = ((PTCFareBreakdownType)fareBreakDowns.get(0)).getTPAExtensions1().getFareCalcLine().getInfo();
            lowestFareFlight = this.parseLowestFareFlight(pricedItinerary, (AirItineraryPricingInfoType)airItineraryPricingInfo, originalFlight.getGds(), fareCalcLine, passengerTypeCodes, accountCodes, corporateIds);
        } else {
            lowestFareFlight = this.parseLowestFareFlight(pricedItinerary, null, originalFlight.getGds(), null, passengerTypeCodes, accountCodes, corporateIds);
        }
        lowestFareFlight.setSeatsMapAvailable(originalFlight.isSeatsMapAvailable());
        lowestFareFlight.setAncillaryFeesRequestNeeded(originalFlight.isAncillaryFeesRequestNeeded());
        if (lowestFareReturned) {
            flights.add(lowestFareFlight);
        }
        List additionalFaresList = ((PricedItineraryType)response.getPricedItineraries().getPricedItineraryList().get(0)).getTPAExtensions1().getAdditionalFareList().stream().filter(af -> af.getAirItineraryPricingInfo() != null && af.getAirItineraryPricingInfo().getPTCFareBreakdowns1() != null).collect(Collectors.toList());
        for (PricedItineraryType.TPAExtensions.AdditionalFares additionalFares : additionalFaresList) {
            Object fareInfo2;
            PricedItineraryType.TPAExtensions.AdditionalFares.AirItineraryPricingInfo aipi = additionalFares.getAirItineraryPricingInfo();
            Flight flight = FlightHelper.cloneFlightItin((Flight)lowestFareFlight);
            flight.setSalesOriginContent(SalesOriginContent.SABRE);
            flight.setSalesOriginProvider(SalesOriginProvider.SABRE);
            flight.getSeats().addAll(lowestFareFlight.getSeats());
            List segments = FlightHelper.getSegments((Flight)flight);
            flight.getSegmentTariffs().clear();
            List fareBreakDowns = aipi.getPTCFareBreakdowns1().getPTCFareBreakdownList();
            String calcLine = ((PTCFareBreakdownType)fareBreakDowns.get(0)).getTPAExtensions1().getFareCalcLine().getInfo();
            Iterator segmentsIterator = segments.iterator();
            for (Object fareInfo2 : aipi.getFareInfos().getFareInfoList()) {
                FlightSegment segment = (FlightSegment)segmentsIterator.next();
                segment.setBookingClass(fareInfo2.getFareReference());
                segment.setAvailableSeats(fareInfo2.getTPAExtensions().getSeatsRemaining().getNumber());
                segment.setServiceClass(SabreHelper.cabin2ClassOfService((String)fareInfo2.getTPAExtensions().getCabin().getCabin()));
            }
            Iterator<String> passengerTypeCodesIterator = passengerTypeCodes.iterator();
            fareInfo2 = fareBreakDowns.iterator();
            while (fareInfo2.hasNext()) {
                String value;
                PTCFareBreakdownType fareBreakDown = (PTCFareBreakdownType)fareInfo2.next();
                if (flight.getGdsCurrencyCode() == null) {
                    flight.setGdsCurrencyCode(fareBreakDown.getPassengerFare().getTotalFareCurrencyAmountType().getCurrencyCodeGroup().getCurrencyCode());
                }
                if (SabreServerHelper.isAccountCode(value = OTAAirLowFareSearchRSParsingHelper.getAccountCode(fareBreakDown.getFareBasisCodeList()), accountCodes, corporateIds, (DictionaryReference<Airline>)flight.getCarrier())) {
                    flight.setAccountCode(value);
                } else {
                    flight.setCorporateId(value);
                }
                if (!StringUtils.isBlank((String)value)) {
                    if (flight.getTripartiteContractDetails() == null) {
                        flight.setTripartiteContractDetails(new TripartiteContractDetails());
                    }
                    flight.getTripartiteContractDetails().setIssuedUnder3d(true);
                }
                flight.setAccountCodeApplied(true);
                flight.setCorporateIdApplied(true);
                String passengerTypeCode = passengerTypeCodesIterator.next();
                DictionaryReference passengerType = SabreHelper.resolveNativeCode(PassengerType.class, (String)passengerTypeCode);
                flight.getPrivateFare().put(passengerType, fareBreakDown.getPrivateFareType() != null);
                FlightFare fare = OTAAirLowFareSearchRSParsingHelper.createFlightFare(fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
                flight.getFares().add(fare);
                if (fareBreakDown.getPassengerFare().getTaxes() != null) {
                    OTAAirLowFareSearchRSParsingHelper.processTaxes(flight, fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
                }
                if (fareBreakDown.getPassengerFare().getOBFees1() != null) {
                    OTAAirLowFareSearchRSParsingHelper.processOBFees(flight, fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
                }
                Iterator fareBasisCodeIter = fareBreakDown.getFareBasisCodeList().iterator();
                Map<Integer, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>> luggageInfos = OTAAirLowFareSearchRSParsingHelper.getLuggageInfos(fareBreakDown);
                Map<Integer, ExtendedLuggageInfo> cabinLuggageInfos = OTAAirLowFareSearchRSParsingHelper.getCabinLuggageInfos(fareBreakDown);
                ArrayList segByLegs = new ArrayList();
                ArrayList<FlightSegment> leg = null;
                for (FlightSegment segment : segments) {
                    if (segment.isStarting()) {
                        if (leg != null) {
                            segByLegs.add(leg);
                        }
                        leg = new ArrayList<FlightSegment>();
                    }
                    assert (leg != null);
                    leg.add(segment);
                }
                segByLegs.add(leg);
                int segIdx = 0;
                for (int i = 0; i < segByLegs.size(); ++i) {
                    List lfs = (List)segByLegs.get(i);
                    for (int j = 0; j < lfs.size(); ++j) {
                        FlightSegment fs = (FlightSegment)lfs.get(j);
                        PTCFareBreakdownType.FareBasisCode fareBasisCode = (PTCFareBreakdownType.FareBasisCode)fareBasisCodeIter.next();
                        FareInfo fareInfo3 = OTAAirLowFareSearchRSParsingHelper.createFareInfo(passengerTypeCode, (DictionaryReference<PassengerType>)passengerType, fs.getGdsId(), i, j, luggageInfos.get(segIdx), cabinLuggageInfos.get(segIdx), fareBasisCode, Optional.ofNullable(fareBreakDown.getPassengerFare().getTPAExtensions1()).map(FareType.TPAExtensions::getFareComponents).orElse(null));
                        SabreCustomPropertiesHelper.setFareComponentDirectionality(fareInfo3, fareBasisCode.getFareComponentDirectionality() != null ? fareBasisCode.getFareComponentDirectionality().name() : null);
                        fs.getFareInfos().add(fareInfo3);
                        ++segIdx;
                    }
                }
                flight.getPenaltiesInfos().put(passengerType, OTAAirLowFareSearchRSParsingHelper.parsePenaltiesInfo(fareBreakDown));
            }
            try {
                flight.getSegmentTariffs().addAll(GDSHelper.tryBuildFlightSegmentTariffs((List)segments, (String)calcLine));
            }
            catch (Exception ex) {
                FlightSegmentTariff fst = new FlightSegmentTariff();
                fst.setGds(flight.getGds());
                fst.getSegments().addAll(segments);
                flight.getSegmentTariffs().add(fst);
            }
            flight.setSeatsMapAvailable(originalFlight.isSeatsMapAvailable());
            flight.setAncillaryFeesRequestNeeded(originalFlight.isAncillaryFeesRequestNeeded());
            flights.add(flight);
        }
        return flights;
    }

    private Flight parseLowestFareFlight(PricedItineraryType pricedItinerary, AirItineraryPricingInfoType airItineraryPricingInfo, GdsName gds, String calcLine, List<String> passengerTypeCodes, Map<DictionaryReference<Airline>, Collection<String>> accountCodes, Map<DictionaryReference<Airline>, Collection<String>> corporateIds) throws Exception {
        String lastTicketingDateString;
        Flight flight = new Flight();
        flight.setSalesOriginContent(SalesOriginContent.SABRE);
        flight.setSalesOriginProvider(SalesOriginProvider.SABRE);
        flight.setNeedToApplyPublicFareDiscount(true);
        flight.setGds(gds);
        flight.setLatinRegistration(true);
        SabreCustomPropertiesHelper.setDirectionInd(flight, pricedItinerary.getAirItinerary().getDirectionInd().toString());
        if (airItineraryPricingInfo != null && (lastTicketingDateString = airItineraryPricingInfo.getLastTicketDate()) != null) {
            flight.setPqTimeLimit(Date.from(LocalDate.parse(lastTicketingDateString, OTAAirLowFareSearchRSParsingHelper.DF).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        String carrierCode = pricedItinerary.getTPAExtensions1().getValidatingCarrier().getCode();
        flight.setCarrier(SabreHelper.resolveNativeCode(Airline.class, (String)carrierCode));
        flight.setEticket(OTAAirLowFareSearchRSParsingHelper.isETicket(pricedItinerary));
        ArrayList segByLegs = new ArrayList();
        ArrayList<FlightSegment> leg = null;
        Iterator fareInfoIter = null;
        if (airItineraryPricingInfo != null) {
            fareInfoIter = airItineraryPricingInfo.getFareInfos().getFareInfoList().iterator();
        }
        int gdsId = 1;
        String lastSegArrival = null;
        for (OriginDestinationOptionType odo : pricedItinerary.getAirItinerary().getOriginDestinationOptions().getOriginDestinationOptionList()) {
            boolean isStarting = true;
            for (BookFlightSegmentType sabreFs : odo.getFlightSegmentList()) {
                DictionaryReference<Airline> airlineRef;
                if (lastSegArrival != null && !lastSegArrival.equals(sabreFs.getDepartureAirport().getResponseLocationType().getLocationCode())) {
                    ++gdsId;
                }
                FlightSegment fs = new FlightSegment();
                fs.setGds(gds);
                if (fareInfoIter != null) {
                    Set items;
                    AirItineraryPricingInfoType.FareInfos.FareInfo fareInfo = (AirItineraryPricingInfoType.FareInfos.FareInfo)fareInfoIter.next();
                    fs.setAvailableSeats(fareInfo.getTPAExtensions().getSeatsRemaining().getNumber());
                    if (fareInfo.getTPAExtensions().getMeal() != null && !StringUtils.isBlank((String)fareInfo.getTPAExtensions().getMeal().getCode()) && !(items = DictHelper.getDictionaryItemsByCode(MealServiceIndicator.class, (String)fareInfo.getTPAExtensions().getMeal().getCode())).isEmpty()) {
                        fs.setMealServiceIndicator((DictionaryReference)((MealServiceIndicator)items.iterator().next()).toReference());
                    }
                    fs.setServiceClass(SabreHelper.cabin2ClassOfService((String)fareInfo.getTPAExtensions().getCabin().getCabin()));
                }
                if (isStarting) {
                    if (leg != null) {
                        segByLegs.add(leg);
                    }
                    leg = new ArrayList<FlightSegment>();
                    fs.setStarting(true);
                    isStarting = false;
                }
                fs.setLocationBegin(SabreHelper.resolveNativeCode(GeoLocation.class, (String)sabreFs.getDepartureAirport().getResponseLocationType().getLocationCode()));
                fs.setTerminalBegin(sabreFs.getDepartureAirport().getTerminalID());
                fs.setLocationEnd(SabreHelper.resolveNativeCode(GeoLocation.class, (String)sabreFs.getArrivalAirport().getResponseLocationType().getLocationCode()));
                fs.setTerminalEnd(sabreFs.getArrivalAirport().getTerminalID());
                fs.setDateBegin(Date.from(LocalDateTime.parse(sabreFs.getDepartureDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF).atZone(ZoneId.systemDefault()).toInstant()));
                fs.setDateEnd(Date.from(LocalDateTime.parse(sabreFs.getArrivalDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF).atZone(ZoneId.systemDefault()).toInstant()));
                fs.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)sabreFs.getMarketingAirline().getCompanyIDAttributesGroup().getCode()));
                String code = sabreFs.getOperatingAirline().getCompanyNameType().getCompanyIDAttributesGroup().getCode();
                String operatingAirlineCompanyShortName = sabreFs.getOperatingAirline().getCompanyNameType().getCompanyIDAttributesGroup().getCompanyShortName();
                if ("**".equals(code)) {
                    String string = sabreFs.getDisclosureAirline().getString();
                    String spellVariant = SabreServerHelper.getSpellVariantFrom(string);
                    airlineRef = SabreServerHelper.findOrCreateAirlineBySpellVariant(spellVariant);
                } else {
                    airlineRef = SabreHelper.resolveNativeCode(Airline.class, (String)code);
                }
                fs.setOperatingAirline((DictionaryReference)airlineRef);
                fs.setOperatingAirlineCompanyShortName(operatingAirlineCompanyShortName);
                if (fs.getOperatingAirline() == null) {
                    fs.setOperatingAirline(fs.getAirline());
                }
                fs.setFlightNumber(sabreFs.getFlightNumber().replaceAll("^0+", ""));
                fs.setOperatingFlightNumber(sabreFs.getOperatingAirline().getFlightNumber());
                fs.setBoard(SabreHelper.resolveNativeCode(Aircraft.class, (String)((ResponseEquipmentType)sabreFs.getEquipmentList().get(0)).getEquipmentType().getAirEquipType()));
                fs.setStops(sabreFs.getStopQuantity().intValue());
                SabreCustomPropertiesHelper.setMarriageGrp(fs, sabreFs.getMarriageGrp());
                fs.setTravelDuration(sabreFs.getElapsedTime() == null ? OTAAirLowFareSearchRSParsingHelper.getTravelDuration(fs) : sabreFs.getElapsedTime().intValue());
                fs.setBookingClass(sabreFs.getResBookDesigCode());
                fs.setSubjectToGovernmentApproval(sabreFs.getTPAExtensions1().getDataElement() != null && BooleanUtil.nullAsFalse((Boolean)sabreFs.getTPAExtensions1().getDataElement().getSubjectToGovernmentApproval()));
                if (sabreFs.getStopQuantity().intValue() > 0) {
                    for (BookFlightSegmentType.StopAirports.StopAirport stopAirport : sabreFs.getStopAirports().getStopAirportList()) {
                        TechStopInfo techStop = new TechStopInfo();
                        techStop.setArrivalDateTime(LocalDateTime.parse(stopAirport.getArrivalDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF));
                        techStop.setDepartureDateTime(LocalDateTime.parse(stopAirport.getDepartureDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF));
                        techStop.setDuration(stopAirport.getDuration().intValue());
                        techStop.setLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)stopAirport.getResponseLocationType().getLocationCode()));
                        fs.getTechStopInfos().add(techStop);
                    }
                }
                fs.setGdsId(Integer.toString(gdsId));
                lastSegArrival = sabreFs.getArrivalAirport().getResponseLocationType().getLocationCode();
                ++gdsId;
                leg.add(fs);
            }
        }
        segByLegs.add(leg);
        List segments = segByLegs.stream().flatMap(Collection::stream).collect(Collectors.toList());
        Iterator<String> passengerTypeCodesIterator = passengerTypeCodes.iterator();
        if (airItineraryPricingInfo != null) {
            for (PTCFareBreakdownType fareBreakDown : airItineraryPricingInfo.getPTCFareBreakdowns1().getPTCFareBreakdownList()) {
                String value;
                if (flight.getGdsCurrencyCode() == null) {
                    flight.setGdsCurrencyCode(fareBreakDown.getPassengerFare().getTotalFareCurrencyAmountType().getCurrencyCodeGroup().getCurrencyCode());
                }
                if (SabreServerHelper.isAccountCode(value = OTAAirLowFareSearchRSParsingHelper.getAccountCode(fareBreakDown.getFareBasisCodeList()), accountCodes, corporateIds, (DictionaryReference<Airline>)flight.getCarrier())) {
                    flight.setAccountCode(value);
                } else {
                    flight.setCorporateId(value);
                }
                if (!StringUtils.isBlank((String)value)) {
                    if (flight.getTripartiteContractDetails() == null) {
                        flight.setTripartiteContractDetails(new TripartiteContractDetails());
                    }
                    flight.getTripartiteContractDetails().setIssuedUnder3d(true);
                }
                flight.setAccountCodeApplied(true);
                flight.setCorporateIdApplied(true);
                String passengerTypeCode = passengerTypeCodesIterator.next();
                DictionaryReference passengerType = SabreHelper.resolveNativeCode(PassengerType.class, (String)passengerTypeCode);
                flight.getPrivateFare().put(passengerType, fareBreakDown.getPrivateFareType() != null);
                SeatPreferences sp = new SeatPreferences();
                sp.setPassengerType(passengerType);
                sp.setCount(fareBreakDown.getPassengerTypeQuantity().getQuantity().intValue());
                flight.getSeats().add(sp);
                FlightFare fare = OTAAirLowFareSearchRSParsingHelper.createFlightFare(fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
                flight.getFares().add(fare);
                if (fareBreakDown.getPassengerFare().getTaxes() != null) {
                    OTAAirLowFareSearchRSParsingHelper.processTaxes(flight, fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
                }
                if (fareBreakDown.getPassengerFare().getOBFees1() != null) {
                    OTAAirLowFareSearchRSParsingHelper.processOBFees(flight, fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
                }
                Iterator fareBasisCodeIter = fareBreakDown.getFareBasisCodeList().iterator();
                Map<Integer, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>> luggageInfos = OTAAirLowFareSearchRSParsingHelper.getLuggageInfos(fareBreakDown);
                Map<Integer, ExtendedLuggageInfo> cabinLuggageInfos = OTAAirLowFareSearchRSParsingHelper.getCabinLuggageInfos(fareBreakDown);
                int segIdx = 0;
                for (int i = 0; i < segByLegs.size(); ++i) {
                    List lfs = (List)segByLegs.get(i);
                    for (int j = 0; j < lfs.size(); ++j) {
                        FlightSegment fs = (FlightSegment)lfs.get(j);
                        FareInfo fareInfo = OTAAirLowFareSearchRSParsingHelper.createFareInfo(passengerTypeCode, (DictionaryReference<PassengerType>)passengerType, fs.getGdsId(), i, j, luggageInfos.get(segIdx), cabinLuggageInfos.get(segIdx), (PTCFareBreakdownType.FareBasisCode)fareBasisCodeIter.next(), Optional.ofNullable(fareBreakDown.getPassengerFare().getTPAExtensions1()).map(FareType.TPAExtensions::getFareComponents).orElse(null));
                        fs.getFareInfos().add(fareInfo);
                        ++segIdx;
                    }
                }
                flight.getPenaltiesInfos().put(passengerType, OTAAirLowFareSearchRSParsingHelper.parsePenaltiesInfo(fareBreakDown));
            }
        }
        if (calcLine != null) {
            try {
                flight.getSegmentTariffs().addAll(GDSHelper.tryBuildFlightSegmentTariffs(segments, (String)calcLine));
            }
            catch (Exception ex) {
                IncidentsLog.reportException((String)("failed to parse calc line: " + calcLine), (Throwable)ex);
                FlightSegmentTariff fst = new FlightSegmentTariff();
                fst.setGds(gds);
                fst.getSegments().addAll(segments);
                flight.getSegmentTariffs().add(fst);
            }
        } else {
            FlightSegmentTariff fst = new FlightSegmentTariff();
            fst.setGds(gds);
            fst.getSegments().addAll(segments);
            flight.getSegmentTariffs().add(fst);
        }
        return flight;
    }
}

