/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.sabre.bfm.CabinType;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.CabinTypeAirlinesCombination;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CabinTypeAirlinesCombinationsProvider
extends BaseTargetsProvider<CabinTypeAirlinesCombination> {
    public Collection<CabinTypeAirlinesCombination> getTargets(MessageContext ctx) throws Exception {
        Collection airlines = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.APPLICABLE_AIRLINES);
        List cabinTypes = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_TYPES);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        boolean hasRouteSegmentAirline = fsp.getRoute().stream().anyMatch(rs -> rs.getFlightNumber() == null && rs.getAirline() != null);
        return this.getCabinTypeAirlinesCombinations(hasRouteSegmentAirline ? Collections.emptyList() : airlines, cabinTypes);
    }

    private Collection<CabinTypeAirlinesCombination> getCabinTypeAirlinesCombinations(Collection<DictionaryReference<Airline>> airlines, List<CabinType> cabinTypes) {
        ArrayList<CabinTypeAirlinesCombination> result = new ArrayList<CabinTypeAirlinesCombination>();
        for (CabinType cabinType : cabinTypes) {
            CabinTypeAirlinesCombination combination = new CabinTypeAirlinesCombination();
            combination.setCabinType(cabinType);
            combination.getAirlines().addAll(airlines);
            result.add(combination);
        }
        return result;
    }
}

