/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.sabre.bfm.CabinType;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.List;

public class ConvertClassOfServiceToCabinTypesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List<CabinType> cabinTypes;
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        switch (fsp.getServiceClass()) {
            case ECONOMY: {
                cabinTypes = Arrays.asList(CabinType.ECONOMY, CabinType.PREMIUM_ECONOMY);
                break;
            }
            case PREMIUM: {
                cabinTypes = Arrays.asList(CabinType.PREMIUM_ECONOMY);
                break;
            }
            case BUSINESS: {
                cabinTypes = Arrays.asList(CabinType.BUSINESS, CabinType.PREMIUM_BUSINESS);
                break;
            }
            case PREMIUM_BUSINESS: {
                cabinTypes = Arrays.asList(CabinType.PREMIUM_BUSINESS);
                break;
            }
            case FIRST: {
                cabinTypes = Arrays.asList(CabinType.FIRST, CabinType.PREMIUM_FIRST);
                break;
            }
            case PREMIUM_FIRST: {
                cabinTypes = Arrays.asList(CabinType.PREMIUM_FIRST);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"unexpected class of service {0}", (Object[])new Object[]{fsp.getServiceClass()});
            }
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.CABIN_TYPES, cabinTypes);
    }
}

