/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class EnsureFlightBookabilityProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        if (!fsp.isExcludeBaglessFares()) {
            return;
        }
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (((SabreGdsAccount)gdsAccountCtr.getEntity()).isEnableSmartPricePricing()) {
            flights.stream().filter(EnsureFlightBookabilityProcessor::isNonBranded).forEach(f -> f.setSabreSmartPricePricing(true));
        } else {
            boolean isSaveRulesTraces;
            GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
            GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
            boolean bl = isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
            if (isSaveRulesTraces) {
                flights.removeIf(flight -> {
                    boolean nonBranded = EnsureFlightBookabilityProcessor.isNonBranded(flight);
                    if (nonBranded) {
                        builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, "excluded flight as it requires Smart Pricing (ZZ) which is not enabled");
                    }
                    return nonBranded;
                });
            } else {
                flights.removeIf(EnsureFlightBookabilityProcessor::isNonBranded);
            }
        }
    }

    private static boolean isNonBranded(Flight flight) {
        return flight.getSegmentTariffs().stream().map(FlightSegmentTariff::getSegments).flatMap(Collection::stream).map(FlightSegment::getFareInfos).flatMap(Collection::stream).map(fi -> Optional.ofNullable(fi.getFareDetails()).map(FareDetails::getPricingParameters).map(FarePricingParameters::getBrandId).orElse(null)).anyMatch(Objects::isNull);
    }
}

