/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.rules.ConnectionTimeActionsSet;
import com.gridnine.xtrip.common.gds.rules.ConnectionTimePropertiesSet;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.RouteSegmentWithFlightSegments;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;

public class GetMaxConnectionTimeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RouteSegmentWithFlightSegments rswfs = (RouteSegmentWithFlightSegments)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.ROUTE_SEGMENT_WITH_FLIGHT_SEGMENTS);
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean trace = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        Integer maxConnectionTime = this.getMaxConnectionTime(rswfs.getRouteSegment(), rules, trace);
        ctx.putObject((Enum)IBusGdsContextKeys.MAX_CONNECTION_TIME, (Object)maxConnectionTime);
    }

    private Integer getMaxConnectionTime(RouteSegment rs, RuleSet rules, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(Targets.CONNECTION_TIME_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new ConnectionTimePropertiesSet(rs.getLocationBegin(), rs.getLocationEnd()));
        proxy.setActionSet((Object)new ConnectionTimeActionsSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return ((ConnectionTimeActionsSet)proxy.getActionSet()).getMaxConnectionTimeInMinutes();
    }
}

