/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.sabre.bfm.BookFlightSegmentType;
import com.gridnine.sabre.bfm.OriginDestinationOptionType;
import com.gridnine.sabre.bfm.PricedItineraryType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.OTAAirLowFareSearchRSParsingHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class InvalidPricedItineraryFilter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection itins = (Collection)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PRICED_ITINERARIES);
        Iterator iter = itins.iterator();
        while (iter.hasNext()) {
            PricedItineraryType itin = (PricedItineraryType)iter.next();
            if (InvalidPricedItineraryFilter.checkSegmentDuplicates(itin)) continue;
            iter.remove();
        }
    }

    private static boolean checkSegmentDuplicates(PricedItineraryType itin) {
        HashSet<BookFlightSegmentTypeKey> segs = new HashSet<BookFlightSegmentTypeKey>();
        for (OriginDestinationOptionType odo : itin.getAirItinerary().getOriginDestinationOptions().getOriginDestinationOptionList()) {
            for (BookFlightSegmentType sabreFs : odo.getFlightSegmentList()) {
                if (segs.add(new BookFlightSegmentTypeKey(sabreFs))) continue;
                return false;
            }
        }
        return true;
    }

    static class BookFlightSegmentTypeKey {
        private final String marketingAirlineCode;
        private final LocalDate departureDate;
        private final String resBookDesigCode;
        private final String departureAirportCode;
        private final String arrivalAirportCode;

        BookFlightSegmentTypeKey(BookFlightSegmentType sabreFs) {
            this.marketingAirlineCode = sabreFs.getMarketingAirline().getCompanyIDAttributesGroup().getCode();
            this.departureDate = LocalDate.parse(sabreFs.getDepartureDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF);
            this.resBookDesigCode = sabreFs.getResBookDesigCode();
            this.departureAirportCode = sabreFs.getDepartureAirport().getResponseLocationType().getLocationCode();
            this.arrivalAirportCode = sabreFs.getArrivalAirport().getResponseLocationType().getLocationCode();
        }

        public int hashCode() {
            return MiscUtil.hash((Object[])new Object[]{this.marketingAirlineCode, this.departureDate, this.resBookDesigCode, this.departureAirportCode, this.arrivalAirportCode});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BookFlightSegmentTypeKey)) {
                return false;
            }
            BookFlightSegmentTypeKey that = (BookFlightSegmentTypeKey)obj;
            if (!MiscUtil.equals((Object)this.marketingAirlineCode, (Object)that.marketingAirlineCode)) {
                return false;
            }
            if (!MiscUtil.equals((Object)this.departureDate, (Object)that.departureDate)) {
                return false;
            }
            if (!MiscUtil.equals((Object)this.resBookDesigCode, (Object)that.resBookDesigCode)) {
                return false;
            }
            if (!MiscUtil.equals((Object)this.departureAirportCode, (Object)that.departureAirportCode)) {
                return false;
            }
            return MiscUtil.equals((Object)this.arrivalAirportCode, (Object)that.arrivalAirportCode);
        }
    }
}

