/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.sabre.bfm.BookFlightSegmentType;
import com.gridnine.sabre.bfm.ErrorType;
import com.gridnine.sabre.bfm.OTAAirLowFareSearchRS;
import com.gridnine.sabre.bfm.OriginDestinationOptionType;
import com.gridnine.sabre.bfm.PricedItineraryType;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MergeOTAAirLowFareSearchRSProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OTAAirLowFareSearchRS response;
        MessageContext subctx2;
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Map subctxs = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.OTA_AIR_LOW_FARE_SEARCH_MULTICALL_RESULT);
        HashMap<String, PricedItineraryType> itins = new HashMap<String, PricedItineraryType>();
        Iterator iterator = subctxs.values().iterator();
        while (iterator.hasNext()) {
            subctx2 = (MessageContext)iterator.next();
            response = (OTAAirLowFareSearchRS)subctx2.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
            if (response.getSequence() == null || response.getPricedItineraries() == null || response.getPricedItineraries().getPricedItineraryList() == null) continue;
            List pricedItineraryList = response.getPricedItineraries().getPricedItineraryList();
            if (fsp.getLimit() != null && pricedItineraryList.size() > fsp.getLimit()) {
                pricedItineraryList = pricedItineraryList.subList(0, fsp.getLimit());
            }
            for (PricedItineraryType newItin : pricedItineraryList) {
                String key = MergeOTAAirLowFareSearchRSProcessor.buildKey(newItin);
                if (itins.containsKey(key)) {
                    BigDecimal curPrice;
                    PricedItineraryType curItin = (PricedItineraryType)itins.get(key);
                    BigDecimal newPrice = MergeOTAAirLowFareSearchRSProcessor.getPrice(newItin);
                    if (newPrice.compareTo(curPrice = MergeOTAAirLowFareSearchRSProcessor.getPrice(curItin)) >= 0) continue;
                    itins.put(key, newItin);
                    continue;
                }
                itins.put(key, newItin);
            }
        }
        if (itins.isEmpty() && (iterator = subctxs.values().iterator()).hasNext()) {
            subctx2 = (MessageContext)iterator.next();
            response = (OTAAirLowFareSearchRS)subctx2.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
            if (response.getErrors() != null) {
                for (ErrorType error : response.getErrors().getErrorList()) {
                    ctx.addMessage(MessageHelper.createErrorMessage((String)(error.getFreeTextType().getString() + "; " + error.getErrorWarningAttributeGroup().getShortText()), (Object[])new Object[0]));
                }
            }
            throw Xeption.forAdmin((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0438\u0441\u043a\u0435 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{GdsName.SABRE});
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PRICED_ITINERARIES, itins.values());
        Map accountCodesByAirline = subctxs.values().stream().map(subctx -> (Map)subctx.getMandatoryObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE)).reduce(Collections.emptyMap(), MergeOTAAirLowFareSearchRSProcessor::mergeMultimaps);
        ctx.putObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE, (Object)accountCodesByAirline);
        Map corporateIdsByAirline = subctxs.values().stream().map(subctx -> (Map)subctx.getMandatoryObject((Enum)IBusGdsContextKeys.CORPORATE_IDS_BY_AIRLINE)).reduce(Collections.emptyMap(), MergeOTAAirLowFareSearchRSProcessor::mergeMultimaps);
        ctx.putObject((Enum)IBusGdsContextKeys.CORPORATE_IDS_BY_AIRLINE, (Object)corporateIdsByAirline);
    }

    private static <K, V> Map<K, Collection<V>> mergeMultimaps(Map<K, Collection<V>> m1, Map<K, Collection<V>> m2) {
        if (m1.isEmpty()) {
            return m2;
        }
        if (m2.isEmpty()) {
            return m1;
        }
        HashMap<K, Collection<Collection<V>>> result = new HashMap<K, Collection<Collection<V>>>(m1);
        for (Map.Entry<K, Collection<V>> e2 : m2.entrySet()) {
            if (result.containsKey(e2.getKey())) {
                ((Collection)result.get(e2.getKey())).addAll(e2.getValue());
                continue;
            }
            result.put(e2.getKey(), e2.getValue());
        }
        return result;
    }

    private static String buildKey(PricedItineraryType itin) {
        StringBuilder sb = new StringBuilder();
        for (OriginDestinationOptionType odo : itin.getAirItinerary().getOriginDestinationOptions().getOriginDestinationOptionList()) {
            for (BookFlightSegmentType fs : odo.getFlightSegmentList()) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(fs.getDepartureDateTime());
                sb.append(fs.getMarketingAirline().getCompanyIDAttributesGroup().getCode());
                sb.append(fs.getFlightNumber());
            }
        }
        return sb.toString();
    }

    private static BigDecimal getPrice(PricedItineraryType itin) {
        BigDecimal result = ((PricedItineraryType.AirItineraryPricingInfo)itin.getAirItineraryPricingInfoList().get(0)).getItinTotalFare().getTotalFareCurrencyAmountType().getAmount();
        if (itin.getTPAExtensions1() != null && itin.getTPAExtensions1().getAdditionalFareList() != null) {
            for (PricedItineraryType.TPAExtensions.AdditionalFares additionalFares : itin.getTPAExtensions1().getAdditionalFareList()) {
                BigDecimal newResult = additionalFares.getAirItineraryPricingInfo().getItinTotalFare().getTotalFareCurrencyAmountType().getAmount();
                if (newResult.compareTo(result) >= 0) continue;
                result = newResult;
            }
        }
        return result;
    }
}

