/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.sabre.bfm.AirItineraryPricingInfoType;
import com.gridnine.sabre.bfm.BookFlightSegmentType;
import com.gridnine.sabre.bfm.CarrierCountriesType;
import com.gridnine.sabre.bfm.FareType;
import com.gridnine.sabre.bfm.OriginDestinationOptionType;
import com.gridnine.sabre.bfm.PTCFareBreakdownType;
import com.gridnine.sabre.bfm.PricedItineraryType;
import com.gridnine.sabre.bfm.ResponseEquipmentType;
import com.gridnine.sabre.bfm.ValidatingCarrierInfoType;
import com.gridnine.xtrip.common.gds.exceptions.SearchFlightsDictException;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MealServiceIndicator;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.OTAAirLowFareSearchRSParsingHelper;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class OTAAirLowFareSearchFlightParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PricedItineraryType pricedItinerary = (PricedItineraryType)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PRICED_ITINERARY);
        String calcLine = this.getCalcLine(ctx);
        ArrayList<Flight> flights = (ArrayList<Flight>)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Map accountCodes = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE);
        Map corporateIds = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CORPORATE_IDS_BY_AIRLINE);
        if (flights == null) {
            flights = new ArrayList<Flight>();
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
        }
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        List<String> passengerTypeCodes = fsp.getSeats().stream().map(sp -> SabreHelper.getNativeCode((DictionaryReference)sp.getPassengerType())).collect(Collectors.toList());
        PricedItineraryType.AirItineraryPricingInfo airItineraryPricingInfo = (PricedItineraryType.AirItineraryPricingInfo)pricedItinerary.getAirItineraryPricingInfoList().get(0);
        Flight flight = this.parseFlight(pricedItinerary, (AirItineraryPricingInfoType)airItineraryPricingInfo, calcLine, passengerTypeCodes, accountCodes, corporateIds);
        if (flight.getCarrier() == null) {
            for (CarrierCountriesType alternate : ((ValidatingCarrierInfoType)CollectionUtil.single((Collection)airItineraryPricingInfo.getTPAExtensions1().getValidatingCarrierList())).getAlternateList()) {
                Flight clone = (Flight)XCloneHelper.clone((XCloneable)flight);
                clone.setCarrier(SabreHelper.resolveNativeCode(Airline.class, (String)alternate.getCode()));
                flights.add(clone);
            }
        } else {
            flights.add(flight);
        }
        if (pricedItinerary.getTPAExtensions1() != null && pricedItinerary.getTPAExtensions1().getAdditionalFareList() != null) {
            for (PricedItineraryType.TPAExtensions.AdditionalFares additionalFares : pricedItinerary.getTPAExtensions1().getAdditionalFareList()) {
                Flight additionalFlight = this.parseFlight(pricedItinerary, (AirItineraryPricingInfoType)additionalFares.getAirItineraryPricingInfo(), calcLine, passengerTypeCodes, accountCodes, corporateIds);
                flights.add(additionalFlight);
            }
        }
    }

    protected Flight parseFlight(PricedItineraryType pricedItinerary, AirItineraryPricingInfoType airItineraryPricingInfo, String calcLine, List<String> passengerTypeCodes, Map<DictionaryReference<Airline>, Collection<String>> accountCodes, Map<DictionaryReference<Airline>, Collection<String>> corporateIds) throws Exception {
        Flight flight = new Flight();
        flight.setSalesOriginContent(SalesOriginContent.SABRE);
        flight.setSalesOriginProvider(SalesOriginProvider.SABRE);
        flight.setNeedToApplyPublicFareDiscount(true);
        flight.setGds(GdsName.SABRE);
        flight.setLatinRegistration(true);
        SabreCustomPropertiesHelper.setDirectionInd(flight, pricedItinerary.getAirItinerary().getDirectionInd().toString());
        String lastTicketingDateString = airItineraryPricingInfo.getLastTicketDate();
        if (lastTicketingDateString != null) {
            flight.setPqTimeLimit(Date.from(LocalDate.parse(lastTicketingDateString, OTAAirLowFareSearchRSParsingHelper.DF).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        String carrierCode = pricedItinerary.getTPAExtensions1().getValidatingCarrier().getCode();
        flight.setCarrier(SabreHelper.resolveNativeCode(Airline.class, (String)carrierCode));
        flight.setEticket(OTAAirLowFareSearchRSParsingHelper.isETicket(pricedItinerary));
        ArrayList segByLegs = new ArrayList();
        ArrayList<FlightSegment> leg = null;
        Iterator fareInfoIter = airItineraryPricingInfo.getFareInfos().getFareInfoList().iterator();
        int gdsId = 1;
        String lastSegArrival = null;
        for (OriginDestinationOptionType odo : pricedItinerary.getAirItinerary().getOriginDestinationOptions().getOriginDestinationOptionList()) {
            boolean isStarting = true;
            for (BookFlightSegmentType sabreFs : odo.getFlightSegmentList()) {
                DictionaryReference<Airline> airlineRef;
                Set items;
                if (lastSegArrival != null && !lastSegArrival.equals(sabreFs.getDepartureAirport().getResponseLocationType().getLocationCode())) {
                    ++gdsId;
                }
                AirItineraryPricingInfoType.FareInfos.FareInfo fareInfo = (AirItineraryPricingInfoType.FareInfos.FareInfo)fareInfoIter.next();
                FlightSegment fs = new FlightSegment();
                fs.setGds(GdsName.SABRE);
                fs.setAvailableSeats(fareInfo.getTPAExtensions().getSeatsRemaining().getNumber());
                if (fareInfo.getTPAExtensions().getMeal() != null && !StringUtils.isBlank((String)fareInfo.getTPAExtensions().getMeal().getCode()) && !(items = DictHelper.getDictionaryItemsByCode(MealServiceIndicator.class, (String)fareInfo.getTPAExtensions().getMeal().getCode())).isEmpty()) {
                    fs.setMealServiceIndicator((DictionaryReference)((MealServiceIndicator)items.iterator().next()).toReference());
                }
                if (isStarting) {
                    if (leg != null) {
                        segByLegs.add(leg);
                    }
                    leg = new ArrayList<FlightSegment>();
                    fs.setStarting(true);
                    isStarting = false;
                }
                DictionaryReference<GeoLocation> locationBegin = OTAAirLowFareSearchFlightParser.resolveLocation(sabreFs.getDepartureAirport().getResponseLocationType().getLocationCode(), pricedItinerary);
                fs.setLocationBegin(locationBegin);
                fs.setTerminalBegin(sabreFs.getDepartureAirport().getTerminalID());
                DictionaryReference<GeoLocation> locationEnd = OTAAirLowFareSearchFlightParser.resolveLocation(sabreFs.getArrivalAirport().getResponseLocationType().getLocationCode(), pricedItinerary);
                fs.setLocationEnd(locationEnd);
                fs.setTerminalEnd(sabreFs.getArrivalAirport().getTerminalID());
                fs.setDateBegin(Date.from(LocalDateTime.parse(sabreFs.getDepartureDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF).atZone(ZoneId.systemDefault()).toInstant()));
                fs.setDateEnd(Date.from(LocalDateTime.parse(sabreFs.getArrivalDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF).atZone(ZoneId.systemDefault()).toInstant()));
                fs.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)sabreFs.getMarketingAirline().getCompanyIDAttributesGroup().getCode()));
                String code = sabreFs.getOperatingAirline().getCompanyNameType().getCompanyIDAttributesGroup().getCode();
                String operatingAirlineCompanyShortName = sabreFs.getOperatingAirline().getCompanyNameType().getCompanyIDAttributesGroup().getCompanyShortName();
                if ("**".equals(code)) {
                    String string = sabreFs.getDisclosureAirline().getString();
                    String spellVariant = SabreServerHelper.getSpellVariantFrom(string);
                    airlineRef = SabreServerHelper.findOrCreateAirlineBySpellVariant(spellVariant);
                } else {
                    airlineRef = SabreHelper.resolveNativeCode(Airline.class, (String)code);
                }
                fs.setOperatingAirline((DictionaryReference)airlineRef);
                fs.setOperatingAirlineCompanyShortName(operatingAirlineCompanyShortName);
                if (fs.getOperatingAirline() == null) {
                    fs.setOperatingAirline(fs.getAirline());
                }
                fs.setFlightNumber(sabreFs.getFlightNumber().replaceAll("^0+", ""));
                fs.setOperatingFlightNumber(sabreFs.getOperatingAirline().getFlightNumber());
                fs.setBoard(SabreHelper.resolveNativeCode(Aircraft.class, (String)((ResponseEquipmentType)sabreFs.getEquipmentList().get(0)).getEquipmentType().getAirEquipType()));
                fs.setStops(sabreFs.getStopQuantity().intValue());
                SabreCustomPropertiesHelper.setMarriageGrp(fs, sabreFs.getMarriageGrp());
                fs.setTravelDuration(sabreFs.getElapsedTime() == null ? OTAAirLowFareSearchRSParsingHelper.getTravelDuration(fs) : sabreFs.getElapsedTime().intValue());
                fs.setBookingClass(sabreFs.getResBookDesigCode());
                fs.setServiceClass(SabreHelper.cabin2ClassOfService((String)fareInfo.getTPAExtensions().getCabin().getCabin()));
                fs.setSubjectToGovernmentApproval(sabreFs.getTPAExtensions1().getDataElement() != null && BooleanUtil.nullAsFalse((Boolean)sabreFs.getTPAExtensions1().getDataElement().getSubjectToGovernmentApproval()));
                if (sabreFs.getStopQuantity().intValue() > 0) {
                    for (BookFlightSegmentType.StopAirports.StopAirport stopAirport : sabreFs.getStopAirports().getStopAirportList()) {
                        TechStopInfo techStop = new TechStopInfo();
                        techStop.setArrivalDateTime(LocalDateTime.parse(stopAirport.getArrivalDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF));
                        techStop.setDepartureDateTime(LocalDateTime.parse(stopAirport.getDepartureDateTime(), OTAAirLowFareSearchRSParsingHelper.DTF));
                        techStop.setDuration(stopAirport.getDuration().intValue());
                        techStop.setLocation(SabreHelper.resolveNativeCode(GeoLocation.class, (String)stopAirport.getResponseLocationType().getLocationCode()));
                        fs.getTechStopInfos().add(techStop);
                    }
                }
                fs.setGdsId(Integer.toString(gdsId));
                lastSegArrival = sabreFs.getArrivalAirport().getResponseLocationType().getLocationCode();
                ++gdsId;
                leg.add(fs);
            }
        }
        segByLegs.add(leg);
        List segments = segByLegs.stream().flatMap(Collection::stream).collect(Collectors.toList());
        Iterator<String> passengerTypeCodesIterator = passengerTypeCodes.iterator();
        for (PTCFareBreakdownType fareBreakDown : airItineraryPricingInfo.getPTCFareBreakdowns1().getPTCFareBreakdownList()) {
            String value;
            if (flight.getGdsCurrencyCode() == null) {
                flight.setGdsCurrencyCode(fareBreakDown.getPassengerFare().getTotalFareCurrencyAmountType().getCurrencyCodeGroup().getCurrencyCode());
            }
            if (SabreServerHelper.isAccountCode(value = OTAAirLowFareSearchRSParsingHelper.getAccountCode(fareBreakDown.getFareBasisCodeList()), accountCodes, corporateIds, (DictionaryReference<Airline>)flight.getCarrier())) {
                flight.setAccountCode(value);
            } else {
                flight.setCorporateId(value);
            }
            if (!StringUtils.isBlank((String)value)) {
                if (flight.getTripartiteContractDetails() == null) {
                    flight.setTripartiteContractDetails(new TripartiteContractDetails());
                }
                flight.getTripartiteContractDetails().setIssuedUnder3d(true);
            }
            flight.setAccountCodeApplied(true);
            flight.setCorporateIdApplied(true);
            String passengerTypeCode = passengerTypeCodesIterator.next();
            DictionaryReference passengerType = SabreHelper.resolveNativeCode(PassengerType.class, (String)passengerTypeCode);
            flight.getPrivateFare().put(passengerType, fareBreakDown.getPrivateFareType() != null);
            SeatPreferences sp = new SeatPreferences();
            sp.setPassengerType(passengerType);
            sp.setCount(fareBreakDown.getPassengerTypeQuantity().getQuantity().intValue());
            flight.getSeats().add(sp);
            FlightFare fare = OTAAirLowFareSearchRSParsingHelper.createFlightFare(fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
            flight.getFares().add(fare);
            if (fareBreakDown.getPassengerFare().getTaxes() != null) {
                OTAAirLowFareSearchRSParsingHelper.processTaxes(flight, fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
            }
            if (fareBreakDown.getPassengerFare().getOBFees1() != null) {
                OTAAirLowFareSearchRSParsingHelper.processOBFees(flight, fareBreakDown, (DictionaryReference<PassengerType>)passengerType);
            }
            Iterator fareBasisCodeIter = fareBreakDown.getFareBasisCodeList().iterator();
            Map<Integer, MiscUtil.Pair<LuggageInfo, ExtendedLuggageInfo>> luggageInfos = OTAAirLowFareSearchRSParsingHelper.getLuggageInfos(fareBreakDown);
            Map<Integer, ExtendedLuggageInfo> cabinLuggageInfos = OTAAirLowFareSearchRSParsingHelper.getCabinLuggageInfos(fareBreakDown);
            int segIdx = 0;
            for (int i = 0; i < segByLegs.size(); ++i) {
                List lfs = (List)segByLegs.get(i);
                for (int j = 0; j < lfs.size(); ++j) {
                    FlightSegment fs = (FlightSegment)lfs.get(j);
                    PTCFareBreakdownType.FareBasisCode fareBasisCode = (PTCFareBreakdownType.FareBasisCode)fareBasisCodeIter.next();
                    FareInfo fareInfo = OTAAirLowFareSearchRSParsingHelper.createFareInfo(passengerTypeCode, (DictionaryReference<PassengerType>)passengerType, fs.getGdsId(), i, j, luggageInfos.get(segIdx), cabinLuggageInfos.get(segIdx), fareBasisCode, Optional.ofNullable(fareBreakDown.getPassengerFare().getTPAExtensions1()).map(FareType.TPAExtensions::getFareComponents).orElse(null));
                    SabreCustomPropertiesHelper.setFareComponentDirectionality(fareInfo, fareBasisCode.getFareComponentDirectionality() != null ? fareBasisCode.getFareComponentDirectionality().name() : null);
                    fs.getFareInfos().add(fareInfo);
                    ++segIdx;
                }
            }
            flight.getPenaltiesInfos().put(passengerType, OTAAirLowFareSearchRSParsingHelper.parsePenaltiesInfo(fareBreakDown));
        }
        try {
            flight.getSegmentTariffs().addAll(GDSHelper.tryBuildFlightSegmentTariffs(segments, (String)calcLine));
        }
        catch (Exception ex) {
            FlightSegmentTariff fst = new FlightSegmentTariff();
            fst.setGds(GdsName.SABRE);
            fst.getSegments().addAll(segments);
            flight.getSegmentTariffs().add(fst);
        }
        if (airItineraryPricingInfo.getTPAExtensions1() != null && airItineraryPricingInfo.getTPAExtensions1().getAncillaryFeeGroups() != null && airItineraryPricingInfo.getTPAExtensions1().getAncillaryFeeGroups().getAncillaryFeeGroupList() != null) {
            block12: for (AirItineraryPricingInfoType.TPAExtensions.AncillaryFeeGroups.AncillaryFeeGroup ancillaryFeeGroup : airItineraryPricingInfo.getTPAExtensions1().getAncillaryFeeGroups().getAncillaryFeeGroupList()) {
                AncillaryFeeType type = GdsDictHelper.parseAncillaryFeeType((String)ancillaryFeeGroup.getCode(), (boolean)true);
                if (type == null) continue;
                switch (type) {
                    case BAGGAGE: {
                        flight.setAncillaryFeesRequestNeeded(true);
                        continue block12;
                    }
                    case PREFERRED_SEATING: {
                        flight.setSeatsMapAvailable(true);
                        continue block12;
                    }
                }
            }
        }
        return flight;
    }

    private String getCalcLine(MessageContext ctx) {
        PricedItineraryType pricedItinerary = (PricedItineraryType)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PRICED_ITINERARY);
        return ((PTCFareBreakdownType)((PricedItineraryType.AirItineraryPricingInfo)pricedItinerary.getAirItineraryPricingInfoList().get(0)).getPTCFareBreakdowns1().getPTCFareBreakdownList().get(0)).getTPAExtensions1().getFareCalcLine().getInfo();
    }

    private static DictionaryReference<GeoLocation> resolveLocation(String code, PricedItineraryType itin) {
        DictionaryReference result = SabreHelper.resolveNativeCode(GeoLocation.class, (String)code, (boolean)false, (boolean)false);
        if (result != null) {
            return result;
        }
        throw new SearchFlightsDictException(L10nResourcesManager.getStr((String)Messages.CannotResolveDictionaryReferenceGeoLocationCode, (Object[])new Object[]{code}), itin.getAirItinerary().getOriginDestinationOptions().getOriginDestinationOptionList().stream().map(OriginDestinationOptionType::getFlightSegmentList).flatMap(Collection::stream).map(sabreFs -> new MiscUtil.Pair((Object)sabreFs.getMarketingAirline().getCompanyIDAttributesGroup().getCode(), (Object)sabreFs.getFlightNumber().replaceAll("^0+", ""))).collect(Collectors.toList()));
    }
}

