/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.sabre.bfm.AirSearchPrefsType;
import com.gridnine.sabre.bfm.AirTripType;
import com.gridnine.sabre.bfm.BaggageRequestType;
import com.gridnine.sabre.bfm.CabinPrefType;
import com.gridnine.sabre.bfm.CabinType;
import com.gridnine.sabre.bfm.CodeListAirGroup;
import com.gridnine.sabre.bfm.CodeListGroup;
import com.gridnine.sabre.bfm.CompanyIDAttributesGroup;
import com.gridnine.sabre.bfm.CompanyNamePrefType;
import com.gridnine.sabre.bfm.CompanyNameType;
import com.gridnine.sabre.bfm.JumpCabinLogicType;
import com.gridnine.sabre.bfm.KeepSameCabinType;
import com.gridnine.sabre.bfm.OTAAirLowFareSearchRQ;
import com.gridnine.sabre.bfm.OTAPayloadStdAttributes;
import com.gridnine.sabre.bfm.PassengerInfoType;
import com.gridnine.sabre.bfm.PassengerTypeQuantityType;
import com.gridnine.sabre.bfm.PreferLevelType;
import com.gridnine.sabre.bfm.PriceRequestInformationType;
import com.gridnine.sabre.bfm.TransactionType;
import com.gridnine.sabre.bfm.TravelPreferencesTPAExtensionsTaxesGroup;
import com.gridnine.sabre.bfm.TravelerInfoSummaryType;
import com.gridnine.sabre.bfm.TravelerInformationType;
import com.gridnine.sabre.bfm.VoluntaryChangesSMPType;
import com.gridnine.sabre.bfm.XOFaresType;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.helper.GdsTracingHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.OTAAirLowFareSearchRQHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.CabinTypeAirlinesCombination;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OTAAirLowFareSearchRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        EntityReference specialTariffRef = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SPECIAL_TARIFF);
        SpecialTariff specialTariff = specialTariffRef != null ? (SpecialTariff)EntityStorage.get().resolve(specialTariffRef).getEntity() : null;
        CabinTypeAirlinesCombination cabinTypeAirlinesCombination = (CabinTypeAirlinesCombination)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_TYPE_AIRLINES_COMBINATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Collection accountCodes = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES);
        Collection corporateIds = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CORPORATE_IDS);
        Integer matrixSize = (Integer)ctx.getObject((Enum)IBusGdsContextKeys.MATRIX_SIZE);
        GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
        Collection<Object> airlines = cabinTypeAirlinesCombination.getAirlines();
        if (specialTariff != null) {
            airlines = Collections.singleton(specialTariff.getAirline());
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        OTAAirLowFareSearchRQ request = this.buildRequest(fsp, cabinTypeAirlinesCombination.getCabinType(), airlines, (SabreGdsAccount)accountCtr.getEntity(), accountCodes, corporateIds, matrixSize, specialTariff, messages);
        if (document != null && !messages.isEmpty()) {
            GdsTracingDocumentPart part = new GdsTracingDocumentPart();
            part.setName("request-messages");
            GdsTracingHelper.setGlobalData((GdsTracingDocumentPart)part, (String)MessageHelper.toSimpleString(messages));
            document.getParts().add(part);
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        if (matrixSize != null) {
            ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"BargainFinderMax_ADRQ");
        } else {
            ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"BargainFinderMaxRQ");
        }
    }

    private OTAAirLowFareSearchRQ buildRequest(FlightSearchParameters fsp, CabinType cabinType, Collection<DictionaryReference<Airline>> airlines, SabreGdsAccount account, Collection<String> accountCodes, Collection<String> corporateIds, Integer matrixSize, SpecialTariff specialTariff, List<Message> messages) {
        OTAAirLowFareSearchRQ request = new OTAAirLowFareSearchRQ();
        OTAPayloadStdAttributes stdattr = new OTAPayloadStdAttributes();
        stdattr.setVersion("6.6.0");
        request.setOTAPayloadStdAttributes(stdattr);
        request.setPOS(OTAAirLowFareSearchRQHelper.buildPos(account.getPrimaryPCC()));
        if (fsp.isSkipConnected()) {
            request.setDirectFlightsOnly(Boolean.TRUE);
        }
        request.setTravelerInfoSummary(this.buildTravelerInfoSummary(fsp, accountCodes, corporateIds, specialTariff));
        request.setTPAExtensions1(this.buildTpaExtensions(fsp, matrixSize, account));
        request.setTravelPreferences(this.buildTravelPreferences(request, fsp, cabinType, airlines, account, specialTariff, messages));
        return request;
    }

    private OTAAirLowFareSearchRQ.TPAExtensions buildTpaExtensions(FlightSearchParameters fsp, Integer matrixSize, SabreGdsAccount account) {
        TransactionType.RequestType requestType;
        TransactionType transaction;
        OTAAirLowFareSearchRQ.TPAExtensions tpa;
        block16: {
            block15: {
                tpa = new OTAAirLowFareSearchRQ.TPAExtensions();
                transaction = new TransactionType();
                requestType = new TransactionType.RequestType();
                requestType.setString("");
                if (matrixSize == null) break block15;
                switch (matrixSize) {
                    case 1: {
                        requestType.setName("AD1");
                        break block16;
                    }
                    case 3: {
                        requestType.setName("AD3");
                        break block16;
                    }
                    default: {
                        throw Xeption.forDeveloper((String)"unsupported matrix size {0}", (Object[])new Object[]{matrixSize});
                    }
                }
            }
            if (fsp.getLimit() != null) {
                if (fsp.getLimit() <= 50) {
                    requestType.setName("50ITINS");
                } else if (fsp.getLimit() <= 100) {
                    requestType.setName("100ITINS");
                } else {
                    requestType.setName("200ITINS");
                }
            } else {
                switch (account.getRequestType()) {
                    case ITINS_50: {
                        requestType.setName("50ITINS");
                        break;
                    }
                    case ITINS_100: {
                        requestType.setName("100ITINS");
                        break;
                    }
                    case ITINS_200: {
                        requestType.setName("200ITINS");
                        break;
                    }
                }
            }
        }
        transaction.setRequestType(requestType);
        tpa.setIntelliSellTransaction(transaction);
        return tpa;
    }

    private TravelerInfoSummaryType buildTravelerInfoSummary(FlightSearchParameters fsp, Collection<String> accountCodes, Collection<String> corporateIds, SpecialTariff specialTariff) {
        PriceRequestInformationType.Choice.AccountCode code;
        PriceRequestInformationType.Choice choice;
        TravelerInfoSummaryType summary = new TravelerInfoSummaryType();
        TravelerInformationType info = new TravelerInformationType();
        for (SeatPreferences sp : fsp.getSeats()) {
            PassengerInfoType ptq = new PassengerInfoType();
            ptq.setCode(SabreHelper.getNativeCode((DictionaryReference)sp.getPassengerType()));
            ptq.setQuantity(new BigInteger(Integer.toString(sp.getCount())));
            PassengerTypeQuantityType.TPAExtensions tpa = new PassengerTypeQuantityType.TPAExtensions();
            VoluntaryChangesSMPType vc = new VoluntaryChangesSMPType();
            vc.setMatch(VoluntaryChangesSMPType.Match.INFO);
            tpa.setVoluntaryChanges(vc);
            ptq.setTPAExtensions1(tpa);
            info.getPassengerTypeQuantityList().add(ptq);
        }
        summary.getAirTravelerAvailList().add(info);
        info = new PriceRequestInformationType();
        for (String accountCode : accountCodes) {
            choice = new PriceRequestInformationType.Choice();
            code = new PriceRequestInformationType.Choice.AccountCode();
            code.setCode(accountCode);
            choice.setAccountCode(code);
            info.getChoiceList().add(choice);
        }
        for (String corporateId : corporateIds) {
            choice = new PriceRequestInformationType.Choice();
            code = new PriceRequestInformationType.Choice.NegotiatedFareCode();
            CodeListAirGroup codeListAirGroup = new CodeListAirGroup();
            CodeListGroup codeListGroup = new CodeListGroup();
            codeListGroup.setCode(corporateId);
            codeListAirGroup.setCodeListGroup(codeListGroup);
            code.setCodeListAirGroup(codeListAirGroup);
            choice.setNegotiatedFareCode((PriceRequestInformationType.Choice.NegotiatedFareCode)code);
            info.getChoiceList().add(choice);
        }
        PriceRequestInformationType.TPAExtensions tpa = new PriceRequestInformationType.TPAExtensions();
        PriceRequestInformationType.TPAExtensions.BrandedFareIndicators bfi = new PriceRequestInformationType.TPAExtensions.BrandedFareIndicators();
        bfi.setSingleBrandedFare(Boolean.TRUE);
        tpa.setBrandedFareIndicators(bfi);
        if (fsp.isPublicFaresOnly()) {
            PriceRequestInformationType.TPAExtensions.PublicFare pf = new PriceRequestInformationType.TPAExtensions.PublicFare();
            pf.setInd(Boolean.TRUE);
            tpa.setPublicFare(pf);
        }
        if (specialTariff != null && specialTariff.getResidentCountry() != null) {
            PriceRequestInformationType.TPAExtensions.PassengerStatus status = new PriceRequestInformationType.TPAExtensions.PassengerStatus();
            status.setType(PriceRequestInformationType.TPAExtensions.PassengerStatus.Type.R);
            PriceRequestInformationType.TPAExtensions.PassengerStatus.Sequence seq = new PriceRequestInformationType.TPAExtensions.PassengerStatus.Sequence();
            seq.setCountryCode(SabreHelper.getNativeCode((DictionaryReference)specialTariff.getResidentCountry()));
            status.setStateCode(seq);
            tpa.setPassengerStatus(status);
        }
        info.setTPAExtensions1(tpa);
        summary.setPriceRequestInformation((PriceRequestInformationType)info);
        return summary;
    }

    private AirSearchPrefsType buildTravelPreferences(OTAAirLowFareSearchRQ request, FlightSearchParameters fsp, CabinType cabinType, Collection<DictionaryReference<Airline>> airlines, SabreGdsAccount account, SpecialTariff specialTariff, List<Message> messages) {
        AirSearchPrefsType travelPreferences = new AirSearchPrefsType();
        travelPreferences.setValidInterlineTicket(Boolean.TRUE);
        CabinPrefType cabinPref = new CabinPrefType();
        cabinPref.setPreferLevel(PreferLevelType.ONLY);
        cabinPref.setCabin(cabinType);
        travelPreferences.getCabinPrefList().add(cabinPref);
        for (DictionaryReference dictionaryReference : airlines) {
            DictionaryReference airlineRef = SabreHelper.resolveNativeCode(Airline.class, (String)dictionaryReference.getCode(), (boolean)false, (boolean)false);
            if (airlineRef == null) {
                IncidentsLog.reportAdminStackTrace((String)String.format("\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430/\u043a \u0441 \u043a\u043e\u0434\u043e\u043c %s", account.getName(), dictionaryReference.getCode()));
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0430/\u043a \u0441 \u043a\u043e\u0434\u043e\u043c {0}", (Object[])new Object[]{dictionaryReference.getCode()}));
                continue;
            }
            String nativeCode = SabreHelper.getNativeCodeOrNull((DictionaryReference)airlineRef);
            if (TextUtil.isBlank((String)nativeCode)) {
                IncidentsLog.reportAdminStackTrace((String)String.format("\u0423 \u0430/\u043a %s \u043d\u0435\u0442 IATA-\u043a\u043e\u0434\u0430", dictionaryReference.getCode()));
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0423 \u0430/\u043a {0} \u043d\u0435\u0442 IATA-\u043a\u043e\u0434\u0430", (Object[])new Object[]{airlineRef.getCode()}));
                continue;
            }
            CompanyNamePrefType vendorPref = new CompanyNamePrefType();
            vendorPref.setPreferLevel(PreferLevelType.ONLY);
            CompanyNameType companyName = new CompanyNameType();
            CompanyIDAttributesGroup companyID = new CompanyIDAttributesGroup();
            companyID.setCode(nativeCode);
            companyName.setCompanyIDAttributesGroup(companyID);
            companyName.setString("");
            vendorPref.setCompanyNameType(companyName);
            travelPreferences.getVendorPrefList().add(vendorPref);
        }
        if (fsp.isSkipConnected()) {
            travelPreferences.setMaxStopsQuantity(BigInteger.ZERO);
        }
        AirSearchPrefsType.TPAExtensions tpaExtensions = new AirSearchPrefsType.TPAExtensions();
        if (fsp.isStrictMode() || specialTariff != null) {
            XOFaresType xOFaresType = new XOFaresType();
            xOFaresType.setValue(true);
            tpaExtensions.setXOFares(xOFaresType);
        }
        if (!fsp.isSkipConnected() && account.isLongConnectionEnabled()) {
            AirSearchPrefsType.TPAExtensions.LongConnectTime longConnectTime = new AirSearchPrefsType.TPAExtensions.LongConnectTime();
            longConnectTime.setEnable(Boolean.TRUE);
            tpaExtensions.setLongConnectTime(longConnectTime);
        }
        if (fsp.getServiceClass() != ClassOfService.ECONOMY) {
            JumpCabinLogicType jumpCabinLogicType = new JumpCabinLogicType();
            jumpCabinLogicType.setDisabled(true);
            tpaExtensions.setJumpCabinLogic(jumpCabinLogicType);
            KeepSameCabinType keepSameCabinType = new KeepSameCabinType();
            keepSameCabinType.setEnabled(true);
            tpaExtensions.setKeepSameCabin(keepSameCabinType);
        }
        tpaExtensions.setTripType(OTAAirLowFareSearchRQBuilder.getTripType(fsp.getRoute()));
        if (specialTariff != null && specialTariff.isExcludeTaxes()) {
            TravelPreferencesTPAExtensionsTaxesGroup travelPreferencesTPAExtensionsTaxesGroup = new TravelPreferencesTPAExtensionsTaxesGroup();
            TravelPreferencesTPAExtensionsTaxesGroup.ExemptAllTaxes eat = new TravelPreferencesTPAExtensionsTaxesGroup.ExemptAllTaxes();
            eat.setValue(true);
            travelPreferencesTPAExtensionsTaxesGroup.setExemptAllTaxes(eat);
            tpaExtensions.setTravelPreferencesTPAExtensionsTaxesGroup(travelPreferencesTPAExtensionsTaxesGroup);
        }
        if ("200ITINS".equals(request.getTPAExtensions1().getIntelliSellTransaction().getRequestType().getName())) {
            AirSearchPrefsType.TPAExtensions.DiversityParameters diversityParameters = new AirSearchPrefsType.TPAExtensions.DiversityParameters();
            diversityParameters.setAdditionalNonStopsNumber("100");
            tpaExtensions.setDiversityParameters(diversityParameters);
        }
        AirSearchPrefsType.Baggage baggage = new AirSearchPrefsType.Baggage();
        baggage.setRequestType(BaggageRequestType.A);
        baggage.setDescription(Boolean.valueOf(true));
        baggage.setCarryOnInfo(Boolean.valueOf(true));
        if (fsp.isExcludeBaglessFares()) {
            baggage.setFreePieceRequired(Boolean.valueOf(true));
        }
        travelPreferences.setBaggage(baggage);
        travelPreferences.setTPAExtensions1(tpaExtensions);
        if (!fsp.isExcludeAncillaryFees()) {
            AirSearchPrefsType.AncillaryFees ancillaryFees = new AirSearchPrefsType.AncillaryFees();
            ancillaryFees.setEnable(true);
            travelPreferences.setAncillaryFees(ancillaryFees);
        }
        if (account.isTch()) {
            tpaExtensions.setSettlementMethod("TCH");
        }
        return travelPreferences;
    }

    private static AirTripType getTripType(List<RouteSegment> route) {
        if (route.size() == 1) {
            return AirTripType.ONE_WAY;
        }
        if (route.size() == 2) {
            RouteSegment firstSegment = route.get(0);
            RouteSegment secondSegment = route.get(1);
            if (firstSegment.getLocationBegin().equals((Object)secondSegment.getLocationEnd()) && firstSegment.getLocationEnd().equals((Object)secondSegment.getLocationBegin())) {
                return AirTripType.RETURN;
            }
        }
        return AirTripType.OTHER;
    }
}

