/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.sabre.bfm.AirlineType;
import com.gridnine.sabre.bfm.IncludeVendorPrefType;
import com.gridnine.sabre.bfm.OTAAirLowFareSearchRQ;
import com.gridnine.sabre.bfm.OriginDestinationFlightAttributeGroup;
import com.gridnine.sabre.bfm.OriginDestinationFlightGroup;
import com.gridnine.sabre.bfm.OriginDestinationFlightType;
import com.gridnine.sabre.bfm.OriginDestinationInformationTPAExtensionsGroup;
import com.gridnine.sabre.bfm.RequestLocationType;
import com.gridnine.sabre.bfm.RequestSpecifiedLocationType;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.RouteSegmentWithFlightSegments;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.VerifyFlightDetailsRS;
import java.math.BigInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.FastDateFormat;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OriginDestinationInformationBuilder
extends BaseProcessor {
    private static final FastDateFormat DTF = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final String DATE_TIME_PATTERN = "MM-dd'T'HH:mm";
    private static final DateTimeFormatter TIME_WINDOW_FORMATTER = DateTimeFormat.forPattern((String)"HHmm");

    public void process(MessageContext ctx) throws Exception {
        OTAAirLowFareSearchRQ request = (OTAAirLowFareSearchRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        RouteSegmentWithFlightSegments rswfs = (RouteSegmentWithFlightSegments)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.ROUTE_SEGMENT_WITH_FLIGHT_SEGMENTS);
        Integer maxConnectionTime = (Integer)ctx.getObject((Enum)IBusGdsContextKeys.MAX_CONNECTION_TIME);
        request.getOriginDestinationInformationList().add(this.buildOriginDestinationInformation(rswfs, maxConnectionTime));
    }

    private OTAAirLowFareSearchRQ.OriginDestinationInformation buildOriginDestinationInformation(RouteSegmentWithFlightSegments rswfs, Integer maxConnectionTime) {
        OTAAirLowFareSearchRQ.OriginDestinationInformation odi = new OTAAirLowFareSearchRQ.OriginDestinationInformation();
        if (!rswfs.getFlightSegments().isEmpty()) {
            odi.setFixed(Boolean.TRUE);
        }
        RouteSegment rs = rswfs.getRouteSegment();
        odi.setOriginLocationRequestSpecifiedLocationType(OriginDestinationInformationBuilder.buildRequestSpecifiedLocationType((DictionaryReference<GeoLocation>)rs.getLocationBegin()));
        odi.setDestinationLocationRequestSpecifiedLocationType(OriginDestinationInformationBuilder.buildRequestSpecifiedLocationType((DictionaryReference<GeoLocation>)rs.getLocationEnd()));
        odi.setDepartureDateTime(DTF.format(rs.getDate()));
        odi.setDepartureWindow(OriginDestinationInformationBuilder.formatTimeWindow(rs.getDepartureTimeBegin(), rs.getDepartureTimeEnd()));
        odi.setArrivalWindow(OriginDestinationInformationBuilder.formatTimeWindow(rs.getArrivalTimeBegin(), rs.getArrivalTimeEnd()));
        odi.setTPAExtensions1(OriginDestinationInformationBuilder.buildTpaExtensions(rswfs, maxConnectionTime));
        return odi;
    }

    private static OTAAirLowFareSearchRQ.OriginDestinationInformation.TPAExtensions buildTpaExtensions(RouteSegmentWithFlightSegments rswfs, Integer maxConnectionTime) {
        RouteSegment rs = rswfs.getRouteSegment();
        if (maxConnectionTime == null && rswfs.getFlightSegments().isEmpty() && rs.getAirline() == null) {
            return null;
        }
        OTAAirLowFareSearchRQ.OriginDestinationInformation.TPAExtensions tpaExtensions = new OTAAirLowFareSearchRQ.OriginDestinationInformation.TPAExtensions();
        if (!rswfs.getFlightSegments().isEmpty() || maxConnectionTime != null) {
            OriginDestinationInformationTPAExtensionsGroup group = new OriginDestinationInformationTPAExtensionsGroup();
            OriginDestinationInformationTPAExtensionsGroup.ConnectionTime connectionTime = new OriginDestinationInformationTPAExtensionsGroup.ConnectionTime();
            connectionTime.setMax(!rswfs.getFlightSegments().isEmpty() ? BigInteger.ZERO : BigInteger.valueOf(maxConnectionTime.intValue()));
            group.setConnectionTime(connectionTime);
            tpaExtensions.setOriginDestinationInformationTPAExtensionsGroup(group);
        }
        if (!rswfs.getFlightSegments().isEmpty()) {
            tpaExtensions.getFlightList().addAll(rswfs.getFlightSegments().stream().map(OriginDestinationInformationBuilder::buildFlight).collect(Collectors.toList()));
        } else if (rs.getAirline() != null) {
            IncludeVendorPrefType includeVendorPref = new IncludeVendorPrefType();
            includeVendorPref.setCode(SabreHelper.getNativeCode((DictionaryReference)rs.getAirline()));
            tpaExtensions.getIncludeVendorPrefList().add(includeVendorPref);
        }
        return tpaExtensions;
    }

    private static OriginDestinationFlightType buildFlight(VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment flightSegment) {
        OriginDestinationFlightType flight = new OriginDestinationFlightType();
        OriginDestinationFlightAttributeGroup attributes = new OriginDestinationFlightAttributeGroup();
        attributes.setNumber(Short.parseShort(flightSegment.getFlightNumber()));
        attributes.setType("A");
        attributes.setDepartureDateTime(OriginDestinationInformationBuilder.convertDate(flightSegment.getDepartureDateTime()));
        attributes.setArrivalDateTime(OriginDestinationInformationBuilder.convertDate(flightSegment.getArrivalDateTime()));
        flight.setOriginDestinationFlightAttributeGroup(attributes);
        OriginDestinationFlightGroup group = new OriginDestinationFlightGroup();
        group.setOriginLocation(OriginDestinationInformationBuilder.buildRequestLocationType(flightSegment.getOriginLocation().getLocationCode()));
        group.setDestinationLocation(OriginDestinationInformationBuilder.buildRequestLocationType(flightSegment.getDestinationLocation().getLocationCode()));
        AirlineType airline = new AirlineType();
        airline.setMarketing(flightSegment.getMarketingAirline().getCode());
        group.setAirline(airline);
        flight.setOriginDestinationFlightGroup(group);
        return flight;
    }

    private static String convertDate(String date) {
        return SabreHelper.parseLocalDateTimeWithoutYear((String)date, (String)DATE_TIME_PATTERN).format(java.time.format.DateTimeFormatter.ISO_DATE_TIME);
    }

    private static RequestSpecifiedLocationType buildRequestSpecifiedLocationType(DictionaryReference<GeoLocation> location) {
        RequestSpecifiedLocationType result = new RequestSpecifiedLocationType();
        result.setRequestLocationType(OriginDestinationInformationBuilder.buildRequestLocationType(SabreHelper.getNativeCode(location)));
        return result;
    }

    private static RequestLocationType buildRequestLocationType(String code) {
        RequestLocationType result = new RequestLocationType();
        result.setLocationCode(code);
        result.setString("");
        return result;
    }

    private static String formatTimeWindow(Integer begin, Integer end) {
        if (begin != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(OriginDestinationInformationBuilder.formatTime(begin));
            if (end != null) {
                sb.append(OriginDestinationInformationBuilder.formatTime(end));
            }
            return sb.toString();
        }
        if (end != null) {
            throw Xeption.forDeveloper((String)"time end without time begin, should have been handled by validation", (Object[])new Object[0]);
        }
        return null;
    }

    private static String formatTime(Integer value) {
        LocalTime tb = LocalTime.fromMillisOfDay((long)((long)value.intValue() * 60000L));
        return TIME_WINDOW_FORMATTER.print((ReadablePartial)tb);
    }
}

