/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.RouteSegmentWithFlightSegments;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.RouteSegmentWithFlightSegmentsProvider;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.flightDetails.CalculateRouteSegmentWithFlightNumbers;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.sabre.webservices.sabrexml.VerifyFlightDetailsRS;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

public class RouteSegmentWithFlightSegmentsProviderTest
extends ModelTestBase {
    private final CalculateRouteSegmentWithFlightNumbers calcRouteProcessor = new CalculateRouteSegmentWithFlightNumbers();
    private final RouteSegmentWithFlightSegmentsProvider provider = new RouteSegmentWithFlightSegmentsProvider();

    @Test
    public void testNoFlightNumbers() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", null, null);
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", "AF", null);
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1), new VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment[0]));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.get(0).getFlightSegments().isEmpty());
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs0, result.get(0).getRouteSegment());
        Assert.assertTrue((boolean)result.get(1).getFlightSegments().isEmpty());
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs1, result.get(1).getRouteSegment());
    }

    @Test
    public void testPartialFlightNumber() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", null, null);
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", "AF", "12");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T09:00", "01-01T11:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1), null, fs1));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.get(0).getFlightSegments().isEmpty());
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs0, result.get(0).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs1, (Object)result.get(1).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs1, result.get(1).getRouteSegment());
    }

    @Test
    public void testOneway() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", 5, 6, 7, 8, "AF", "34");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("SVO", "LHR", "01-01T09:00", "01-01T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T18:00", "01-01T20:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1), fs0, fs1));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)2L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        Assert.assertSame((Object)fs1, (Object)result.get(0).getFlightSegments().get(1));
        RouteSegment expected = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "PAR", "2020-01-01", 1, 2, 7, 8, null, null);
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(expected, result.get(0).getRouteSegment());
    }

    @Test
    public void testRoundtrip() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", 5, 6, 7, 8, "AF", "34");
        RouteSegment rs2 = RouteSegmentWithFlightSegmentsProviderTest.rs("PAR", "LON", "2020-01-08", 9, 10, 11, 12, "AF", "35");
        RouteSegment rs3 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "MOW", "2020-01-08", 13, 14, 15, 16, "AF", "13");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("SVO", "LHR", "01-01T09:00", "01-01T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T18:00", "01-01T20:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs2 = RouteSegmentWithFlightSegmentsProviderTest.fs("CDG", "LHR", "01-08T09:00", "01-08T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs3 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "SVO", "01-08T18:00", "01-08T20:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1, rs2, rs3), fs0, fs1, fs2, fs3));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        Assert.assertSame((Object)fs1, (Object)result.get(0).getFlightSegments().get(1));
        RouteSegment expected1 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "PAR", "2020-01-01", 1, 2, 7, 8, null, null);
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(expected1, result.get(0).getRouteSegment());
        Assert.assertEquals((long)2L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs2, (Object)result.get(1).getFlightSegments().get(0));
        Assert.assertSame((Object)fs3, (Object)result.get(1).getFlightSegments().get(1));
        RouteSegment expected2 = RouteSegmentWithFlightSegmentsProviderTest.rs("PAR", "MOW", "2020-01-08", 9, 10, 15, 16, null, null);
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(expected2, result.get(1).getRouteSegment());
    }

    @Test
    public void testOpenJaw() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", 5, 6, 7, 8, "AF", "34");
        RouteSegment rs2 = RouteSegmentWithFlightSegmentsProviderTest.rs("FRA", "LON", "2020-01-08", 9, 10, 11, 12, "AF", "35");
        RouteSegment rs3 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "MOW", "2020-01-08", 13, 14, 15, 16, "AF", "13");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("SVO", "LHR", "01-01T09:00", "01-01T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T18:00", "01-01T20:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs2 = RouteSegmentWithFlightSegmentsProviderTest.fs("FRA", "LHR", "01-08T09:00", "01-08T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs3 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "SVO", "01-08T18:00", "01-08T20:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1, rs2, rs3), fs0, fs1, fs2, fs3));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        Assert.assertSame((Object)fs1, (Object)result.get(0).getFlightSegments().get(1));
        RouteSegment expected1 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "PAR", "2020-01-01", 1, 2, 7, 8, null, null);
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(expected1, result.get(0).getRouteSegment());
        Assert.assertEquals((long)2L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs2, (Object)result.get(1).getFlightSegments().get(0));
        Assert.assertSame((Object)fs3, (Object)result.get(1).getFlightSegments().get(1));
        RouteSegment expected2 = RouteSegmentWithFlightSegmentsProviderTest.rs("FRA", "MOW", "2020-01-08", 9, 10, 15, 16, null, null);
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(expected2, result.get(1).getRouteSegment());
    }

    @Test
    public void testMultistop() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-02", 5, 6, 7, 8, "AF", "34");
        RouteSegment rs2 = RouteSegmentWithFlightSegmentsProviderTest.rs("FRA", "PAR", "2020-01-08", 9, 10, 11, 12, "AF", "35");
        RouteSegment rs3 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "MOW", "2020-01-08", 13, 14, 15, 16, "AF", "13");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("SVO", "LHR", "01-01T09:00", "01-01T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-02T18:00", "01-02T20:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs2 = RouteSegmentWithFlightSegmentsProviderTest.fs("FRA", "CDG", "01-08T09:00", "01-08T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs3 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "SVO", "01-08T18:00", "01-08T20:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1, rs2, rs3), fs0, fs1, fs2, fs3));
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)1L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs0, result.get(0).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs1, (Object)result.get(1).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs1, result.get(1).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(2).getFlightSegments().size());
        Assert.assertSame((Object)fs2, (Object)result.get(2).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs2, result.get(2).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(3).getFlightSegments().size());
        Assert.assertSame((Object)fs3, (Object)result.get(3).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs3, result.get(3).getRouteSegment());
    }

    @Test
    public void testGoodSameDayRoundtrip() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", 5, 6, 7, 8, "AF", "34");
        RouteSegment rs2 = RouteSegmentWithFlightSegmentsProviderTest.rs("PAR", "LON", "2020-01-01", 9, 10, 11, 12, "AF", "35");
        RouteSegment rs3 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "MOW", "2020-01-01", 13, 14, 15, 16, "AF", "13");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("SVO", "LHR", "01-01T02:00", "01-01T03:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T04:00", "01-01T05:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs2 = RouteSegmentWithFlightSegmentsProviderTest.fs("CDG", "LHR", "01-01T06:00", "01-01T07:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs3 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "SVO", "01-01T08:00", "01-01T09:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1, rs2, rs3), fs0, fs1, fs2, fs3));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        Assert.assertSame((Object)fs1, (Object)result.get(0).getFlightSegments().get(1));
        RouteSegment expected1 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "PAR", "2020-01-01", 1, 2, 7, 8, null, null);
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(expected1, result.get(0).getRouteSegment());
        Assert.assertEquals((long)2L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs2, (Object)result.get(1).getFlightSegments().get(0));
        Assert.assertSame((Object)fs3, (Object)result.get(1).getFlightSegments().get(1));
        RouteSegment expected2 = RouteSegmentWithFlightSegmentsProviderTest.rs("PAR", "MOW", "2020-01-01", 9, 10, 15, 16, null, null);
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(expected2, result.get(1).getRouteSegment());
    }

    @Test
    public void testBadSameDayRoundtripCase1OddNumberOfSegments() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", 5, 6, 7, 8, "AF", "34");
        RouteSegment rs2 = RouteSegmentWithFlightSegmentsProviderTest.rs("PAR", "MOW", "2020-01-01", 9, 10, 11, 12, "AF", "35");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("SVO", "LHR", "01-01T02:00", "01-01T03:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T04:00", "01-01T05:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs2 = RouteSegmentWithFlightSegmentsProviderTest.fs("CDG", "SVO", "01-01T06:00", "01-01T07:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1, rs2), fs0, fs1, fs2));
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((long)1L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs0, result.get(0).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs1, (Object)result.get(1).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs1, result.get(1).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(2).getFlightSegments().size());
        Assert.assertSame((Object)fs2, (Object)result.get(2).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs2, result.get(2).getRouteSegment());
    }

    @Test
    public void testBadSameDayRoundtripCase2DifferentStopovers() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("MOW", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", 5, 6, 7, 8, "AF", "34");
        RouteSegment rs2 = RouteSegmentWithFlightSegmentsProviderTest.rs("PAR", "FRA", "2020-01-01", 9, 10, 11, 12, "AF", "35");
        RouteSegment rs3 = RouteSegmentWithFlightSegmentsProviderTest.rs("FRA", "MOW", "2020-01-01", 13, 14, 15, 16, "AF", "13");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("SVO", "LHR", "01-01T02:00", "01-01T03:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T04:00", "01-01T05:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs2 = RouteSegmentWithFlightSegmentsProviderTest.fs("CDG", "FRA", "01-01T06:00", "01-01T07:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs3 = RouteSegmentWithFlightSegmentsProviderTest.fs("FRA", "SVO", "01-01T08:00", "01-01T09:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1, rs2, rs3), fs0, fs1, fs2, fs3));
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)1L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs0, result.get(0).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs1, (Object)result.get(1).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs1, result.get(1).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(2).getFlightSegments().size());
        Assert.assertSame((Object)fs2, (Object)result.get(2).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs2, result.get(2).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(3).getFlightSegments().size());
        Assert.assertSame((Object)fs3, (Object)result.get(3).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs3, result.get(3).getRouteSegment());
    }

    @Test
    public void testException() throws Exception {
        RouteSegment rs0 = RouteSegmentWithFlightSegmentsProviderTest.rs("XXX", "LON", "2020-01-01", 1, 2, 3, 4, "AF", "12");
        RouteSegment rs1 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "PAR", "2020-01-01", 5, 6, 7, 8, "AF", "34");
        RouteSegment rs2 = RouteSegmentWithFlightSegmentsProviderTest.rs("PAR", "LON", "2020-01-08", 9, 10, 11, 12, "AF", "35");
        RouteSegment rs3 = RouteSegmentWithFlightSegmentsProviderTest.rs("LON", "XXX", "2020-01-08", 13, 14, 15, 16, "AF", "13");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs0 = RouteSegmentWithFlightSegmentsProviderTest.fs("XXX", "LHR", "01-01T09:00", "01-01T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs1 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "CDG", "01-01T18:00", "01-01T20:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs2 = RouteSegmentWithFlightSegmentsProviderTest.fs("CDG", "LHR", "01-08T09:00", "01-08T11:00");
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs3 = RouteSegmentWithFlightSegmentsProviderTest.fs("LHR", "XXX", "01-08T18:00", "01-08T20:00");
        List<RouteSegmentWithFlightSegments> result = this.test(RouteSegmentWithFlightSegmentsProviderTest.ctx(RouteSegmentWithFlightSegmentsProviderTest.fsp(rs0, rs1, rs2, rs3), fs0, fs1, fs2, fs3));
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)1L, (long)result.get(0).getFlightSegments().size());
        Assert.assertSame((Object)fs0, (Object)result.get(0).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs0, result.get(0).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(1).getFlightSegments().size());
        Assert.assertSame((Object)fs1, (Object)result.get(1).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs1, result.get(1).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(2).getFlightSegments().size());
        Assert.assertSame((Object)fs2, (Object)result.get(2).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs2, result.get(2).getRouteSegment());
        Assert.assertEquals((long)1L, (long)result.get(3).getFlightSegments().size());
        Assert.assertSame((Object)fs3, (Object)result.get(3).getFlightSegments().get(0));
        RouteSegmentWithFlightSegmentsProviderTest.assertEquals(rs3, result.get(3).getRouteSegment());
    }

    private List<RouteSegmentWithFlightSegments> test(MessageContext ctx) throws Exception {
        this.calcRouteProcessor.process(ctx);
        return (List)this.provider.getTargets(ctx);
    }

    private static void assertEquals(RouteSegment expected, RouteSegment actual) {
        Assert.assertEquals((Object)expected.getLocationBegin(), (Object)actual.getLocationBegin());
        Assert.assertEquals((Object)expected.getLocationEnd(), (Object)actual.getLocationEnd());
        Assert.assertEquals((Object)expected.getDate(), (Object)actual.getDate());
        Assert.assertEquals((Object)expected.getDepartureTimeBegin(), (Object)actual.getDepartureTimeBegin());
        Assert.assertEquals((Object)expected.getDepartureTimeEnd(), (Object)actual.getDepartureTimeEnd());
        Assert.assertEquals((Object)expected.getArrivalTimeBegin(), (Object)actual.getArrivalTimeBegin());
        Assert.assertEquals((Object)expected.getArrivalTimeEnd(), (Object)actual.getArrivalTimeEnd());
    }

    private static MessageContext ctx(FlightSearchParameters fsp, VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment ... flightSegments) {
        MessageContext result = new MessageContext();
        result.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)fsp);
        if (flightSegments.length > 0) {
            result.putObject((Enum)IBusGdsSabreContextKeys.VERIFY_FLIGHT_DETAILS_MAP, IntStream.range(0, flightSegments.length).filter(i -> flightSegments[i] != null).mapToObj(i -> new MiscUtil.Pair(fsp.getRoute().get(i), (Object)RouteSegmentWithFlightSegmentsProviderTest.wrap(flightSegments[i]))).collect(Collectors.toMap(MiscUtil.Pair::getFirst, MiscUtil.Pair::getSecond)));
        }
        return result;
    }

    private static FlightSearchParameters fsp(RouteSegment ... routeSegments) {
        FlightSearchParameters result = new FlightSearchParameters();
        result.getRoute().addAll(Arrays.asList(routeSegments));
        return result;
    }

    private static RouteSegment rs(String locationBegin, String locationEnd, String date, String airline, String flightNumber) {
        return RouteSegmentWithFlightSegmentsProviderTest.rs(locationBegin, locationEnd, date, null, null, null, null, airline, flightNumber);
    }

    private static RouteSegment rs(String locationBegin, String locationEnd, String date, Integer departureTimeBegin, Integer departureTimeEnd, Integer arrivalTimeBegin, Integer arrivalTimeEnd, String airline, String flightNumber) {
        RouteSegment result = new RouteSegment();
        if (locationBegin != null) {
            result.setLocationBegin((DictionaryReference)new GeoLocationReference(locationBegin));
        }
        if (locationEnd != null) {
            result.setLocationEnd((DictionaryReference)new GeoLocationReference(locationEnd));
        }
        if (date != null) {
            result.setDate(Date.from(LocalDate.parse(date).atStartOfDay(ZoneId.systemDefault()).toInstant()));
        }
        result.setDepartureTimeBegin(departureTimeBegin);
        result.setDepartureTimeEnd(departureTimeEnd);
        result.setArrivalTimeBegin(arrivalTimeBegin);
        result.setArrivalTimeEnd(arrivalTimeEnd);
        if (airline != null) {
            result.setAirline((DictionaryReference)new AirlineReference(airline));
        }
        result.setFlightNumber(flightNumber);
        return result;
    }

    private static VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment fs(String originLocation, String destinationLocation, String departureDateTime, String arrivalDateTime) {
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment result = new VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment();
        result.setOriginLocation(new VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.OriginLocation());
        result.getOriginLocation().setLocationCode(originLocation);
        result.setDestinationLocation(new VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.DestinationLocation());
        result.getDestinationLocation().setLocationCode(destinationLocation);
        result.setDepartureDateTime(departureDateTime);
        result.setArrivalDateTime(arrivalDateTime);
        return result;
    }

    private static MessageContext wrap(VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment flightSegment) {
        VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption originDestinationOption = new VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption();
        originDestinationOption.getFlightSegmentList().add(flightSegment);
        VerifyFlightDetailsRS.OriginDestinationOptions originDestinationOptions = new VerifyFlightDetailsRS.OriginDestinationOptions();
        originDestinationOptions.getOriginDestinationOptionList().add(originDestinationOption);
        VerifyFlightDetailsRS response = new VerifyFlightDetailsRS();
        response.setOriginDestinationOptions(originDestinationOptions);
        MessageContext result = new MessageContext();
        result.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD, (Object)response);
        return result;
    }
}

