/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights;

import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SabreCustomPropertiesHelper {
    public static final String DIRECTION_IND = "DirectionInd";
    public static final String MARRIAGE_GRP = "MarriageGrp";
    private static final DateTimeFormatter DF_LAST_TICKETING_DATE = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
    public static final String LAST_TICKETING_DATE = "lastTicketingDate";
    public static final String RFIC_CODE = "RficCode";
    public static final String RFIC_SUBCODE = "RficSubcode";
    public static final String SSR_CODE = "SSRCode";
    public static final String FARE_COMPONENT_DIRECTIONALITY = "fareComponentDirectionality";
    public static final String ANCILLARY_GROUP_CODE = "GroupCode";
    public static final String ANCILLARY_SPECIAL_SERVICE_TYPE = "SpecialServiceDetailsType";
    public static final String EMD_TYPE = "EMDType";

    public static void setDirectionInd(Flight flight, String directionInd) {
        NamedValueHelper.setValueForName((String)DIRECTION_IND, (String)directionInd, (Collection)flight.getCustomProperties());
    }

    public static void setMarriageGrp(FlightSegment flightSegment, String marriageGrp) {
        NamedValueHelper.setValueForName((String)MARRIAGE_GRP, (String)marriageGrp, (Collection)flightSegment.getCustomProperties());
    }

    public static String getMarriageGrp(FlightSegment flightSegment) {
        return NamedValueHelper.getValueForName((String)MARRIAGE_GRP, (Collection)flightSegment.getCustomProperties());
    }

    public static void setLastTicketingDate(Flight flight, Date lastTicketingDate) {
        if (lastTicketingDate != null) {
            NamedValueHelper.setValueForName((String)LAST_TICKETING_DATE, (String)DF_LAST_TICKETING_DATE.print((ReadableInstant)new DateTime((Object)lastTicketingDate)), (Collection)flight.getCustomProperties());
        }
    }

    public static Date getLastTicketingDate(Flight flight) {
        String lastTicketingDateStr = NamedValueHelper.getValueForName((String)LAST_TICKETING_DATE, (Collection)flight.getCustomProperties());
        if (!StringUtils.isBlank((String)lastTicketingDateStr)) {
            return DF_LAST_TICKETING_DATE.parseDateTime(lastTicketingDateStr).toDate();
        }
        return null;
    }

    public static void setRficCode(AncillaryFee ancillaryFee, String rficCode) {
        NamedValueHelper.setValueForName((String)RFIC_CODE, (String)rficCode, (Collection)ancillaryFee.getCustomProperties());
    }

    public static String getRficCode(AncillaryFee ancillaryFee) {
        return NamedValueHelper.getValueForName((String)RFIC_CODE, (Collection)ancillaryFee.getCustomProperties());
    }

    public static void setRficSubcode(AncillaryFee ancillaryFee, String rficSubcode) {
        NamedValueHelper.setValueForName((String)RFIC_SUBCODE, (String)rficSubcode, (Collection)ancillaryFee.getCustomProperties());
    }

    public static String getRficSubcode(AncillaryFee ancillaryFee) {
        return NamedValueHelper.getValueForName((String)RFIC_SUBCODE, (Collection)ancillaryFee.getCustomProperties());
    }

    public static void setSSRCode(AncillaryFee ancillaryFee, String ssrCode) {
        NamedValueHelper.setValueForName((String)SSR_CODE, (String)ssrCode, (Collection)ancillaryFee.getCustomProperties());
    }

    public static String getSSRCode(AncillaryFee ancillaryFee) {
        return NamedValueHelper.getValueForName((String)SSR_CODE, (Collection)ancillaryFee.getCustomProperties());
    }

    public static void setFareComponentDirectionality(FareInfo fareInfo, String fareComponentDirectionality) {
        NamedValueHelper.setValueForName((String)FARE_COMPONENT_DIRECTIONALITY, (String)fareComponentDirectionality, (Collection)fareInfo.getCustomProperties());
    }

    public static String getFareComponentDirectionality(FareInfo fareInfo) {
        return NamedValueHelper.getValueForName((String)FARE_COMPONENT_DIRECTIONALITY, (Collection)fareInfo.getCustomProperties());
    }

    public static void setAncillaryGroupCode(AncillaryFee fee, String groupCode) {
        NamedValueHelper.setValueForName((String)ANCILLARY_GROUP_CODE, (String)groupCode, (Collection)fee.getCustomProperties());
    }

    public static String getAncillaryGroupCode(AncillaryFee fee) {
        return NamedValueHelper.getValueForName((String)ANCILLARY_GROUP_CODE, (Collection)fee.getCustomProperties());
    }

    public static void setSpecialServiceDetailsType(AncillaryFee fee, String type) {
        NamedValueHelper.setValueForName((String)ANCILLARY_SPECIAL_SERVICE_TYPE, (String)type, (Collection)fee.getCustomProperties());
    }

    public static String getSpecialServiceDetailsType(AncillaryFee fee) {
        return NamedValueHelper.getValueForName((String)ANCILLARY_SPECIAL_SERVICE_TYPE, (Collection)fee.getCustomProperties());
    }

    public static void setEMDType(AncillaryFee fee, String emdType) {
        NamedValueHelper.setValueForName((String)EMD_TYPE, (String)emdType, (Collection)fee.getCustomProperties());
    }

    public static String getEMDType(AncillaryFee fee) {
        return NamedValueHelper.getValueForName((String)EMD_TYPE, (Collection)fee.getCustomProperties());
    }
}

