/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights.flightDetails;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.RouteSegmentWithFlightSegments;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.VerifyFlightDetailsRS;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CalculateRouteSegmentWithFlightNumbers
extends BaseProcessor {
    private static final String DATE_TIME_PATTERN = "MM-dd'T'HH:mm";

    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Map flightDetails = (Map)ctx.getObject((Enum)IBusGdsSabreContextKeys.VERIFY_FLIGHT_DETAILS_MAP);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.ROUTE_SEGMENT_WITH_FLIGHT_SEGMENTS_LIST, CalculateRouteSegmentWithFlightNumbers.calculate(fsp, flightDetails));
    }

    private static List<RouteSegmentWithFlightSegments> calculate(FlightSearchParameters fsp, Map<RouteSegment, MessageContext> flightDetails) {
        if (flightDetails == null) {
            return fsp.getRoute().stream().map(rs -> new RouteSegmentWithFlightSegments((RouteSegment)rs, Collections.emptyList())).collect(Collectors.toList());
        }
        if (flightDetails.size() != fsp.getRoute().size()) {
            return fsp.getRoute().stream().map(rs -> new RouteSegmentWithFlightSegments((RouteSegment)rs, flightDetails.containsKey(rs) ? Collections.singletonList(CalculateRouteSegmentWithFlightNumbers.getFlightSegment((MessageContext)flightDetails.get(rs))) : Collections.emptyList())).collect(Collectors.toList());
        }
        List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment> flightSegments = fsp.getRoute().stream().map(flightDetails::get).map(CalculateRouteSegmentWithFlightNumbers::getFlightSegment).collect(Collectors.toList());
        List<List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment>> legs = CalculateRouteSegmentWithFlightNumbers.calculateLegs(flightSegments);
        ArrayList<RouteSegmentWithFlightSegments> result = new ArrayList<RouteSegmentWithFlightSegments>(legs.size());
        int idx = 0;
        for (List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment> leg : legs) {
            RouteSegment legStart = (RouteSegment)fsp.getRoute().get(idx);
            RouteSegment legEnd = (RouteSegment)fsp.getRoute().get(idx + leg.size() - 1);
            RouteSegment rs2 = CalculateRouteSegmentWithFlightNumbers.merge(legStart, legEnd);
            result.add(new RouteSegmentWithFlightSegments(rs2, leg));
            idx += leg.size();
        }
        fsp.getRoute().clear();
        fsp.getRoute().addAll(result.stream().map(RouteSegmentWithFlightSegments::getRouteSegment).collect(Collectors.toList()));
        return result;
    }

    private static RouteSegment merge(RouteSegment legStart, RouteSegment legEnd) {
        RouteSegment rs = new RouteSegment();
        rs.setLocationBegin(legStart.getLocationBegin());
        rs.setLocationEnd(legEnd.getLocationEnd());
        rs.setDate(legStart.getDate());
        rs.setDepartureTimeBegin(legStart.getDepartureTimeBegin());
        rs.setDepartureTimeEnd(legStart.getDepartureTimeEnd());
        rs.setArrivalTimeBegin(legEnd.getArrivalTimeBegin());
        rs.setArrivalTimeEnd(legEnd.getArrivalTimeEnd());
        return rs;
    }

    private static List<List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment>> calculateLegs(List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment> segments) {
        try {
            ArrayList<List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment>> result = new ArrayList();
            ArrayList<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment> currentLeg = null;
            VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment lastSegment = null;
            for (VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment segment : segments) {
                if (currentLeg == null) {
                    currentLeg = new ArrayList<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment>();
                }
                if (lastSegment == null) {
                    currentLeg.add(segment);
                } else {
                    DictionaryReference<GeoLocation> arrivalCity = CalculateRouteSegmentWithFlightNumbers.getCity(lastSegment.getDestinationLocation().getLocationCode());
                    DictionaryReference<GeoLocation> departureCity = CalculateRouteSegmentWithFlightNumbers.getCity(segment.getOriginLocation().getLocationCode());
                    LocalDateTime arrivalDateTime = SabreHelper.parseLocalDateTimeWithoutYear((String)lastSegment.getArrivalDateTime(), (String)DATE_TIME_PATTERN);
                    LocalDateTime departureDateTime = SabreHelper.parseLocalDateTimeWithoutYear((String)segment.getDepartureDateTime(), (String)DATE_TIME_PATTERN);
                    if (!arrivalCity.equals(departureCity) || Duration.between(arrivalDateTime, departureDateTime).toHours() > 24L) {
                        result.add(currentLeg);
                        currentLeg = new ArrayList();
                    }
                    currentLeg.add(segment);
                }
                lastSegment = segment;
            }
            result.add(currentLeg);
            result = result.stream().flatMap(CalculateRouteSegmentWithFlightNumbers::splitSameDayRoundtrip).collect(Collectors.toList());
            return result;
        }
        catch (Exception ex) {
            IncidentsLog.reportException((String)"calculateLegs failed", (Throwable)ex);
            return segments.stream().map(Collections::singletonList).collect(Collectors.toList());
        }
    }

    private static Stream<List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment>> splitSameDayRoundtrip(List<VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment> leg) {
        if (leg.size() > 1) {
            DictionaryReference<GeoLocation> cityTo;
            VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment firstSegment = leg.get(0);
            VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment lastSegment = leg.get(leg.size() - 1);
            DictionaryReference<GeoLocation> cityFrom = CalculateRouteSegmentWithFlightNumbers.getCity(firstSegment.getOriginLocation().getLocationCode());
            if (cityFrom.equals(cityTo = CalculateRouteSegmentWithFlightNumbers.getCity(lastSegment.getDestinationLocation().getLocationCode()))) {
                if (leg.size() % 2 == 0) {
                    int middleIdx = leg.size() / 2;
                    List outboundCities = Stream.concat(Stream.of(CalculateRouteSegmentWithFlightNumbers.getCity(leg.get(0).getOriginLocation().getLocationCode())), leg.subList(0, middleIdx).stream().map(VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment::getDestinationLocation).map(VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.DestinationLocation::getLocationCode).map(CalculateRouteSegmentWithFlightNumbers::getCity)).collect(Collectors.toList());
                    List inboundCitiesReverse = Stream.concat(Stream.of(CalculateRouteSegmentWithFlightNumbers.getCity(leg.get(middleIdx).getOriginLocation().getLocationCode())), leg.subList(middleIdx, leg.size()).stream().map(VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment::getDestinationLocation).map(VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.DestinationLocation::getLocationCode).map(CalculateRouteSegmentWithFlightNumbers::getCity)).collect(Collectors.toList());
                    Collections.reverse(inboundCitiesReverse);
                    if (outboundCities.equals(inboundCitiesReverse)) {
                        return Stream.of(leg.subList(0, middleIdx), leg.subList(middleIdx, leg.size()));
                    }
                }
                return leg.stream().map(Collections::singletonList);
            }
        }
        return Stream.of(leg);
    }

    private static DictionaryReference<GeoLocation> getCity(String code) {
        return ((GeoLocation)DictionaryCache.get().resolveReference(SabreHelper.resolveNativeCode(GeoLocation.class, (String)code))).getParent();
    }

    private static VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment getFlightSegment(MessageContext subctx) {
        VerifyFlightDetailsRS response = (VerifyFlightDetailsRS)subctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        return (VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment)CollectionUtil.single((Collection)((VerifyFlightDetailsRS.OriginDestinationOptions.OriginDestinationOption)CollectionUtil.single((Collection)response.getOriginDestinationOptions().getOriginDestinationOptionList())).getFlightSegmentList());
    }
}

