/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchFlights.flightDetails;

import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.VerifyFlightDetailsRQ;
import org.apache.commons.lang.time.FastDateFormat;

public class VerifyFlightDetailsRQBuilder
extends BaseProcessor {
    private static final FastDateFormat DF_SEGMENT = FastDateFormat.getInstance((String)"MM-dd'T'HH:mm");

    public void process(MessageContext ctx) throws Exception {
        RouteSegment segment = (RouteSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ROUTE_SEGMENT);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)VerifyFlightDetailsRQBuilder.buildRequest(segment));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"VerifyFlightDetailsLLSRQ");
    }

    private static VerifyFlightDetailsRQ buildRequest(RouteSegment segment) {
        VerifyFlightDetailsRQ request = new VerifyFlightDetailsRQ();
        VerifyFlightDetailsRQ.OriginDestinationInformation odi = new VerifyFlightDetailsRQ.OriginDestinationInformation();
        VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment fs = new VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment();
        fs.setDepartureDateTime(DF_SEGMENT.format(segment.getDate()));
        fs.setFlightNumber(segment.getFlightNumber());
        VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.MarketingAirline marketingAirline = new VerifyFlightDetailsRQ.OriginDestinationInformation.FlightSegment.MarketingAirline();
        marketingAirline.setCode(SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()));
        fs.setMarketingAirline(marketingAirline);
        odi.setFlightSegment(fs);
        request.setOriginDestinationInformation(odi);
        request.setVersion("2.0.1");
        return request;
    }
}

