/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchSchedule;

import com.gridnine.xtrip.common.gds.model.ScheduleSearchParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirScheduleRQ;
import com.sabre.webservices.sabrexml.OTAAirScheduleRS;
import java.time.format.DateTimeFormatter;

public class OTAAirScheduleRQBuilder
extends BaseProcessor {
    private static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("MM-dd");
    private static final DateTimeFormatter TF = DateTimeFormatter.ofPattern("HH:mm");

    public void process(MessageContext ctx) throws Exception {
        Object response = ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        ScheduleSearchParameters parameters = null;
        if (response == null || !(response instanceof OTAAirScheduleRS)) {
            parameters = (ScheduleSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.SCHEDULE_SEARCH_PARAMETERS);
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)this.buildRequest(parameters));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_AirScheduleLLSRQ");
    }

    private OTAAirScheduleRQ buildRequest(ScheduleSearchParameters parameters) {
        OTAAirScheduleRQ request = new OTAAirScheduleRQ();
        request.setVersion("2.2.0");
        request.setReturnHostCommand(Boolean.TRUE);
        if (parameters != null) {
            OTAAirScheduleRQ.OriginDestinationInformation odi = new OTAAirScheduleRQ.OriginDestinationInformation();
            odi.setFlightSegmentOriginLocation(SabreHelper.getNativeCode((DictionaryReference)parameters.getLocationBegin()));
            odi.setFlightSegmentDestinationLocation(SabreHelper.getNativeCode((DictionaryReference)parameters.getLocationEnd()));
            if (parameters.getDate() != null) {
                odi.setFlightSegmentDepartureDateTime(DF.format(parameters.getDate()));
            }
            request.setOriginDestinationInformation(odi);
        }
        OTAAirScheduleRQ.OptionalQualifiers oq = new OTAAirScheduleRQ.OptionalQualifiers();
        if (parameters != null) {
            OTAAirScheduleRQ.OptionalQualifiers.FlightQualifiers fq = new OTAAirScheduleRQ.OptionalQualifiers.FlightQualifiers();
            fq.setExtendedSearch(Boolean.TRUE);
            if (parameters.isDirectOnly()) {
                fq.setDirectOnly(Boolean.TRUE);
            }
            if (parameters.getAirline() != null) {
                OTAAirScheduleRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs vp = new OTAAirScheduleRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs();
                OTAAirScheduleRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs.Airline airline = new OTAAirScheduleRQ.OptionalQualifiers.FlightQualifiers.VendorPrefs.Airline();
                airline.setCode(SabreHelper.getNativeCode((DictionaryReference)parameters.getAirline()));
                vp.getAirlineList().add(airline);
                fq.setVendorPrefs(vp);
            }
            oq.setFlightQualifiers(fq);
            if (parameters.getTimeStart() != null || parameters.getTimeEnd() != null) {
                OTAAirScheduleRQ.OptionalQualifiers.TimeQualifiers tq = new OTAAirScheduleRQ.OptionalQualifiers.TimeQualifiers();
                OTAAirScheduleRQ.OptionalQualifiers.TimeQualifiers.DepartureTime dt = new OTAAirScheduleRQ.OptionalQualifiers.TimeQualifiers.DepartureTime();
                if (parameters.getTimeStart() != null) {
                    dt.setWindowAfter(TF.format(parameters.getTimeStart()));
                }
                if (parameters.getTimeEnd() != null) {
                    dt.setWindowBefore(TF.format(parameters.getTimeEnd()));
                }
                tq.setDepartureTime(dt);
                oq.setTimeQualifiers(tq);
            }
        } else {
            OTAAirScheduleRQ.OptionalQualifiers.AdditionalAvailability aa = new OTAAirScheduleRQ.OptionalQualifiers.AdditionalAvailability();
            aa.setInd(true);
            oq.setAdditionalAvailability(aa);
        }
        request.setOptionalQualifiers(oq);
        return request;
    }
}

