/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchSchedule;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.ScheduleFlight;
import com.gridnine.xtrip.common.gds.model.ScheduleFlightSegment;
import com.gridnine.xtrip.common.gds.model.ScheduleSearchParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTAAirScheduleRS;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class OTAAirScheduleRSParser
extends BaseProcessor {
    private static final String DATE_TIME_PATTERN = "MM-dd'T'HH:mm";
    private static final String DATE_PATTERN = "MM-dd";
    private static final Map<String, Integer> BASE_OFFSETS = new HashMap<String, Integer>();

    public void process(MessageContext ctx) throws Exception {
        ScheduleSearchParameters ssp = (ScheduleSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.SCHEDULE_SEARCH_PARAMETERS);
        OTAAirScheduleRS response = (OTAAirScheduleRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        ArrayList<ScheduleFlight> result = (ArrayList<ScheduleFlight>)ctx.getObject((Enum)IBusGdsContextKeys.SCHEDULE_FLIGHTS);
        if (result == null) {
            result = new ArrayList<ScheduleFlight>();
            ctx.putObject((Enum)IBusGdsContextKeys.SCHEDULE_FLIGHTS, result);
        }
        if (response.getOriginDestinationOptions().getOriginDestinationOptionList() != null) {
            for (OTAAirScheduleRS.OriginDestinationOptions.OriginDestinationOption odo : response.getOriginDestinationOptions().getOriginDestinationOptionList()) {
                ScheduleFlightSegment sfs;
                if (ssp.isDirectOnly() && odo.getFlightSegmentList().size() > 1) {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.SCHEDULE_LOOP_BREAK, (Object)Boolean.TRUE);
                    break;
                }
                ScheduleFlight sf = new ScheduleFlight();
                sf.setGds(GdsName.SABRE);
                for (Object fs : odo.getFlightSegmentList()) {
                    sfs = new ScheduleFlightSegment();
                    sfs.setAirline(SabreHelper.resolveNativeCode(Airline.class, (String)fs.getMarketingAirline().getCode()));
                    sfs.setBoard(SabreHelper.resolveNativeCode(Aircraft.class, (String)fs.getEquipment().getAirEquipType()));
                    sfs.setFlightNumber(fs.getFlightNumber());
                    sfs.setLocationBegin(SabreHelper.resolveNativeCode(GeoLocation.class, (String)fs.getOriginLocation().getLocationCode()));
                    sfs.setLocationEnd(SabreHelper.resolveNativeCode(GeoLocation.class, (String)fs.getDestinationLocation().getLocationCode()));
                    LocalDateTime departureDateTime = SabreHelper.parseLocalDateTimeWithoutYear((String)fs.getDepartureDateTime(), (String)DATE_TIME_PATTERN);
                    LocalDateTime arrivalDateTime = SabreHelper.parseLocalDateTimeWithoutYear((String)fs.getArrivalDateTime(), (String)DATE_TIME_PATTERN);
                    sfs.setStartDate(departureDateTime.toLocalDate());
                    sfs.setStartTime(departureDateTime.toLocalTime());
                    sfs.setEndDate(arrivalDateTime.toLocalDate());
                    sfs.setEndTime(arrivalDateTime.toLocalTime());
                    sfs.setDateDelta(Period.between(departureDateTime.toLocalDate(), arrivalDateTime.toLocalDate()).getDays());
                    if (odo.getFlightSegmentList().size() == 1) {
                        if (response.getOriginDestinationOptions().getTimeZoneDifference() != null) {
                            sfs.setTravelDuration(Integer.valueOf((int)Duration.between(departureDateTime, arrivalDateTime).toMinutes() - 60 * Integer.parseInt(this.clearUnicodeLatin1Supplement(response.getOriginDestinationOptions().getTimeZoneDifference()))));
                        } else if (response.getOriginDestinationOptions().getOriginTimeZone() != null && response.getOriginDestinationOptions().getDestinationTimeZone() != null) {
                            int departureOffset = OTAAirScheduleRSParser.parseOffset(response.getOriginDestinationOptions().getOriginTimeZone(), null);
                            int arrivalOffset = OTAAirScheduleRSParser.parseOffset(response.getOriginDestinationOptions().getDestinationTimeZone(), departureOffset);
                            OffsetDateTime departureDateTimeWithTZ = departureDateTime.atOffset(ZoneOffset.ofHoursMinutes(departureOffset / 60, departureOffset % 60));
                            OffsetDateTime arrivalDateTimeWithTZ = arrivalDateTime.atOffset(ZoneOffset.ofHoursMinutes(arrivalOffset / 60, arrivalOffset % 60));
                            sfs.setTravelDuration(Integer.valueOf((int)Duration.between(departureDateTimeWithTZ, arrivalDateTimeWithTZ).toMinutes()));
                        }
                    }
                    if (sfs.getTravelDuration() == null) {
                        sfs.setTravelDuration(GdsDictHelper.getTravelDuration((DictionaryReference)sfs.getLocationBegin(), (DictionaryReference)sfs.getLocationEnd(), (LocalDateTime)LocalDateTime.of(sfs.getStartDate(), sfs.getStartTime()), (LocalDateTime)LocalDateTime.of(sfs.getEndDate(), sfs.getEndTime())));
                    }
                    if (fs.getOperatingAirline() != null) {
                        DictionaryReference<Airline> airlineRef;
                        String code = fs.getOperatingAirline().getCode();
                        if ("**".equals(code)) {
                            List textList = fs.getDisclosureAirline().getTextList();
                            String spellVariant = SabreServerHelper.getSpellVariantFrom(textList.toArray(new String[0]));
                            airlineRef = SabreServerHelper.findOrCreateAirlineBySpellVariant(spellVariant);
                        } else {
                            airlineRef = SabreHelper.resolveNativeCode(Airline.class, (String)code);
                        }
                        sfs.setOperatingAirline((DictionaryReference)airlineRef);
                    } else {
                        sfs.setOperatingAirline(sfs.getAirline());
                    }
                    for (OTAAirScheduleRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.BookingClassAvail bca : fs.getBookingClassAvailList()) {
                        CollectionUtil.addIfNotNull((Collection)sfs.getAvailableClasses(), (Object)FlightHelper.findClassOfService((DictionaryReference)sfs.getAirline(), (DictionaryReference)sfs.getOperatingAirline(), (String)bca.getResBookDesigCode(), (boolean)DictHelper.isInternational((DictionaryReference)sfs.getLocationBegin(), (DictionaryReference)sfs.getLocationEnd())));
                    }
                    OTAAirScheduleRS.OriginDestinationOptions.OriginDestinationOption.FlightSegment.DaysOfOperation.OperationSchedule.OperationTimes.OperationTime operationTime = fs.getDaysOfOperation().getOperationSchedule().getOperationTimes().getOperationTime();
                    if (Boolean.TRUE.equals(operationTime.getMon())) {
                        sfs.getOperationDays().add(DayOfWeek.MONDAY);
                    }
                    if (Boolean.TRUE.equals(operationTime.getTue())) {
                        sfs.getOperationDays().add(DayOfWeek.TUESDAY);
                    }
                    if (Boolean.TRUE.equals(operationTime.getWeds())) {
                        sfs.getOperationDays().add(DayOfWeek.WEDNESDAY);
                    }
                    if (Boolean.TRUE.equals(operationTime.getThur())) {
                        sfs.getOperationDays().add(DayOfWeek.THURSDAY);
                    }
                    if (Boolean.TRUE.equals(operationTime.getFri())) {
                        sfs.getOperationDays().add(DayOfWeek.FRIDAY);
                    }
                    if (Boolean.TRUE.equals(operationTime.getSat())) {
                        sfs.getOperationDays().add(DayOfWeek.SATURDAY);
                    }
                    if (Boolean.TRUE.equals(operationTime.getSun())) {
                        sfs.getOperationDays().add(DayOfWeek.SUNDAY);
                    }
                    sfs.setOperationStartDate(SabreHelper.parseLocalDateWithoutYear((String)fs.getFlightDetails().getEffectiveDate(), (String)DATE_PATTERN));
                    sfs.setOperationEndDate(SabreHelper.parseLocalDateWithoutYear((String)fs.getFlightDetails().getDiscontinueDate(), (String)DATE_PATTERN));
                    if (sfs.getOperationStartDate().isAfter(sfs.getOperationEndDate())) {
                        sfs.setOperationStartDate(sfs.getOperationStartDate().minusYears(1L));
                    }
                    sf.getSegments().add(sfs);
                }
                if (((GeoLocation)DictionaryCache.get().resolveReference(ssp.getLocationBegin())).getType() == LocationType.AIRPORT && !MiscUtil.equals((Object)((ScheduleFlightSegment)sf.getSegments().get(0)).getLocationBegin(), (Object)ssp.getLocationBegin()) || ((GeoLocation)DictionaryCache.get().resolveReference(ssp.getLocationEnd())).getType() == LocationType.AIRPORT && !MiscUtil.equals((Object)((ScheduleFlightSegment)sf.getSegments().get(sf.getSegments().size() - 1)).getLocationEnd(), (Object)ssp.getLocationEnd())) {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.SCHEDULE_LOOP_BREAK, (Object)Boolean.TRUE);
                    break;
                }
                boolean include = true;
                if (ssp.getDate() != null) {
                    Object fs;
                    include = false;
                    fs = sf.getSegments().iterator();
                    while (fs.hasNext()) {
                        sfs = (ScheduleFlightSegment)fs.next();
                        if (!OTAAirScheduleRSParser.isDateInsideOperationPeriod(ssp.getDate(), sfs)) continue;
                        include = true;
                        break;
                    }
                    if (include) {
                        include = false;
                        DayOfWeek dayOfWeek = ssp.getDate().getDayOfWeek();
                        for (ScheduleFlightSegment sfs2 : sf.getSegments()) {
                            if (!sfs2.getOperationDays().contains(dayOfWeek)) continue;
                            include = true;
                            break;
                        }
                    }
                }
                if (!include) continue;
                result.add(sf);
            }
        }
    }

    public String clearUnicodeLatin1Supplement(String text) {
        int[] cps = text.codePoints().filter(cp -> !Character.UnicodeBlock.LATIN_1_SUPPLEMENT.equals(Character.UnicodeBlock.of(cp))).toArray();
        return new String(cps, 0, cps.length);
    }

    private static boolean isDateInsideOperationPeriod(LocalDate date, ScheduleFlightSegment sfs) {
        if (sfs.getOperationStartDate() != null && date.isBefore(sfs.getOperationStartDate())) {
            return false;
        }
        if (sfs.getOperationEndDate() != null) {
            return !date.isAfter(sfs.getOperationEndDate());
        }
        return true;
    }

    public static int parseOffset(String data, Integer relativeOffset) {
        int offsetSign = 1;
        int idx = data.indexOf(135);
        if (idx == -1) {
            idx = data.indexOf(45);
            offsetSign = -1;
        }
        String base = null;
        int offset = 0;
        if (idx == -1) {
            base = data;
        } else {
            offset = offsetSign * Integer.parseInt(data.substring(idx + 1));
            if (idx > 0) {
                base = data.substring(0, idx);
            }
        }
        if (!StringUtils.isBlank((String)base)) {
            if (!BASE_OFFSETS.containsKey(base)) {
                throw Xeption.forDeveloper((String)"unknown base offset '{0}'", (Object[])new Object[]{base});
            }
            return BASE_OFFSETS.get(base) + offset;
        }
        if (relativeOffset != null) {
            return relativeOffset + offset;
        }
        throw Xeption.forDeveloper((String)"no base and no relative offset, data = '{0}'", (Object[])new Object[]{data});
    }

    static {
        BASE_OFFSETS.put("Z", 0);
        BASE_OFFSETS.put("EST", -5);
        BASE_OFFSETS.put("EDT", -4);
        BASE_OFFSETS.put("CST", -6);
        BASE_OFFSETS.put("CDT", -5);
        BASE_OFFSETS.put("AST", -4);
        BASE_OFFSETS.put("ADT", -3);
        BASE_OFFSETS.put("MST", -7);
        BASE_OFFSETS.put("MDT", -6);
        BASE_OFFSETS.put("PST", -8);
        BASE_OFFSETS.put("PDT", -7);
        BASE_OFFSETS.put("HST", -10);
    }
}

